--@input float curTime = 0.0{"widget":"slider","min":0,"max":3.0}

local exports = exports or {}
local SeekModeScript = SeekModeScript or {}
SeekModeScript.__index = SeekModeScript

 

function SeekModeScript.new(construct, ...)
    local self = setmetatable({}, SeekModeScript)
    if construct and SeekModeScript.constructor then SeekModeScript.constructor(self, ...) end
    self.startTime = 0.0
    self.endTime = 3.0
    self.curTime = 0.0
    self.width = 0
    self.height = 0
    return self
end

function SeekModeScript:constructor()

end

function SeekModeScript:onUpdate(comp, detalTime)
    --
    -- local props = comp.entity:getComponent("ScriptComponent").properties
    -- if props:has("curTime") then
    --     self:seekToTime(comp, props:get("curTime") - self.startTime)
    -- end
    --
    --self.curTime =self.curTime + detalTime
    self:seekToTime(comp, self.curTime - self.startTime)
end

function SeekModeScript:onStart(comp)
    self.EASpeed = 1.0
    self.animSeqCom = comp.entity.scene:findEntityBy("Pass5"):getComponent("AnimSeqComponent")
    self.animSeqCom1 = comp.entity.scene:findEntityBy("Pass7"):getComponent("AnimSeqComponent")

    self.pass0Material = comp.entity.scene:findEntityBy("Pass0"):getComponent("MeshRenderer").material
    self.pass1Material = comp.entity.scene:findEntityBy("Pass1"):getComponent("MeshRenderer").material
    -- self.pass2Material = comp.entity.scene:findEntityBy("Pass2"):getComponent("MeshRenderer").material
    self.pass3Material = comp.entity:getComponent("MeshRenderer").material
    self.pass4Material = comp.entity.scene:findEntityBy("Pass4"):getComponent("MeshRenderer").material
    self.pass5Material = comp.entity.scene:findEntityBy("Pass5"):getComponent("MeshRenderer").material
    self.pass6mat = comp.entity.scene:findEntityBy("Pass6"):getComponent("MeshRenderer").material
    self.pass7Material = comp.entity.scene:findEntityBy("Pass7"):getComponent("MeshRenderer").material
    self.camera0 = comp.entity.scene:findEntityBy("CameraPass0"):getComponent("Camera")
    self.camera1 = comp.entity.scene:findEntityBy("CameraPass1"):getComponent("Camera")
    self.camera3 = comp.entity.scene:findEntityBy("CameraPass3"):getComponent("Camera")
    self.camera4 = comp.entity.scene:findEntityBy("CameraPass4"):getComponent("Camera")
    self.pass0Material:setInt("blurRadius",8*0.2)
    self.pass1Material:setInt("blurRadius",8*0.2)
    self.pass6mat:setFloat("k", 1)
    self.pass4Material:setFloat("sharpness",5*0.5)
end

function SeekModeScript:seekToTime(comp, time)

    self.animSeqCom:seekToTime(time * self.EASpeed)
    self.animSeqCom1:seekToTime(time * self.EASpeed)

    local w = Amaz.BuiltinObject:getInputTextureWidth()
    local h = Amaz.BuiltinObject:getInputTextureHeight()
    if w ~= self.width or h ~= self.height then
        self.width = w
        self.height = h
        -- adaptive max side length 
        local standard_side = 440
        local max_side = math.max(w,h)
        if max_side>1000 then
            standard_side = max_side*standard_side/1000*1.1
        end
        -- Amaz.LOGI("+++++++",max_side)
        local zoom_factor = standard_side/max_side
        local mW = self.width*zoom_factor
        local mH = self.height*zoom_factor
        self.pass0Material:setInt("imageWidth", mW)
        self.pass0Material:setInt("imageHeight", mH)
        self.pass1Material:setInt("imageWidth", mW)
        self.pass1Material:setInt("imageHeight", mH)
        self.camera0.renderTexture.width = mW
        self.camera0.renderTexture.height = mH
        self.camera1.renderTexture.width = mW
        self.camera1.renderTexture.height = mH
        -- mW = self.width*0.35
        -- mH = self.height*0.35
        self.pass3Material:setInt("imageWidth", mW)
        self.pass3Material:setInt("imageHeight", mH)
        self.pass4Material:setInt("imageWidth", mW)
        self.pass4Material:setInt("imageHeight", mH)
        self.camera3.renderTexture.width = mW
        self.camera3.renderTexture.height = mH
        -- self.camera4.renderTexture.width = mW
        -- self.camera4.renderTexture.height = mH
        self.pass5Material:setInt("baseTexWidth", w)
        self.pass5Material:setInt("baseTexHeight", h)
        self.pass7Material:setInt("baseTexWidth", w)
        self.pass7Material:setInt("baseTexHeight", h)
    end

    local sharpenRadius = 2
    self.pass3Material:setInt("blurRadius",sharpenRadius)
    self.pass4Material:setInt("blurRadius",sharpenRadius)

end

function SeekModeScript:onEvent(sys, event)
    if "effects_adjust_blur" == event.args:get(0) then
        local intensity = event.args:get(1)
        -- self.pass0Material:setInt("blurRadius",8*intensity)
        -- self.pass1Material:setInt("blurRadius",8*intensity)
        self.pass0Material:setInt("u_BLURSTEP", 5*intensity)
        self.pass1Material:setInt("u_BLURSTEP", 5*intensity)
    end
    if "effects_adjust_speed" == event.args:get(0) then
        local intensity = event.args:get(1)
        self.EASpeed = 1.5*intensity+0.5
    end
    if "effects_adjust_filter" == event.args:get(0) then
        local intensity = event.args:get(1)
        self.pass6mat:setFloat("k", intensity)
    end
    if "effects_adjust_sharpen" == event.args:get(0) then
        local intensity = event.args:get(1)
        self.pass4Material:setFloat("sharpness",5*intensity)
    end
end


exports.SeekModeScript = SeekModeScript
return exports
