#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    int u_BLURSTEP;
    int imageWidth;
    int imageHeight;
    float2 blurStep;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], sampler inputImageTextureSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _184 = buffer.blurStep / float2(float(buffer.imageWidth), float(buffer.imageHeight));
    float4 _266;
    float _267;
    _267 = 1.0;
    _266 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0) * 1.0;
    float4 _235;
    float _239;
    for (int _265 = 1; _265 <= 1024; _267 = _239, _266 = _235, _265++)
    {
        if (_265 > buffer.u_BLURSTEP)
        {
            break;
        }
        float _205 = float(_265);
        float _264 = exp(_205 * (-0.0044642859138548374176025390625));
        _235 = (_266 + (inputImageTexture.sample(inputImageTextureSmplr, (in.uv0 + (_184 * _205))) * _264)) + (inputImageTexture.sample(inputImageTextureSmplr, (in.uv0 + (_184 * float(-_265)))) * _264);
        _239 = fma(_264, 2.0, _267);
    }
    out.gl_FragColor = _266 / float4(_267);
    return out;
}

