#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    int baseTexWidth;
    int baseTexHeight;
    float2 fullBlendTexSize;
    float2 direction;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], texture2d<float> _MainTex [[texture(1)]], sampler inputImageTextureSmplr [[sampler(0)]], sampler _MainTexSmplr [[sampler(1)]])
{
    main0_out out = {};
    float _183 = float(buffer.baseTexWidth);
    float _186 = float(buffer.baseTexHeight);
    float2 _187 = float2(_183, _186);
    float _411;
    if ((_186 / _183) >= (buffer.fullBlendTexSize.y / buffer.fullBlendTexSize.x))
    {
        _411 = _186 / buffer.fullBlendTexSize.y;
    }
    else
    {
        _411 = _183 / buffer.fullBlendTexSize.x;
    }
    float4 _228 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0);
    float4 _248 = inputImageTexture.sample(inputImageTextureSmplr, fma(float2(1.0) / _187, buffer.direction, in.uv0));
    float4 _396 = _228;
    _396.x = _248.x;
    float4 _399 = _396;
    _399.y = _248.y;
    float2 _352 = (fma(in.uv0, _187, -(_187 * 0.5)) / (buffer.fullBlendTexSize * _411)) + float2(0.5);
    bool _299 = all(float2(0.0) < _352);
    bool _305;
    if (_299)
    {
        _305 = all(_352 < float2(1.0));
    }
    else
    {
        _305 = _299;
    }
    float4 _413;
    if (_305)
    {
        float2 _402 = _352;
        _402.y = 1.0 - _352.y;
        float4 _313 = _MainTex.sample(_MainTexSmplr, _402);
        float _360 = _313.w;
        float3 _361 = float3(_360);
        float4 _410 = float4(mix(_399.xyz, float4(fast::clamp(_313.xyz / _361, float3(0.0), float3(1.0)), _360).xyz, _361), 1.0);
        _410.w = mix(_228.w, _360, _360);
        _413 = _410;
    }
    else
    {
        _413 = _399;
    }
    out.gl_FragColor = _413;
    return out;
}

