#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    int imageWidth;
    int imageHeight;
    float2 blurStep;
    float sharpness;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], texture2d<float> firstBlurTexture [[texture(1)]], sampler inputImageTextureSmplr [[sampler(0)]], sampler firstBlurTextureSmplr [[sampler(1)]])
{
    main0_out out = {};
    float2 _191 = buffer.blurStep / float2(float(buffer.imageWidth), float(buffer.imageHeight));
    float4 _268;
    float _269;
    _269 = 1.0;
    _268 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0) * 1.0;
    for (int _267 = 1; _267 <= 2; )
    {
        float _207 = float(_267);
        float _266 = exp(_207 * (-0.0044642859138548374176025390625));
        _269 = fma(_266, 2.0, _269);
        _268 = (_268 + (inputImageTexture.sample(inputImageTextureSmplr, (in.uv0 + (_191 * _207))) * _266)) + (inputImageTexture.sample(inputImageTextureSmplr, (in.uv0 + (_191 * float(-_267)))) * _266);
        _267++;
        continue;
    }
    float4 _158 = firstBlurTexture.sample(firstBlurTextureSmplr, in.uv0);
    out.gl_FragColor = _158 + ((_158 - (_268 / float4(_269))) * buffer.sharpness);
    return out;
}

