#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    int imageWidth;
    int imageHeight;
    float2 blurStep;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], sampler inputImageTextureSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _177 = buffer.blurStep / float2(float(buffer.imageWidth), float(buffer.imageHeight));
    float4 _254;
    float _255;
    _255 = 1.0;
    _254 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0) * 1.0;
    for (int _253 = 1; _253 <= 2; )
    {
        float _193 = float(_253);
        float _252 = exp(_193 * (-0.0044642859138548374176025390625));
        _255 = fma(_252, 2.0, _255);
        _254 = (_254 + (inputImageTexture.sample(inputImageTextureSmplr, (in.uv0 + (_177 * _193))) * _252)) + (inputImageTexture.sample(inputImageTextureSmplr, (in.uv0 + (_177 * float(-_253)))) * _252);
        _253++;
        continue;
    }
    out.gl_FragColor = _254 / float4(_255);
    return out;
}

