#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    int baseTexWidth;
    int baseTexHeight;
    float2 fullBlendTexSize;
    float2 direction;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], texture2d<float> _MainTex [[texture(1)]], sampler inputImageTextureSmplr [[sampler(0)]], sampler _MainTexSmplr [[sampler(1)]])
{
    main0_out out = {};
    float _219 = float(buffer.baseTexWidth);
    float _222 = float(buffer.baseTexHeight);
    float2 _223 = float2(_219, _222);
    float _497;
    if ((_222 / _219) >= (buffer.fullBlendTexSize.y / buffer.fullBlendTexSize.x))
    {
        _497 = _222 / buffer.fullBlendTexSize.y;
    }
    else
    {
        _497 = _219 / buffer.fullBlendTexSize.x;
    }
    float4 _263 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0);
    float4 _283 = inputImageTexture.sample(inputImageTextureSmplr, fma(float2(1.0) / _223, buffer.direction, in.uv0));
    float _287 = _283.x;
    float4 _476 = _263;
    _476.x = _287;
    float _290 = _283.y;
    float4 _479 = _476;
    _479.y = _290;
    float2 _387 = (fma(in.uv0, _223, -(_223 * 0.5)) / (buffer.fullBlendTexSize * _497)) + float2(0.5);
    bool _334 = all(float2(0.0) < _387);
    bool _340;
    if (_334)
    {
        _340 = all(_387 < float2(1.0));
    }
    else
    {
        _340 = _334;
    }
    float4 _499;
    if (_340)
    {
        float2 _482 = _387;
        _482.y = 1.0 - _387.y;
        float4 _348 = _MainTex.sample(_MainTexSmplr, _482);
        float _395 = _348.w;
        float3 _396 = float3(_395);
        float3 _400 = fast::clamp(_348.xyz / _396, float3(0.0), float3(1.0));
        float4 _496 = float4(mix(_479.xyz, float3(fma(_287 - 1.0, 1.0 - _400.x, 1.0), fma(_290 - 1.0, 1.0 - _400.y, 1.0), fma(_263.z - 1.0, 1.0 - _400.z, 1.0)), _396), 1.0);
        _496.w = mix(_263.w, _395, _395);
        _499 = _496;
    }
    else
    {
        _499 = _479;
    }
    out.gl_FragColor = _499;
    return out;
}

