      
local isEditor = (Amaz.Macros and Amaz.Macros.EditorSDK) and true or false
local exports = exports or {}
local SeekModeScript = SeekModeScript or {}
SeekModeScript.__index = SeekModeScript
---@class SeekModeScript : ScriptComponent
---@field progress number [UI(Range={0, 1}, Slider)]
---@field duration number
---@field autoPlay boolean
---@field frameByFrame boolean
---@field iTime number
---@field convergence number
---@field u_fov number

function SeekModeScript.new(construct, ...)
    local self = setmetatable({}, SeekModeScript)
    self.startTime = 0.0
    self.endTime = 3.0
    self.width = 0
    self.height = 0
    self.progress = 0.0
    self.autoPlay = true
    self.curTime = 0.0
    self.duration = 1.0

    self.inCornerPosition = Amaz.Vector2f(0, 0)
    self.inFoldPosition = Amaz.Vector2f(0, 0)
    self.iTime = 0
    self.foldRadius = 0
    self.back_offset = Amaz.Vector2f(0, 0)

    self.convergence = 44
    self.u_fov = 40

    if construct and SeekModeScript.constructor then SeekModeScript.constructor(self, ...) end
    return self
end

function SeekModeScript:constructor()

end

function SeekModeScript:onStart(comp)

    self.base_mat = comp.entity.scene:findEntityBy("base"):getComponent("MeshRenderer").material
    self.fov_mat = comp.entity.scene:findEntityBy("fov"):getComponent("MeshRenderer").material
    self.radial_blur_mat = comp.entity.scene:findEntityBy("radial_blur"):getComponent("MeshRenderer").material
    self.final_mat = comp.entity.scene:findEntityBy("final"):getComponent("MeshRenderer").material
    
    if isEditor then
        self.input1 = comp.entity.scene.assetMgr:SyncLoad("image/1.png")
        self.input2 = comp.entity.scene.assetMgr:SyncLoad("image/2.png")
    end

    local AETools = includeRelativePath("AETools")
    local AEData = includeRelativePath("AEData")

    self.utils = includeRelativePath("LRCUtils")

    self.attrs1 = AETools.new(AEData.ae_attribute1)
    
end

function SeekModeScript:_AutoPlay(deltaTime)
    if self.autoPlay == true and isEditor then
        self.curTime = (self.curTime + deltaTime) % self.duration
        self.progress = self.curTime / self.duration
    else
        self.curTime = 0
    end
end

function SeekModeScript:onUpdate(comp, deltaTime)
    -- Amaz.LOGI("lrc", tostring(Amaz.Vector2f(1,1)))
    self.width = Amaz.BuiltinObject:getInputTextureWidth()
    self.height = Amaz.BuiltinObject:getInputTextureHeight()

    self:_AutoPlay(deltaTime)
    local input1 = Amaz.BuiltinObject.getUserTexture("#TransitionInput0")
    local input2 = Amaz.BuiltinObject.getUserTexture("#TransitionInput1")
    if input1 and input2 then
        self.input1 = input1
        self.input2 = input2
        self.curTime = Amaz.Input.frameTimestamp
        self.progress = Amaz.Input.frameTimestamp
    end

    local p = self.progress
    -- if isEditor then
    --     p = math.floor(p*self.attrs1:getFrameCount())/self.attrs1:getFrameCount()
    -- end

    self.base_mat:setTex("inputTex1", self.input1)
    self.base_mat:setTex("inputTex2", self.input2)

    -- self.frame = self.frame + 1

    self:_UpdateBase(p)
    -- self:_UpdateBack(p)
    -- self:_UpdateFinal(p)
end

function SeekModeScript:_UpdateBase(_p)
    local p = _p
    local frame = self.attrs1:getCurrFrameIndex(p)
    
    local scale = nil
    if math.floor(frame) < 18 then
        self.base_mat:setFloat("changeTexFlag", 0)
        scale = self.attrs1:GetVal("ADBE_Scale_3_4", p)
        scale = Amaz.Vector2f(scale[1]*0.01, scale[2]*0.01)
    else
        self.base_mat:setFloat("changeTexFlag", 1)
        scale = self.attrs1:GetVal("ADBE_Scale_4_6", p)
        scale = Amaz.Vector2f(scale[1]*0.01, scale[2]*0.01)
    end
    -- Amaz.LOGI("lrc "..frame, tostring(scale))
    self.base_mat:setVec2("scale", scale)
    
    local white_alpha = self.attrs1:GetVal("ADBE_Opacity_0_0", p)
    white_alpha = white_alpha[1] * 0.01
    self.final_mat:setFloat("white_alpha", white_alpha)

    local pos = self.attrs1:GetVal("ADBE_Position_1_1", p)
    pos = Amaz.Vector2f(pos[1]/500-0.5, pos[2]/290-0.5)
    self.final_mat:setVec2("pos", pos)


    local u_Amount = self.attrs1:GetVal("ADBE_Radial_Blur_0001_2_3", p)
    u_Amount = u_Amount[1] * 0.5
    self.radial_blur_mat:setFloat("u_Amount", u_Amount)

    local intensity = self.attrs1:GetVal("ADBE_Optics_Compensation_0001_2_2", p)
    intensity = intensity[1] * 0.13
    Amaz.LOGI("lrc "..self.attrs1:getCurrFrameIndex(p), intensity)
    self.fov_mat:setFloat("intensity", intensity)
    self.fov_mat:setFloat("u_strength", 0.7)
    self.fov_mat:setFloat("u_fov", self.u_fov)

    local bulge_height = self.attrs1:GetVal("ADBE_Bulge_0004_4_5", p)
    bulge_height = bulge_height[1] * 0.25
    self.base_mat:setFloat("bulge_height", bulge_height)
    self.base_mat:setFloat("cone_radius", 0)
    self.base_mat:setVec2("bulge_center", Amaz.Vector2f(0., 0.))
    self.base_mat:setVec2("bulge_radius", Amaz.Vector2f(1.5, 1.5))

end



exports.SeekModeScript = SeekModeScript
return exports
