precision highp float;
varying highp vec2 uv0;
uniform sampler2D input1tex;
uniform sampler2D input2tex;
uniform float fade;

const vec3 grey_affector = vec3(0.299,0.578,0.114);

void main()
{
    vec2 uv1 = uv0;
    vec4 col1 = texture2D(input1tex, (uv1));
    vec4 col2 = texture2D(input2tex, (uv1));

    float g1 = dot(col1.rgb, grey_affector);

    vec4 res = mix(col2, col1, smoothstep(g1, min(g1+0.57, 1.), fade));
    gl_FragColor = res;
}