#pragma clang diagnostic ignored "-Wmissing-prototypes"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

// Implementation of the GLSL mod() function, which is slightly different than Metal fmod()
template<typename Tx, typename Ty>
inline Tx mod(Tx x, Ty y)
{
    return x - y * floor(x / y);
}

struct buffer_t
{
    float changeTexFlag;
    float2 scale;
    float4 u_ScreenParams;
    float bulge_height;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputTex1 [[texture(0)]], texture2d<float> inputTex2 [[texture(1)]], sampler inputTex1Smplr [[sampler(0)]], sampler inputTex2Smplr [[sampler(1)]])
{
    main0_out out = {};
    float4 _598;
    if (buffer.changeTexFlag < 0.5)
    {
        float2 _329 = (in.uv0 - float2(0.5)) / (buffer.scale * 0.89999997615814208984375);
        float _342 = buffer.u_ScreenParams.x / buffer.u_ScreenParams.y;
        float2 _569 = _329;
        _569.x = _329.x * _342;
        float2 _356 = float2x2(float2(1.0, 0.0), float2(-0.0, 1.0)) * _569;
        float2 _574 = _356;
        _574.x = _356.x / _342;
        _598 = inputTex1.sample(inputTex1Smplr, abs(mod(_574 + float2(-0.5), float2(2.0)) - float2(1.0)));
    }
    else
    {
        float2 _409 = in.uv0 - float2(0.5);
        float2 _513 = (_409 + ((_409 * (2.0 - length(_409))) * mix(0.0, -buffer.bulge_height, pow(smoothstep(0.999000012874603271484375, 1.00100004673004150390625, 1.0), 0.5)))) / (buffer.scale * 0.89999997615814208984375);
        float _526 = buffer.u_ScreenParams.x / buffer.u_ScreenParams.y;
        float2 _591 = _513;
        _591.x = _513.x * _526;
        float2 _540 = float2x2(float2(1.0, 0.0), float2(-0.0, 1.0)) * _591;
        float2 _596 = _540;
        _596.x = _540.x / _526;
        _598 = inputTex2.sample(inputTex2Smplr, abs(mod(_596 + float2(-0.5), float2(2.0)) - float2(1.0)));
    }
    out.gl_FragColor = _598;
    return out;
}

