precision highp float;

varying vec2 uv0;

uniform sampler2D inputTex1;
uniform sampler2D inputTex2;
uniform float changeTexFlag;

uniform vec2 scale;

uniform vec4 u_ScreenParams;

uniform float bulge_height;
uniform float cone_radius;

uniform vec2 bulge_radius;
uniform vec2 bulge_center;

vec2 Mirror(vec2 x) { return abs(mod(x-1., 2.)-1.); }

float cut(vec2 u) {return step(0., u.x)*step(u.x, 1.)*step(0., u.y)*step(u.y, 1.); }

void TRS(inout vec2 io_u, vec2 _t, float _r, vec2 _s, vec2 _screensize){
    io_u -= 0.5;
    io_u += vec2(-_t.x, _t.y);
    io_u /= _s;

    // rotate
    const float TRS_PI = 3.1415926;
    float r = -_r/180.*TRS_PI;
    float s = sin(r);
    float c = cos(r);

    io_u.x *= _screensize.x/_screensize.y;
    io_u = mat2(c, -s, s,  c) * io_u;
    io_u.x /= _screensize.x/_screensize.y;

    io_u += 0.5;
}

void BulgeEffect(inout vec2 io_uv, 
                vec2 _radius, vec2 _center, 
                float _height, float _taper_radius, 
                float _pinning, vec2 screensize){
    
    // get ellipse mask
    vec2 uv1 = io_uv;
    uv1 -= 0.5;
    uv1 += _center;
    uv1 *= 2.;
    uv1 *= 1./_radius;
    float d = length(uv1);
    d = 1.-d;
    d = clamp(0., 1., d);

    // bulge uv
    vec2 uv2 = io_uv;
    uv2 -= 0.5;

    float cone = clamp(0., 1., _taper_radius);
    d = smoothstep(pow(cone, 2.)-0.001, pow(cone, 0.5)+0.001, d) * d;

    float pinning_mask = 1.;
    if(_pinning > 0.5){
        vec2 pinning_space = vec2(0.01*screensize.x/screensize.y, 0.01);
        pinning_mask = min(pinning_mask, smoothstep(pinning_space.x, pinning_space.x*5., uv0.x));
        pinning_mask = min(pinning_mask, smoothstep(1.-pinning_space.x, 1.-pinning_space.x*5., uv0.x));
        pinning_mask = min(pinning_mask, smoothstep(pinning_space.y, pinning_space.y*5., uv0.y));
        pinning_mask = min(pinning_mask, smoothstep(1.-pinning_space.y, 1.-pinning_space.y*5., uv0.y));
    }

    io_uv = uv2;
    io_uv += uv2 * (2. - length(uv2))*mix(0., -_height, pow(pinning_mask*d, 0.5));
    io_uv += 0.5;
}

void main()
{

    vec2 uv1 = uv0;
    vec4 res = vec4(1);

    if(changeTexFlag<0.5){
        TRS(uv1, vec2(0), 0., scale*0.9, u_ScreenParams.xy);
        res = texture2D(inputTex1, Mirror(uv1));
    }else{
        BulgeEffect(uv1, bulge_radius, bulge_center, bulge_height, cone_radius, 0., u_ScreenParams.xy);


        TRS(uv1, vec2(0), 0., scale*0.9, u_ScreenParams.xy);
        res = texture2D(inputTex2, Mirror(uv1));
    }
    gl_FragColor = res;
}
