#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float4 u_ScreenParams;
    float2 inCornerPosition;
    float2 inFoldPosition;
    float foldRadius;
    float b_scale;
    float2 back_offset;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer)
{
    main0_out out = {};
    float2 _488 = (((in.uv0 - float2(0.5)) / float2(buffer.b_scale)) + buffer.back_offset) + float2(0.5);
    float _554 = buffer.u_ScreenParams.x / buffer.u_ScreenParams.y;
    float2 _557 = float2(1.0 / _554, 1.0);
    float2 _991 = _488;
    _991.x = _488.x * _554;
    float2 _575 = float2(buffer.inFoldPosition.x, buffer.u_ScreenParams.y - buffer.inFoldPosition.y);
    float2 _581 = (_575 * float2(_554, 1.0)) / buffer.u_ScreenParams.xy;
    float2 _587 = fast::normalize((_575 - buffer.inCornerPosition) + float2(0.001000000047497451305389404296875));
    float _594 = _587.x;
    float _601 = _594 + 9.9999997473787516355514526367188e-06;
    float2 _604 = _581 - ((_587 * fma(-_554, fast::max(sign(_594 - (-9.9999997473787516355514526367188e-06)), 0.0), _581.x)) / float2(_601));
    float _634 = dot(_604 - _991, _587) - (length(_581 - _604) + (fma(buffer.inCornerPosition.x / buffer.u_ScreenParams.x, _554, -(_554 * fast::max(sign(9.9999997473787516355514526367188e-06 - _594), 0.0))) / _601));
    float2 _639 = _991 + (_587 * _634);
    float4 _1049;
    if (_634 > buffer.foldRadius)
    {
        _1049 = float4(0.0);
    }
    else
    {
        float4 _1050;
        if (_634 > 9.9999997473787516355514526367188e-06)
        {
            float _651 = asin(_634 / buffer.foldRadius);
            float2 _658 = _639 - ((_587 * _651) * buffer.foldRadius);
            float2 _666 = _639 - ((_587 * (3.1415927410125732421875 - _651)) * buffer.foldRadius);
            float _668 = _666.x;
            bool _671 = _668 < (_554 + 9.9999997473787516355514526367188e-06);
            bool _677;
            if (_671)
            {
                _677 = _666.y < 1.000010013580322265625;
            }
            else
            {
                _677 = _671;
            }
            bool _683;
            if (_677)
            {
                _683 = _668 > 0.0;
            }
            else
            {
                _683 = _677;
            }
            bool _689;
            if (_683)
            {
                _689 = _666.y > 0.0;
            }
            else
            {
                _689 = _683;
            }
            float4 _1051;
            if (_689)
            {
                float2 _693 = _658 * _557;
                float _888 = _693.x;
                float _895 = _693.y;
                float4 _695 = float4(0.0, 0.0, 0.0, 1.0) * (((step(0.0, _888) * step(_888, 1.0)) * step(0.0, _895)) * step(_895, 1.0));
                float2 _698 = _666 * _557;
                float _905 = _698.x;
                float _912 = _698.y;
                float4 _700 = float4(0.0, 0.0, 0.0, 1.0) * (((step(0.0, _905) * step(_905, 1.0)) * step(0.0, _912)) * step(_912, 1.0));
                float _711 = _700.w;
                float4 _723 = float4(mix(_695.xyz, _700.xyz, float3(_711)), fast::max(_711, _695.w));
                float3 _732 = _723.xyz * pow((buffer.foldRadius - _634) / buffer.foldRadius, 0.20000000298023223876953125);
                float4 _1015 = _723;
                _1015.x = _732.x;
                float4 _1017 = _1015;
                _1017.y = _732.y;
                float4 _1019 = _1017;
                _1019.z = _732.z;
                _1051 = _1019;
            }
            else
            {
                float2 _742 = _658 * _557;
                float _922 = _742.x;
                float _929 = _742.y;
                float4 _744 = float4(0.0, 0.0, 0.0, 1.0) * (((step(0.0, _922) * step(_922, 1.0)) * step(0.0, _929)) * step(_929, 1.0));
                float3 _753 = _744.xyz * pow((buffer.foldRadius - _634) / buffer.foldRadius, 0.20000000298023223876953125);
                float4 _1025 = _744;
                _1025.x = _753.x;
                float4 _1027 = _1025;
                _1027.y = _753.y;
                float4 _1029 = _1027;
                _1029.z = _753.z;
                _1051 = _1029;
            }
            _1050 = _1051;
        }
        else
        {
            float2 _770 = _639 - (_587 * fma(3.1415927410125732421875, buffer.foldRadius, abs(_634)));
            float _772 = _770.x;
            bool _775 = _772 < (_554 + 9.9999997473787516355514526367188e-06);
            bool _781;
            if (_775)
            {
                _781 = _770.y < 1.000010013580322265625;
            }
            else
            {
                _781 = _775;
            }
            bool _787;
            if (_781)
            {
                _787 = _772 > 0.0;
            }
            else
            {
                _787 = _781;
            }
            bool _793;
            if (_787)
            {
                _793 = _770.y > 0.0;
            }
            else
            {
                _793 = _787;
            }
            float4 _1052;
            if (_793)
            {
                float2 _797 = _991 * _557;
                float _939 = _797.x;
                float _946 = _797.y;
                float4 _799 = float4(0.0, 0.0, 0.0, 1.0) * (((step(0.0, _939) * step(_939, 1.0)) * step(0.0, _946)) * step(_946, 1.0));
                float2 _802 = _770 * _557;
                float _956 = _802.x;
                float _963 = _802.y;
                float4 _804 = float4(0.0, 0.0, 0.0, 1.0) * (((step(0.0, _956) * step(_956, 1.0)) * step(0.0, _963)) * step(_963, 1.0));
                float _810 = _804.w;
                _1052 = float4(mix(_799.xyz, _804.xyz, float3(_810)), fast::max(_810, _799.w));
            }
            else
            {
                float2 _826 = _991 * _557;
                float _973 = _826.x;
                float _980 = _826.y;
                _1052 = float4(0.0, 0.0, 0.0, 1.0) * (((step(0.0, _973) * step(_973, 1.0)) * step(0.0, _980)) * step(_980, 1.0));
            }
            _1050 = _1052;
        }
        _1049 = _1050;
    }
    out.gl_FragColor = _1049;
    return out;
}

