precision highp float;

varying vec2 uv0;

uniform sampler2D inputTex;
uniform vec4 u_ScreenParams;
uniform vec2 inCornerPosition;
uniform vec2 inFoldPosition;
uniform vec2 back_offset;
uniform float iTime;
uniform float foldRadius;
uniform float b_scale;

vec2 Mirror(vec2 x) { return abs(mod(x-1., 2.)-1.); }
float cut(vec2 u) {return step(0., u.x)*step(u.x, 1.)*step(0., u.y)*step(u.y, 1.); }

uniform float u_Intensity;
uniform float u_Alpha;
uniform float u_Offset;
uniform float u_GrayscaleCorrect;
void ExposureLighten(vec4 i_col, float _alpha, out vec4 o_col){

    o_col = pow(i_col, 1./vec4(2.2)) * pow(0.75, -u_Intensity);
    o_col += u_Offset;
    o_col = pow(o_col, vec4(1.0 / u_GrayscaleCorrect));
    o_col = mix(i_col, o_col, _alpha);
    o_col = pow(o_col, vec4(2.2));
}

#define PI 3.14159265359
// #define foldRadius 0.2
#define opacity 1.0
#define EPSILON 1e-5

float ifLessThan(float val, float compareVal) {
    return max(sign(compareVal - val), 0.0);
}

float ifGreaterThan(float val, float compareVal) {
    return max(sign(val - compareVal), 0.0);
}

float mirrored_repeat(float x) {
    x = mod(x, 2.0);
    x += (2.0 - 2.0 * x) * ifGreaterThan(x, 1.0);
    return x;
}

vec2 getFoldPosition() {
    // starts from bottom right and folds to top left
    return vec2(u_ScreenParams.x, 0.0) - vec2(u_ScreenParams.x, -u_ScreenParams.y) * mirrored_repeat(iTime);
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 textureSize = u_ScreenParams.xy;
    float aspectRatio = textureSize.x / textureSize.y;
    vec2 invAspect = vec2(1.0 / aspectRatio, 1.0);
    vec2 uv = fragCoord / textureSize;
    uv.x *= aspectRatio;
    
    // vec2 cornerPosition = iMouse.z > 0.0 ? abs(iMouse.zw) : vec2(iResolution.x, 0.0);
    // vec2 foldPosition = iMouse.z > 0.0 ? iMouse.xy : getFoldPosition();
    vec2 cornerPosition = inCornerPosition;
    vec2 foldPosition = getFoldPosition();
    foldPosition = vec2(inFoldPosition.x, (u_ScreenParams.y-inFoldPosition.y));
    
    vec2 normalizedFoldPosition = foldPosition * vec2(aspectRatio, 1.0) / textureSize;
    vec2 dir = normalize(foldPosition - cornerPosition + 0.001);
    vec2 origin = normalizedFoldPosition - dir * (normalizedFoldPosition.x - aspectRatio * ifGreaterThan(dir.x, -EPSILON)) / (dir.x + EPSILON);
    float curlDist = length(normalizedFoldPosition - origin) + (cornerPosition.x / textureSize.x * aspectRatio - aspectRatio * ifLessThan(dir.x, EPSILON)) / (dir.x + EPSILON);

    float proj = dot(origin - uv, dir);
    float dist = proj - curlDist;
    vec2 linePoint = uv + dist * dir;

    vec4 outColor = vec4(0);
    if (dist > foldRadius)
    {
        outColor = vec4(0);
    }
    else if (dist > EPSILON)
    {
        float theta = asin(dist / foldRadius);
        vec2 p1 = linePoint - dir * theta * foldRadius;
        vec2 p2 = linePoint - dir * (PI - theta) * foldRadius;

        // outside curl
        if (p2.x < (aspectRatio + EPSILON) && p2.y < (1.0 + EPSILON) && p2.x > 0.0 && p2.y > 0.0)
        {
            // vec4 frontPage = texture2D(inputTex, p1 * invAspect) * cut(p1 * invAspect);
            // vec4 backPage = texture2D(inputTex, p2 * invAspect) * cut(p2 * invAspect);
            vec4 frontPage = vec4(0,0,0,1) * cut(p1 * invAspect);
            vec4 backPage = vec4(0,0,0,1) * cut(p2 * invAspect);
            float alpha = backPage.a * frontPage.a;
            outColor = vec4(mix(frontPage.rgb, backPage.rgb, backPage.a * opacity), max(backPage.a, frontPage.a));
            outColor.rgb *= pow((foldRadius - dist) / foldRadius, 0.2);
        }
        // inside curl
        else
        {
            // outColor = texture2D(inputTex, p1 * invAspect) * cut(p1 * invAspect);
            outColor = vec4(0,0,0,1) * cut(p1 * invAspect);
            outColor.rgb *= pow((foldRadius - dist) / foldRadius, 0.2);
        }
        // outColor = vec4(0,1,0,1);
    }
    else
    {
        vec2 p = linePoint - dir * (abs(dist) + PI * foldRadius);

        // outside curl
        if (p.x < (aspectRatio + EPSILON) && p.y < (1.0 + EPSILON) && p.x > 0.0 && p.y > 0.0)
        {
            // vec4 frontPage = texture2D(inputTex, uv*invAspect) * cut(uv*invAspect);
            // vec4 backPage = texture2D(inputTex, p*invAspect) * cut(p * invAspect);
            vec4 frontPage = vec4(0,0,0,1) * cut(uv*invAspect);
            vec4 backPage = vec4(0,0,0,1) * cut(p * invAspect);
            outColor = vec4(mix(frontPage.rgb, backPage.rgb, backPage.a * opacity), max(backPage.a, frontPage.a));
        }
        // flat surface
        else
        {
            // outColor = texture2D(inputTex, p*invAspect) * cut(uv*invAspect);
            outColor = vec4(0,0,0,1) * cut(uv*invAspect);
        }

    }
    fragColor = outColor;
}

void main()
{
    vec2 uv1 = uv0;
    vec4 res = texture2D(inputTex, Mirror(uv1));
    // res = vec4(1,0,0,1);
    // ExposureLighten(res, u_Alpha, res);


    vec2 uv2 = uv1;
    uv2 -= 0.5;
    uv2 /= b_scale;
    uv2 += back_offset;
    uv2 += 0.5;
    mainImage(res, uv2*u_ScreenParams.xy);

    gl_FragColor = res;
}
