#pragma clang diagnostic ignored "-Wmissing-prototypes"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

// Implementation of the GLSL mod() function, which is slightly different than Metal fmod()
template<typename Tx, typename Ty>
inline Tx mod(Tx x, Ty y)
{
    return x - y * floor(x / y);
}

struct buffer_t
{
    float u_Cycle;
    float4 u_ScreenParams;
    float2 u_Offset;
    float u_Rotate;
    float2 u_Scale;
    float u_type;
    float u_Complexity;
    float u_Evolution;
    float u_SubImpact;
    float u_SubScale;
    float u_SubRotate;
    float2 u_SubOffset;
    float u_Brightness;
    float u_Contrast;
    float u_Range;
    float u_fov;
    float u_strength;
    float intensity;
    float u_Intensity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputTex [[texture(0)]], sampler inputTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _931 = in.uv0 - buffer.u_Offset;
    float _934 = buffer.u_Rotate * 0.01745329238474369049072265625;
    float _1079 = buffer.u_ScreenParams.y / buffer.u_ScreenParams.x;
    float2 _9959 = _931;
    _9959.y = _931.y * _1079;
    float _1085 = sin(_934);
    float _1087 = cos(_934);
    float2 _1104 = (float2x2(float2(_1087, _1085), float2(-_1085, _1087)) * (_9959 - float2(0.5))) + float2(0.5);
    float _1109 = buffer.u_ScreenParams.x / buffer.u_ScreenParams.y;
    float2 _9962 = _1104;
    _9962.y = _1104.y * _1109;
    float2 _941 = _9962 * (float2(1.0) / buffer.u_Scale);
    bool _943 = buffer.u_type < 0.0500000007450580596923828125;
    float _10603;
    float _10634;
    if (_943)
    {
        float _946 = fast::clamp(buffer.u_Complexity, 1.0, 10.0);
        float _948 = 100.0 / buffer.u_SubScale;
        float2 _1146 = (float2(720.0) * buffer.u_ScreenParams.xy) / float2(fast::min(buffer.u_ScreenParams.x, buffer.u_ScreenParams.y));
        float _1148 = floor(_946);
        float _1150 = fract(_946);
        float2 _1277 = (_941 * _1146) * float2(0.00999999977648258209228515625);
        float2 _1278 = floor(_1277);
        float2 _1284 = fract(_1277);
        float2 _1475 = fract(_1278 * 1324.5179443359375);
        float2 _1484 = _1475 + float2(dot(_1475, _1475.yx + float2(22.5410003662109375)));
        float _1488 = _1484.y;
        float _1493 = fract((_1484.x + _1488) * _1488);
        float _1377 = buffer.u_Evolution + _1493;
        float _1379 = floor(_1377);
        float _1381 = _1379 + 1.0;
        bool _1383 = buffer.u_Cycle >= 2.0;
        float _10473;
        float _10474;
        if (_1383)
        {
            _10474 = floor(mod(_1377 + 1.0, buffer.u_Cycle));
            _10473 = floor(mod(_1377, buffer.u_Cycle));
        }
        else
        {
            _10474 = _1381;
            _10473 = _1379;
        }
        float2 _1405 = fract(_1278 * (fma(_10473, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _1414 = _1405 + float2(dot(_1405, _1405.yx + float2(15.4340000152587890625)));
        float2 _1417 = _1414.yx;
        float2 _1425 = float2(_1493);
        float2 _1438 = fract(_1278 * (fma(_10474, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _1447 = _1438 + float2(dot(_1438, _1438.yx + float2(15.4340000152587890625)));
        float2 _1450 = _1447.yx;
        float2 _1465 = float2(fract(_1377));
        float2 _1294 = _1278 + float2(1.0, 0.0);
        float2 _1609 = fract(_1294 * 1324.5179443359375);
        float2 _1618 = _1609 + float2(dot(_1609, _1609.yx + float2(22.5410003662109375)));
        float _1622 = _1618.y;
        float _1627 = fract((_1618.x + _1622) * _1622);
        float _1511 = buffer.u_Evolution + _1627;
        float _1513 = floor(_1511);
        float _1515 = _1513 + 1.0;
        float _10475;
        float _10476;
        if (_1383)
        {
            _10476 = floor(mod(_1511 + 1.0, buffer.u_Cycle));
            _10475 = floor(mod(_1511, buffer.u_Cycle));
        }
        else
        {
            _10476 = _1515;
            _10475 = _1513;
        }
        float2 _1539 = fract(_1294 * (fma(_10475, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _1548 = _1539 + float2(dot(_1539, _1539.yx + float2(15.4340000152587890625)));
        float2 _1551 = _1548.yx;
        float2 _1559 = float2(_1627);
        float2 _1572 = fract(_1294 * (fma(_10476, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _1581 = _1572 + float2(dot(_1572, _1572.yx + float2(15.4340000152587890625)));
        float2 _1584 = _1581.yx;
        float2 _1599 = float2(fract(_1511));
        float2 _1300 = _1278 + float2(0.0, 1.0);
        float2 _1743 = fract(_1300 * 1324.5179443359375);
        float2 _1752 = _1743 + float2(dot(_1743, _1743.yx + float2(22.5410003662109375)));
        float _1756 = _1752.y;
        float _1761 = fract((_1752.x + _1756) * _1756);
        float _1645 = buffer.u_Evolution + _1761;
        float _1647 = floor(_1645);
        float _1649 = _1647 + 1.0;
        float _10477;
        float _10478;
        if (_1383)
        {
            _10478 = floor(mod(_1645 + 1.0, buffer.u_Cycle));
            _10477 = floor(mod(_1645, buffer.u_Cycle));
        }
        else
        {
            _10478 = _1649;
            _10477 = _1647;
        }
        float2 _1673 = fract(_1300 * (fma(_10477, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _1682 = _1673 + float2(dot(_1673, _1673.yx + float2(15.4340000152587890625)));
        float2 _1685 = _1682.yx;
        float2 _1693 = float2(_1761);
        float2 _1706 = fract(_1300 * (fma(_10478, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _1715 = _1706 + float2(dot(_1706, _1706.yx + float2(15.4340000152587890625)));
        float2 _1718 = _1715.yx;
        float2 _1733 = float2(fract(_1645));
        float2 _1306 = _1278 + float2(1.0);
        float2 _1877 = fract(_1306 * 1324.5179443359375);
        float2 _1886 = _1877 + float2(dot(_1877, _1877.yx + float2(22.5410003662109375)));
        float _1890 = _1886.y;
        float _1895 = fract((_1886.x + _1890) * _1890);
        float _1779 = buffer.u_Evolution + _1895;
        float _1781 = floor(_1779);
        float _1783 = _1781 + 1.0;
        float _10479;
        float _10480;
        if (_1383)
        {
            _10480 = floor(mod(_1779 + 1.0, buffer.u_Cycle));
            _10479 = floor(mod(_1779, buffer.u_Cycle));
        }
        else
        {
            _10480 = _1783;
            _10479 = _1781;
        }
        float2 _1807 = fract(_1306 * (fma(_10479, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _1816 = _1807 + float2(dot(_1807, _1807.yx + float2(15.4340000152587890625)));
        float2 _1819 = _1816.yx;
        float2 _1827 = float2(_1895);
        float2 _1840 = fract(_1306 * (fma(_10480, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _1849 = _1840 + float2(dot(_1840, _1840.yx + float2(15.4340000152587890625)));
        float2 _1852 = _1849.yx;
        float2 _1867 = float2(fract(_1779));
        float2 _1323 = ((_1284 * _1284) * _1284) * fma(_1284, (_1284 * 6.0) - float2(15.0), float2(10.0));
        float2 _1334 = _1284 - float2(1.0, 0.0);
        float _1337 = _1323.x;
        float2 _1343 = _1284 - float2(0.0, 1.0);
        float2 _1349 = _1284 - float2(1.0);
        float _1355 = _1323.y;
        float _1359 = fma(mix(mix(dot((mix(fract(fma((_1414 + _1417) + float2(0.5230000019073486328125), _1417, _1425)), fract(fma((_1447 + _1450) + float2(0.5230000019073486328125), _1450, _1425)), _1465) * 2.0) - float2(1.0), _1284), dot((mix(fract(fma((_1548 + _1551) + float2(0.5230000019073486328125), _1551, _1559)), fract(fma((_1581 + _1584) + float2(0.5230000019073486328125), _1584, _1559)), _1599) * 2.0) - float2(1.0), _1334), _1337), mix(dot((mix(fract(fma((_1682 + _1685) + float2(0.5230000019073486328125), _1685, _1693)), fract(fma((_1715 + _1718) + float2(0.5230000019073486328125), _1718, _1693)), _1733) * 2.0) - float2(1.0), _1343), dot((mix(fract(fma((_1816 + _1819) + float2(0.5230000019073486328125), _1819, _1827)), fract(fma((_1849 + _1852) + float2(0.5230000019073486328125), _1852, _1827)), _1867) * 2.0) - float2(1.0), _1349), _1337), _1355), 0.5, 0.5);
        float2 _10482;
        float _10499;
        float _10504;
        float _10509;
        _10509 = _1359;
        _10504 = 1.0;
        _10499 = buffer.u_SubImpact;
        _10482 = _941;
        float2 _1185;
        float _1196;
        float _1199;
        float _1202;
        for (float _10481 = 2.0; _10481 <= 10.0; _10509 = _1202, _10504 = _1196, _10499 = _1199, _10482 = _1185, _10481 += 1.0)
        {
            if (_10481 > _1148)
            {
                break;
            }
            float2 _1177 = _10482 - (buffer.u_SubOffset / _1146);
            float _1180 = buffer.u_SubRotate * 0.01745329238474369049072265625;
            float2 _9992 = _1177;
            _9992.y = _1177.y * _1079;
            float _1911 = sin(_1180);
            float _1913 = cos(_1180);
            float2 _1930 = (float2x2(float2(_1913, _1911), float2(-_1911, _1913)) * (_9992 - float2(0.5))) + float2(0.5);
            float2 _9995 = _1930;
            _9995.y = _1930.y * _1109;
            _1185 = _9995 * _948;
            float2 _1975 = (_1185 * _1146) * float2(0.00999999977648258209228515625);
            float2 _1976 = floor(_1975);
            float2 _1982 = fract(_1975);
            float2 _2173 = fract(_1976 * 1324.5179443359375);
            float2 _2182 = _2173 + float2(dot(_2173, _2173.yx + float2(22.5410003662109375)));
            float _2186 = _2182.y;
            float _2191 = fract((_2182.x + _2186) * _2186);
            float _2075 = buffer.u_Evolution + _2191;
            float _2077 = floor(_2075);
            float _10487;
            float _10488;
            if (_1383)
            {
                _10488 = floor(mod(_2075 + 1.0, buffer.u_Cycle));
                _10487 = floor(mod(_2075, buffer.u_Cycle));
            }
            else
            {
                _10488 = _2077 + 1.0;
                _10487 = _2077;
            }
            float2 _2103 = fract(_1976 * (fma(_10487, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _2112 = _2103 + float2(dot(_2103, _2103.yx + float2(15.4340000152587890625)));
            float2 _2115 = _2112.yx;
            float2 _2123 = float2(_2191);
            float2 _2136 = fract(_1976 * (fma(_10488, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _2145 = _2136 + float2(dot(_2136, _2136.yx + float2(15.4340000152587890625)));
            float2 _2148 = _2145.yx;
            float2 _1992 = _1976 + float2(1.0, 0.0);
            float2 _2307 = fract(_1992 * 1324.5179443359375);
            float2 _2316 = _2307 + float2(dot(_2307, _2307.yx + float2(22.5410003662109375)));
            float _2320 = _2316.y;
            float _2325 = fract((_2316.x + _2320) * _2320);
            float _2209 = buffer.u_Evolution + _2325;
            float _2211 = floor(_2209);
            float _10489;
            float _10490;
            if (_1383)
            {
                _10490 = floor(mod(_2209 + 1.0, buffer.u_Cycle));
                _10489 = floor(mod(_2209, buffer.u_Cycle));
            }
            else
            {
                _10490 = _2211 + 1.0;
                _10489 = _2211;
            }
            float2 _2237 = fract(_1992 * (fma(_10489, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _2246 = _2237 + float2(dot(_2237, _2237.yx + float2(15.4340000152587890625)));
            float2 _2249 = _2246.yx;
            float2 _2257 = float2(_2325);
            float2 _2270 = fract(_1992 * (fma(_10490, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _2279 = _2270 + float2(dot(_2270, _2270.yx + float2(15.4340000152587890625)));
            float2 _2282 = _2279.yx;
            float2 _1998 = _1976 + float2(0.0, 1.0);
            float2 _2441 = fract(_1998 * 1324.5179443359375);
            float2 _2450 = _2441 + float2(dot(_2441, _2441.yx + float2(22.5410003662109375)));
            float _2454 = _2450.y;
            float _2459 = fract((_2450.x + _2454) * _2454);
            float _2343 = buffer.u_Evolution + _2459;
            float _2345 = floor(_2343);
            float _10491;
            float _10492;
            if (_1383)
            {
                _10492 = floor(mod(_2343 + 1.0, buffer.u_Cycle));
                _10491 = floor(mod(_2343, buffer.u_Cycle));
            }
            else
            {
                _10492 = _2345 + 1.0;
                _10491 = _2345;
            }
            float2 _2371 = fract(_1998 * (fma(_10491, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _2380 = _2371 + float2(dot(_2371, _2371.yx + float2(15.4340000152587890625)));
            float2 _2383 = _2380.yx;
            float2 _2391 = float2(_2459);
            float2 _2404 = fract(_1998 * (fma(_10492, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _2413 = _2404 + float2(dot(_2404, _2404.yx + float2(15.4340000152587890625)));
            float2 _2416 = _2413.yx;
            float2 _2004 = _1976 + float2(1.0);
            float2 _2575 = fract(_2004 * 1324.5179443359375);
            float2 _2584 = _2575 + float2(dot(_2575, _2575.yx + float2(22.5410003662109375)));
            float _2588 = _2584.y;
            float _2593 = fract((_2584.x + _2588) * _2588);
            float _2477 = buffer.u_Evolution + _2593;
            float _2479 = floor(_2477);
            float _10493;
            float _10494;
            if (_1383)
            {
                _10494 = floor(mod(_2477 + 1.0, buffer.u_Cycle));
                _10493 = floor(mod(_2477, buffer.u_Cycle));
            }
            else
            {
                _10494 = _2479 + 1.0;
                _10493 = _2479;
            }
            float2 _2505 = fract(_2004 * (fma(_10493, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _2514 = _2505 + float2(dot(_2505, _2505.yx + float2(15.4340000152587890625)));
            float2 _2517 = _2514.yx;
            float2 _2525 = float2(_2593);
            float2 _2538 = fract(_2004 * (fma(_10494, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _2547 = _2538 + float2(dot(_2538, _2538.yx + float2(15.4340000152587890625)));
            float2 _2550 = _2547.yx;
            float2 _2021 = ((_1982 * _1982) * _1982) * fma(_1982, (_1982 * 6.0) - float2(15.0), float2(10.0));
            float _2035 = _2021.x;
            float _2057 = fma(mix(mix(dot((mix(fract(fma((_2112 + _2115) + float2(0.5230000019073486328125), _2115, _2123)), fract(fma((_2145 + _2148) + float2(0.5230000019073486328125), _2148, _2123)), float2(fract(_2075))) * 2.0) - float2(1.0), _1982), dot((mix(fract(fma((_2246 + _2249) + float2(0.5230000019073486328125), _2249, _2257)), fract(fma((_2279 + _2282) + float2(0.5230000019073486328125), _2282, _2257)), float2(fract(_2209))) * 2.0) - float2(1.0), _1982 - float2(1.0, 0.0)), _2035), mix(dot((mix(fract(fma((_2380 + _2383) + float2(0.5230000019073486328125), _2383, _2391)), fract(fma((_2413 + _2416) + float2(0.5230000019073486328125), _2416, _2391)), float2(fract(_2343))) * 2.0) - float2(1.0), _1982 - float2(0.0, 1.0)), dot((mix(fract(fma((_2514 + _2517) + float2(0.5230000019073486328125), _2517, _2525)), fract(fma((_2547 + _2550) + float2(0.5230000019073486328125), _2550, _2525)), float2(fract(_2477))) * 2.0) - float2(1.0), _1982 - float2(1.0)), _2035), _2021.y), 0.5, 0.5);
            _1196 = _10504 + _10499;
            _1199 = _10499 * buffer.u_SubImpact;
            _1202 = fma(_2057, _10499, _10509);
        }
        float2 _1209 = buffer.u_SubOffset / _1146;
        float2 _1211 = _10482 - _1209;
        float _1214 = buffer.u_SubRotate * 0.01745329238474369049072265625;
        float2 _10025 = _1211;
        _10025.y = _1211.y * _1079;
        float _2609 = sin(_1214);
        float _2611 = cos(_1214);
        float2x2 _2619 = float2x2(float2(_2611, _2609), float2(-_2609, _2611));
        float2 _2628 = (_2619 * (_10025 - float2(0.5))) + float2(0.5);
        float2 _10028 = _2628;
        _10028.y = _2628.y * _1109;
        float2 _2673 = ((_10028 * _948) * _1146) * float2(0.00999999977648258209228515625);
        float2 _2674 = floor(_2673);
        float2 _2680 = fract(_2673);
        float2 _2871 = fract(_2674 * 1324.5179443359375);
        float2 _2880 = _2871 + float2(dot(_2871, _2871.yx + float2(22.5410003662109375)));
        float _2884 = _2880.y;
        float _2889 = fract((_2880.x + _2884) * _2884);
        float _2773 = buffer.u_Evolution + _2889;
        float _2775 = floor(_2773);
        float _10515;
        float _10516;
        if (_1383)
        {
            _10516 = floor(mod(_2773 + 1.0, buffer.u_Cycle));
            _10515 = floor(mod(_2773, buffer.u_Cycle));
        }
        else
        {
            _10516 = _2775 + 1.0;
            _10515 = _2775;
        }
        float2 _2801 = fract(_2674 * (fma(_10515, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _2810 = _2801 + float2(dot(_2801, _2801.yx + float2(15.4340000152587890625)));
        float2 _2813 = _2810.yx;
        float2 _2821 = float2(_2889);
        float2 _2834 = fract(_2674 * (fma(_10516, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _2843 = _2834 + float2(dot(_2834, _2834.yx + float2(15.4340000152587890625)));
        float2 _2846 = _2843.yx;
        float2 _2690 = _2674 + float2(1.0, 0.0);
        float2 _3005 = fract(_2690 * 1324.5179443359375);
        float2 _3014 = _3005 + float2(dot(_3005, _3005.yx + float2(22.5410003662109375)));
        float _3018 = _3014.y;
        float _3023 = fract((_3014.x + _3018) * _3018);
        float _2907 = buffer.u_Evolution + _3023;
        float _2909 = floor(_2907);
        float _10517;
        float _10518;
        if (_1383)
        {
            _10518 = floor(mod(_2907 + 1.0, buffer.u_Cycle));
            _10517 = floor(mod(_2907, buffer.u_Cycle));
        }
        else
        {
            _10518 = _2909 + 1.0;
            _10517 = _2909;
        }
        float2 _2935 = fract(_2690 * (fma(_10517, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _2944 = _2935 + float2(dot(_2935, _2935.yx + float2(15.4340000152587890625)));
        float2 _2947 = _2944.yx;
        float2 _2955 = float2(_3023);
        float2 _2968 = fract(_2690 * (fma(_10518, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _2977 = _2968 + float2(dot(_2968, _2968.yx + float2(15.4340000152587890625)));
        float2 _2980 = _2977.yx;
        float2 _2696 = _2674 + float2(0.0, 1.0);
        float2 _3139 = fract(_2696 * 1324.5179443359375);
        float2 _3148 = _3139 + float2(dot(_3139, _3139.yx + float2(22.5410003662109375)));
        float _3152 = _3148.y;
        float _3157 = fract((_3148.x + _3152) * _3152);
        float _3041 = buffer.u_Evolution + _3157;
        float _3043 = floor(_3041);
        float _10519;
        float _10520;
        if (_1383)
        {
            _10520 = floor(mod(_3041 + 1.0, buffer.u_Cycle));
            _10519 = floor(mod(_3041, buffer.u_Cycle));
        }
        else
        {
            _10520 = _3043 + 1.0;
            _10519 = _3043;
        }
        float2 _3069 = fract(_2696 * (fma(_10519, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _3078 = _3069 + float2(dot(_3069, _3069.yx + float2(15.4340000152587890625)));
        float2 _3081 = _3078.yx;
        float2 _3089 = float2(_3157);
        float2 _3102 = fract(_2696 * (fma(_10520, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _3111 = _3102 + float2(dot(_3102, _3102.yx + float2(15.4340000152587890625)));
        float2 _3114 = _3111.yx;
        float2 _2702 = _2674 + float2(1.0);
        float2 _3273 = fract(_2702 * 1324.5179443359375);
        float2 _3282 = _3273 + float2(dot(_3273, _3273.yx + float2(22.5410003662109375)));
        float _3286 = _3282.y;
        float _3291 = fract((_3282.x + _3286) * _3286);
        float _3175 = buffer.u_Evolution + _3291;
        float _3177 = floor(_3175);
        float _10521;
        float _10522;
        if (_1383)
        {
            _10522 = floor(mod(_3175 + 1.0, buffer.u_Cycle));
            _10521 = floor(mod(_3175, buffer.u_Cycle));
        }
        else
        {
            _10522 = _3177 + 1.0;
            _10521 = _3177;
        }
        float2 _3203 = fract(_2702 * (fma(_10521, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _3212 = _3203 + float2(dot(_3203, _3203.yx + float2(15.4340000152587890625)));
        float2 _3215 = _3212.yx;
        float2 _3223 = float2(_3291);
        float2 _3236 = fract(_2702 * (fma(_10522, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _3245 = _3236 + float2(dot(_3236, _3236.yx + float2(15.4340000152587890625)));
        float2 _3248 = _3245.yx;
        float2 _2719 = ((_2680 * _2680) * _2680) * fma(_2680, (_2680 * 6.0) - float2(15.0), float2(10.0));
        float _2733 = _2719.x;
        float _2755 = fma(mix(mix(dot((mix(fract(fma((_2810 + _2813) + float2(0.5230000019073486328125), _2813, _2821)), fract(fma((_2843 + _2846) + float2(0.5230000019073486328125), _2846, _2821)), float2(fract(_2773))) * 2.0) - float2(1.0), _2680), dot((mix(fract(fma((_2944 + _2947) + float2(0.5230000019073486328125), _2947, _2955)), fract(fma((_2977 + _2980) + float2(0.5230000019073486328125), _2980, _2955)), float2(fract(_2907))) * 2.0) - float2(1.0), _2680 - float2(1.0, 0.0)), _2733), mix(dot((mix(fract(fma((_3078 + _3081) + float2(0.5230000019073486328125), _3081, _3089)), fract(fma((_3111 + _3114) + float2(0.5230000019073486328125), _3114, _3089)), float2(fract(_3041))) * 2.0) - float2(1.0), _2680 - float2(0.0, 1.0)), dot((mix(fract(fma((_3212 + _3215) + float2(0.5230000019073486328125), _3215, _3223)), fract(fma((_3245 + _3248) + float2(0.5230000019073486328125), _3248, _3223)), float2(fract(_3175))) * 2.0) - float2(1.0), _2680 - float2(1.0)), _2733), _2719.y), 0.5, 0.5);
        float _10538;
        float _10539;
        if (_1383)
        {
            _10539 = floor(mod(_1377 + 1.0, buffer.u_Cycle));
            _10538 = floor(mod(_1377, buffer.u_Cycle));
        }
        else
        {
            _10539 = _1381;
            _10538 = _1379;
        }
        float2 _3582 = fract(_1278 * (fma(_10538, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _3591 = _3582 + float2(dot(_3582, _3582.yx + float2(15.4340000152587890625)));
        float2 _3594 = _3591.yx;
        float2 _3615 = fract(_1278 * (fma(_10539, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _3624 = _3615 + float2(dot(_3615, _3615.yx + float2(15.4340000152587890625)));
        float2 _3627 = _3624.yx;
        float _10540;
        float _10541;
        if (_1383)
        {
            _10541 = floor(mod(_1511 + 1.0, buffer.u_Cycle));
            _10540 = floor(mod(_1511, buffer.u_Cycle));
        }
        else
        {
            _10541 = _1515;
            _10540 = _1513;
        }
        float2 _3716 = fract(_1294 * (fma(_10540, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _3725 = _3716 + float2(dot(_3716, _3716.yx + float2(15.4340000152587890625)));
        float2 _3728 = _3725.yx;
        float2 _3749 = fract(_1294 * (fma(_10541, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _3758 = _3749 + float2(dot(_3749, _3749.yx + float2(15.4340000152587890625)));
        float2 _3761 = _3758.yx;
        float _10542;
        float _10543;
        if (_1383)
        {
            _10543 = floor(mod(_1645 + 1.0, buffer.u_Cycle));
            _10542 = floor(mod(_1645, buffer.u_Cycle));
        }
        else
        {
            _10543 = _1649;
            _10542 = _1647;
        }
        float2 _3850 = fract(_1300 * (fma(_10542, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _3859 = _3850 + float2(dot(_3850, _3850.yx + float2(15.4340000152587890625)));
        float2 _3862 = _3859.yx;
        float2 _3883 = fract(_1300 * (fma(_10543, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _3892 = _3883 + float2(dot(_3883, _3883.yx + float2(15.4340000152587890625)));
        float2 _3895 = _3892.yx;
        float _10544;
        float _10545;
        if (_1383)
        {
            _10545 = floor(mod(_1779 + 1.0, buffer.u_Cycle));
            _10544 = floor(mod(_1779, buffer.u_Cycle));
        }
        else
        {
            _10545 = _1783;
            _10544 = _1781;
        }
        float2 _3984 = fract(_1306 * (fma(_10544, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _3993 = _3984 + float2(dot(_3984, _3984.yx + float2(15.4340000152587890625)));
        float2 _3996 = _3993.yx;
        float2 _4017 = fract(_1306 * (fma(_10545, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _4026 = _4017 + float2(dot(_4017, _4017.yx + float2(15.4340000152587890625)));
        float2 _4029 = _4026.yx;
        float _3536 = fma(mix(mix(dot((mix(fract(fma((_3591 + _3594) + float2(0.5230000019073486328125), _3594, _1425)), fract(fma((_3624 + _3627) + float2(0.5230000019073486328125), _3627, _1425)), _1465) * 2.0) - float2(1.0), _1284), dot((mix(fract(fma((_3725 + _3728) + float2(0.5230000019073486328125), _3728, _1559)), fract(fma((_3758 + _3761) + float2(0.5230000019073486328125), _3761, _1559)), _1599) * 2.0) - float2(1.0), _1334), _1337), mix(dot((mix(fract(fma((_3859 + _3862) + float2(0.5230000019073486328125), _3862, _1693)), fract(fma((_3892 + _3895) + float2(0.5230000019073486328125), _3895, _1693)), _1733) * 2.0) - float2(1.0), _1343), dot((mix(fract(fma((_3993 + _3996) + float2(0.5230000019073486328125), _3996, _1827)), fract(fma((_4026 + _4029) + float2(0.5230000019073486328125), _4029, _1827)), _1867) * 2.0) - float2(1.0), _1349), _1337), _1355), 0.5, 0.5);
        float2 _10547;
        float _10564;
        float _10569;
        float _10574;
        _10574 = _3536;
        _10569 = 1.0;
        _10564 = buffer.u_SubImpact;
        _10547 = _941;
        float2 _3362;
        float _3373;
        float _3376;
        float _3379;
        for (float _10546 = 2.0; _10546 <= 10.0; _10574 = _3379, _10569 = _3373, _10564 = _3376, _10547 = _3362, _10546 += 1.0)
        {
            if (_10546 > _1148)
            {
                break;
            }
            float2 _3354 = _10547 - _1209;
            float2 _10085 = _3354;
            _10085.y = _3354.y * _1079;
            float2 _4107 = (_2619 * (_10085 - float2(0.5))) + float2(0.5);
            float2 _10088 = _4107;
            _10088.y = _4107.y * _1109;
            _3362 = _10088 * _948;
            float2 _4152 = (_3362 * _1146) * float2(0.00999999977648258209228515625);
            float2 _4153 = floor(_4152);
            float2 _4159 = fract(_4152);
            float2 _4350 = fract(_4153 * 1324.5179443359375);
            float2 _4359 = _4350 + float2(dot(_4350, _4350.yx + float2(22.5410003662109375)));
            float _4363 = _4359.y;
            float _4368 = fract((_4359.x + _4363) * _4363);
            float _4252 = buffer.u_Evolution + _4368;
            float _4254 = floor(_4252);
            float _10552;
            float _10553;
            if (_1383)
            {
                _10553 = floor(mod(_4252 + 1.0, buffer.u_Cycle));
                _10552 = floor(mod(_4252, buffer.u_Cycle));
            }
            else
            {
                _10553 = _4254 + 1.0;
                _10552 = _4254;
            }
            float2 _4280 = fract(_4153 * (fma(_10552, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _4289 = _4280 + float2(dot(_4280, _4280.yx + float2(15.4340000152587890625)));
            float2 _4292 = _4289.yx;
            float2 _4300 = float2(_4368);
            float2 _4313 = fract(_4153 * (fma(_10553, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _4322 = _4313 + float2(dot(_4313, _4313.yx + float2(15.4340000152587890625)));
            float2 _4325 = _4322.yx;
            float2 _4169 = _4153 + float2(1.0, 0.0);
            float2 _4484 = fract(_4169 * 1324.5179443359375);
            float2 _4493 = _4484 + float2(dot(_4484, _4484.yx + float2(22.5410003662109375)));
            float _4497 = _4493.y;
            float _4502 = fract((_4493.x + _4497) * _4497);
            float _4386 = buffer.u_Evolution + _4502;
            float _4388 = floor(_4386);
            float _10554;
            float _10555;
            if (_1383)
            {
                _10555 = floor(mod(_4386 + 1.0, buffer.u_Cycle));
                _10554 = floor(mod(_4386, buffer.u_Cycle));
            }
            else
            {
                _10555 = _4388 + 1.0;
                _10554 = _4388;
            }
            float2 _4414 = fract(_4169 * (fma(_10554, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _4423 = _4414 + float2(dot(_4414, _4414.yx + float2(15.4340000152587890625)));
            float2 _4426 = _4423.yx;
            float2 _4434 = float2(_4502);
            float2 _4447 = fract(_4169 * (fma(_10555, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _4456 = _4447 + float2(dot(_4447, _4447.yx + float2(15.4340000152587890625)));
            float2 _4459 = _4456.yx;
            float2 _4175 = _4153 + float2(0.0, 1.0);
            float2 _4618 = fract(_4175 * 1324.5179443359375);
            float2 _4627 = _4618 + float2(dot(_4618, _4618.yx + float2(22.5410003662109375)));
            float _4631 = _4627.y;
            float _4636 = fract((_4627.x + _4631) * _4631);
            float _4520 = buffer.u_Evolution + _4636;
            float _4522 = floor(_4520);
            float _10556;
            float _10557;
            if (_1383)
            {
                _10557 = floor(mod(_4520 + 1.0, buffer.u_Cycle));
                _10556 = floor(mod(_4520, buffer.u_Cycle));
            }
            else
            {
                _10557 = _4522 + 1.0;
                _10556 = _4522;
            }
            float2 _4548 = fract(_4175 * (fma(_10556, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _4557 = _4548 + float2(dot(_4548, _4548.yx + float2(15.4340000152587890625)));
            float2 _4560 = _4557.yx;
            float2 _4568 = float2(_4636);
            float2 _4581 = fract(_4175 * (fma(_10557, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _4590 = _4581 + float2(dot(_4581, _4581.yx + float2(15.4340000152587890625)));
            float2 _4593 = _4590.yx;
            float2 _4181 = _4153 + float2(1.0);
            float2 _4752 = fract(_4181 * 1324.5179443359375);
            float2 _4761 = _4752 + float2(dot(_4752, _4752.yx + float2(22.5410003662109375)));
            float _4765 = _4761.y;
            float _4770 = fract((_4761.x + _4765) * _4765);
            float _4654 = buffer.u_Evolution + _4770;
            float _4656 = floor(_4654);
            float _10558;
            float _10559;
            if (_1383)
            {
                _10559 = floor(mod(_4654 + 1.0, buffer.u_Cycle));
                _10558 = floor(mod(_4654, buffer.u_Cycle));
            }
            else
            {
                _10559 = _4656 + 1.0;
                _10558 = _4656;
            }
            float2 _4682 = fract(_4181 * (fma(_10558, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _4691 = _4682 + float2(dot(_4682, _4682.yx + float2(15.4340000152587890625)));
            float2 _4694 = _4691.yx;
            float2 _4702 = float2(_4770);
            float2 _4715 = fract(_4181 * (fma(_10559, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _4724 = _4715 + float2(dot(_4715, _4715.yx + float2(15.4340000152587890625)));
            float2 _4727 = _4724.yx;
            float2 _4198 = ((_4159 * _4159) * _4159) * fma(_4159, (_4159 * 6.0) - float2(15.0), float2(10.0));
            float _4212 = _4198.x;
            float _4234 = fma(mix(mix(dot((mix(fract(fma((_4289 + _4292) + float2(0.5230000019073486328125), _4292, _4300)), fract(fma((_4322 + _4325) + float2(0.5230000019073486328125), _4325, _4300)), float2(fract(_4252))) * 2.0) - float2(1.0), _4159), dot((mix(fract(fma((_4423 + _4426) + float2(0.5230000019073486328125), _4426, _4434)), fract(fma((_4456 + _4459) + float2(0.5230000019073486328125), _4459, _4434)), float2(fract(_4386))) * 2.0) - float2(1.0), _4159 - float2(1.0, 0.0)), _4212), mix(dot((mix(fract(fma((_4557 + _4560) + float2(0.5230000019073486328125), _4560, _4568)), fract(fma((_4590 + _4593) + float2(0.5230000019073486328125), _4593, _4568)), float2(fract(_4520))) * 2.0) - float2(1.0), _4159 - float2(0.0, 1.0)), dot((mix(fract(fma((_4691 + _4694) + float2(0.5230000019073486328125), _4694, _4702)), fract(fma((_4724 + _4727) + float2(0.5230000019073486328125), _4727, _4702)), float2(fract(_4654))) * 2.0) - float2(1.0), _4159 - float2(1.0)), _4212), _4198.y), 0.5, 0.5);
            _3373 = _10569 + _10564;
            _3376 = _10564 * buffer.u_SubImpact;
            _3379 = fma(_4234, _10564, _10574);
        }
        float2 _3388 = _10547 - _1209;
        float2 _10118 = _3388;
        _10118.y = _3388.y * _1079;
        float2 _4805 = (_2619 * (_10118 - float2(0.5))) + float2(0.5);
        float2 _10121 = _4805;
        _10121.y = _4805.y * _1109;
        float2 _4850 = ((_10121 * _948) * _1146) * float2(0.00999999977648258209228515625);
        float2 _4851 = floor(_4850);
        float2 _4857 = fract(_4850);
        float2 _5048 = fract(_4851 * 1324.5179443359375);
        float2 _5057 = _5048 + float2(dot(_5048, _5048.yx + float2(22.5410003662109375)));
        float _5061 = _5057.y;
        float _5066 = fract((_5057.x + _5061) * _5061);
        float _4950 = buffer.u_Evolution + _5066;
        float _4952 = floor(_4950);
        float _10580;
        float _10581;
        if (_1383)
        {
            _10581 = floor(mod(_4950 + 1.0, buffer.u_Cycle));
            _10580 = floor(mod(_4950, buffer.u_Cycle));
        }
        else
        {
            _10581 = _4952 + 1.0;
            _10580 = _4952;
        }
        float2 _4978 = fract(_4851 * (fma(_10580, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _4987 = _4978 + float2(dot(_4978, _4978.yx + float2(15.4340000152587890625)));
        float2 _4990 = _4987.yx;
        float2 _4998 = float2(_5066);
        float2 _5011 = fract(_4851 * (fma(_10581, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _5020 = _5011 + float2(dot(_5011, _5011.yx + float2(15.4340000152587890625)));
        float2 _5023 = _5020.yx;
        float2 _4867 = _4851 + float2(1.0, 0.0);
        float2 _5182 = fract(_4867 * 1324.5179443359375);
        float2 _5191 = _5182 + float2(dot(_5182, _5182.yx + float2(22.5410003662109375)));
        float _5195 = _5191.y;
        float _5200 = fract((_5191.x + _5195) * _5195);
        float _5084 = buffer.u_Evolution + _5200;
        float _5086 = floor(_5084);
        float _10582;
        float _10583;
        if (_1383)
        {
            _10583 = floor(mod(_5084 + 1.0, buffer.u_Cycle));
            _10582 = floor(mod(_5084, buffer.u_Cycle));
        }
        else
        {
            _10583 = _5086 + 1.0;
            _10582 = _5086;
        }
        float2 _5112 = fract(_4867 * (fma(_10582, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _5121 = _5112 + float2(dot(_5112, _5112.yx + float2(15.4340000152587890625)));
        float2 _5124 = _5121.yx;
        float2 _5132 = float2(_5200);
        float2 _5145 = fract(_4867 * (fma(_10583, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _5154 = _5145 + float2(dot(_5145, _5145.yx + float2(15.4340000152587890625)));
        float2 _5157 = _5154.yx;
        float2 _4873 = _4851 + float2(0.0, 1.0);
        float2 _5316 = fract(_4873 * 1324.5179443359375);
        float2 _5325 = _5316 + float2(dot(_5316, _5316.yx + float2(22.5410003662109375)));
        float _5329 = _5325.y;
        float _5334 = fract((_5325.x + _5329) * _5329);
        float _5218 = buffer.u_Evolution + _5334;
        float _5220 = floor(_5218);
        float _10584;
        float _10585;
        if (_1383)
        {
            _10585 = floor(mod(_5218 + 1.0, buffer.u_Cycle));
            _10584 = floor(mod(_5218, buffer.u_Cycle));
        }
        else
        {
            _10585 = _5220 + 1.0;
            _10584 = _5220;
        }
        float2 _5246 = fract(_4873 * (fma(_10584, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _5255 = _5246 + float2(dot(_5246, _5246.yx + float2(15.4340000152587890625)));
        float2 _5258 = _5255.yx;
        float2 _5266 = float2(_5334);
        float2 _5279 = fract(_4873 * (fma(_10585, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _5288 = _5279 + float2(dot(_5279, _5279.yx + float2(15.4340000152587890625)));
        float2 _5291 = _5288.yx;
        float2 _4879 = _4851 + float2(1.0);
        float2 _5450 = fract(_4879 * 1324.5179443359375);
        float2 _5459 = _5450 + float2(dot(_5450, _5450.yx + float2(22.5410003662109375)));
        float _5463 = _5459.y;
        float _5468 = fract((_5459.x + _5463) * _5463);
        float _5352 = buffer.u_Evolution + _5468;
        float _5354 = floor(_5352);
        float _10586;
        float _10587;
        if (_1383)
        {
            _10587 = floor(mod(_5352 + 1.0, buffer.u_Cycle));
            _10586 = floor(mod(_5352, buffer.u_Cycle));
        }
        else
        {
            _10587 = _5354 + 1.0;
            _10586 = _5354;
        }
        float2 _5380 = fract(_4879 * (fma(_10586, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _5389 = _5380 + float2(dot(_5380, _5380.yx + float2(15.4340000152587890625)));
        float2 _5392 = _5389.yx;
        float2 _5400 = float2(_5468);
        float2 _5413 = fract(_4879 * (fma(_10587, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _5422 = _5413 + float2(dot(_5413, _5413.yx + float2(15.4340000152587890625)));
        float2 _5425 = _5422.yx;
        float2 _4896 = ((_4857 * _4857) * _4857) * fma(_4857, (_4857 * 6.0) - float2(15.0), float2(10.0));
        float _4910 = _4896.x;
        float _4932 = fma(mix(mix(dot((mix(fract(fma((_4987 + _4990) + float2(0.5230000019073486328125), _4990, _4998)), fract(fma((_5020 + _5023) + float2(0.5230000019073486328125), _5023, _4998)), float2(fract(_4950))) * 2.0) - float2(1.0), _4857), dot((mix(fract(fma((_5121 + _5124) + float2(0.5230000019073486328125), _5124, _5132)), fract(fma((_5154 + _5157) + float2(0.5230000019073486328125), _5157, _5132)), float2(fract(_5084))) * 2.0) - float2(1.0), _4857 - float2(1.0, 0.0)), _4910), mix(dot((mix(fract(fma((_5255 + _5258) + float2(0.5230000019073486328125), _5258, _5266)), fract(fma((_5288 + _5291) + float2(0.5230000019073486328125), _5291, _5266)), float2(fract(_5218))) * 2.0) - float2(1.0), _4857 - float2(0.0, 1.0)), dot((mix(fract(fma((_5389 + _5392) + float2(0.5230000019073486328125), _5392, _5400)), fract(fma((_5422 + _5425) + float2(0.5230000019073486328125), _5425, _5400)), float2(fract(_5352))) * 2.0) - float2(1.0), _4857 - float2(1.0)), _4910), _4896.y), 0.5, 0.5);
        _10634 = fast::clamp(fma(_4932 * _10564, _1150, _10574) / fma(_10564, _1150, _10569), 0.0, 1.0);
        _10603 = fast::clamp(fma(_2755 * _10499, _1150, _10509) / fma(_10499, _1150, _10504), 0.0, 1.0);
    }
    else
    {
        float2 _968 = float2(0.5, _941.y);
        float _970 = fast::clamp(buffer.u_Complexity, 1.0, 10.0);
        float _972 = 100.0 / buffer.u_SubScale;
        float2 _5500 = (float2(720.0) * buffer.u_ScreenParams.xy) / float2(fast::min(buffer.u_ScreenParams.x, buffer.u_ScreenParams.y));
        float _5502 = floor(_970);
        float _5504 = fract(_970);
        float2 _5631 = (_968 * _5500) * float2(0.00999999977648258209228515625);
        float2 _5632 = floor(_5631);
        float2 _5638 = fract(_5631);
        float2 _5829 = fract(_5632 * 1324.5179443359375);
        float2 _5838 = _5829 + float2(dot(_5829, _5829.yx + float2(22.5410003662109375)));
        float _5842 = _5838.y;
        float _5847 = fract((_5838.x + _5842) * _5842);
        float _5731 = buffer.u_Evolution + _5847;
        float _5733 = floor(_5731);
        bool _5737 = buffer.u_Cycle >= 2.0;
        float _10343;
        float _10344;
        if (_5737)
        {
            _10344 = floor(mod(_5731 + 1.0, buffer.u_Cycle));
            _10343 = floor(mod(_5731, buffer.u_Cycle));
        }
        else
        {
            _10344 = _5733 + 1.0;
            _10343 = _5733;
        }
        float2 _5759 = fract(_5632 * (fma(_10343, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _5768 = _5759 + float2(dot(_5759, _5759.yx + float2(15.4340000152587890625)));
        float2 _5771 = _5768.yx;
        float2 _5779 = float2(_5847);
        float2 _5792 = fract(_5632 * (fma(_10344, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _5801 = _5792 + float2(dot(_5792, _5792.yx + float2(15.4340000152587890625)));
        float2 _5804 = _5801.yx;
        float2 _5648 = _5632 + float2(1.0, 0.0);
        float2 _5963 = fract(_5648 * 1324.5179443359375);
        float2 _5972 = _5963 + float2(dot(_5963, _5963.yx + float2(22.5410003662109375)));
        float _5976 = _5972.y;
        float _5981 = fract((_5972.x + _5976) * _5976);
        float _5865 = buffer.u_Evolution + _5981;
        float _5867 = floor(_5865);
        float _10345;
        float _10346;
        if (_5737)
        {
            _10346 = floor(mod(_5865 + 1.0, buffer.u_Cycle));
            _10345 = floor(mod(_5865, buffer.u_Cycle));
        }
        else
        {
            _10346 = _5867 + 1.0;
            _10345 = _5867;
        }
        float2 _5893 = fract(_5648 * (fma(_10345, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _5902 = _5893 + float2(dot(_5893, _5893.yx + float2(15.4340000152587890625)));
        float2 _5905 = _5902.yx;
        float2 _5913 = float2(_5981);
        float2 _5926 = fract(_5648 * (fma(_10346, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _5935 = _5926 + float2(dot(_5926, _5926.yx + float2(15.4340000152587890625)));
        float2 _5938 = _5935.yx;
        float2 _5654 = _5632 + float2(0.0, 1.0);
        float2 _6097 = fract(_5654 * 1324.5179443359375);
        float2 _6106 = _6097 + float2(dot(_6097, _6097.yx + float2(22.5410003662109375)));
        float _6110 = _6106.y;
        float _6115 = fract((_6106.x + _6110) * _6110);
        float _5999 = buffer.u_Evolution + _6115;
        float _6001 = floor(_5999);
        float _10347;
        float _10348;
        if (_5737)
        {
            _10348 = floor(mod(_5999 + 1.0, buffer.u_Cycle));
            _10347 = floor(mod(_5999, buffer.u_Cycle));
        }
        else
        {
            _10348 = _6001 + 1.0;
            _10347 = _6001;
        }
        float2 _6027 = fract(_5654 * (fma(_10347, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _6036 = _6027 + float2(dot(_6027, _6027.yx + float2(15.4340000152587890625)));
        float2 _6039 = _6036.yx;
        float2 _6047 = float2(_6115);
        float2 _6060 = fract(_5654 * (fma(_10348, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _6069 = _6060 + float2(dot(_6060, _6060.yx + float2(15.4340000152587890625)));
        float2 _6072 = _6069.yx;
        float2 _5660 = _5632 + float2(1.0);
        float2 _6231 = fract(_5660 * 1324.5179443359375);
        float2 _6240 = _6231 + float2(dot(_6231, _6231.yx + float2(22.5410003662109375)));
        float _6244 = _6240.y;
        float _6249 = fract((_6240.x + _6244) * _6244);
        float _6133 = buffer.u_Evolution + _6249;
        float _6135 = floor(_6133);
        float _10349;
        float _10350;
        if (_5737)
        {
            _10350 = floor(mod(_6133 + 1.0, buffer.u_Cycle));
            _10349 = floor(mod(_6133, buffer.u_Cycle));
        }
        else
        {
            _10350 = _6135 + 1.0;
            _10349 = _6135;
        }
        float2 _6161 = fract(_5660 * (fma(_10349, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _6170 = _6161 + float2(dot(_6161, _6161.yx + float2(15.4340000152587890625)));
        float2 _6173 = _6170.yx;
        float2 _6181 = float2(_6249);
        float2 _6194 = fract(_5660 * (fma(_10350, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _6203 = _6194 + float2(dot(_6194, _6194.yx + float2(15.4340000152587890625)));
        float2 _6206 = _6203.yx;
        float2 _5677 = ((_5638 * _5638) * _5638) * fma(_5638, (_5638 * 6.0) - float2(15.0), float2(10.0));
        float _5691 = _5677.x;
        float _5713 = fma(mix(mix(dot((mix(fract(fma((_5768 + _5771) + float2(0.5230000019073486328125), _5771, _5779)), fract(fma((_5801 + _5804) + float2(0.5230000019073486328125), _5804, _5779)), float2(fract(_5731))) * 2.0) - float2(1.0), _5638), dot((mix(fract(fma((_5902 + _5905) + float2(0.5230000019073486328125), _5905, _5913)), fract(fma((_5935 + _5938) + float2(0.5230000019073486328125), _5938, _5913)), float2(fract(_5865))) * 2.0) - float2(1.0), _5638 - float2(1.0, 0.0)), _5691), mix(dot((mix(fract(fma((_6036 + _6039) + float2(0.5230000019073486328125), _6039, _6047)), fract(fma((_6069 + _6072) + float2(0.5230000019073486328125), _6072, _6047)), float2(fract(_5999))) * 2.0) - float2(1.0), _5638 - float2(0.0, 1.0)), dot((mix(fract(fma((_6170 + _6173) + float2(0.5230000019073486328125), _6173, _6181)), fract(fma((_6203 + _6206) + float2(0.5230000019073486328125), _6206, _6181)), float2(fract(_6133))) * 2.0) - float2(1.0), _5638 - float2(1.0)), _5691), _5677.y), 0.5, 0.5);
        float2 _10352;
        float _10369;
        float _10374;
        float _10379;
        _10379 = _5713;
        _10374 = 1.0;
        _10369 = buffer.u_SubImpact;
        _10352 = _968;
        float2 _5539;
        float _5550;
        float _5553;
        float _5556;
        for (float _10351 = 2.0; _10351 <= 10.0; _10379 = _5556, _10374 = _5550, _10369 = _5553, _10352 = _5539, _10351 += 1.0)
        {
            if (_10351 > _5502)
            {
                break;
            }
            float2 _5531 = _10352 - (buffer.u_SubOffset / _5500);
            float _5534 = buffer.u_SubRotate * 0.01745329238474369049072265625;
            float2 _10179 = _5531;
            _10179.y = _5531.y * _1079;
            float _6265 = sin(_5534);
            float _6267 = cos(_5534);
            float2 _6284 = (float2x2(float2(_6267, _6265), float2(-_6265, _6267)) * (_10179 - float2(0.5))) + float2(0.5);
            float2 _10182 = _6284;
            _10182.y = _6284.y * _1109;
            _5539 = _10182 * _972;
            float2 _6329 = (_5539 * _5500) * float2(0.00999999977648258209228515625);
            float2 _6330 = floor(_6329);
            float2 _6336 = fract(_6329);
            float2 _6527 = fract(_6330 * 1324.5179443359375);
            float2 _6536 = _6527 + float2(dot(_6527, _6527.yx + float2(22.5410003662109375)));
            float _6540 = _6536.y;
            float _6545 = fract((_6536.x + _6540) * _6540);
            float _6429 = buffer.u_Evolution + _6545;
            float _6431 = floor(_6429);
            float _10357;
            float _10358;
            if (_5737)
            {
                _10358 = floor(mod(_6429 + 1.0, buffer.u_Cycle));
                _10357 = floor(mod(_6429, buffer.u_Cycle));
            }
            else
            {
                _10358 = _6431 + 1.0;
                _10357 = _6431;
            }
            float2 _6457 = fract(_6330 * (fma(_10357, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _6466 = _6457 + float2(dot(_6457, _6457.yx + float2(15.4340000152587890625)));
            float2 _6469 = _6466.yx;
            float2 _6477 = float2(_6545);
            float2 _6490 = fract(_6330 * (fma(_10358, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _6499 = _6490 + float2(dot(_6490, _6490.yx + float2(15.4340000152587890625)));
            float2 _6502 = _6499.yx;
            float2 _6346 = _6330 + float2(1.0, 0.0);
            float2 _6661 = fract(_6346 * 1324.5179443359375);
            float2 _6670 = _6661 + float2(dot(_6661, _6661.yx + float2(22.5410003662109375)));
            float _6674 = _6670.y;
            float _6679 = fract((_6670.x + _6674) * _6674);
            float _6563 = buffer.u_Evolution + _6679;
            float _6565 = floor(_6563);
            float _10359;
            float _10360;
            if (_5737)
            {
                _10360 = floor(mod(_6563 + 1.0, buffer.u_Cycle));
                _10359 = floor(mod(_6563, buffer.u_Cycle));
            }
            else
            {
                _10360 = _6565 + 1.0;
                _10359 = _6565;
            }
            float2 _6591 = fract(_6346 * (fma(_10359, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _6600 = _6591 + float2(dot(_6591, _6591.yx + float2(15.4340000152587890625)));
            float2 _6603 = _6600.yx;
            float2 _6611 = float2(_6679);
            float2 _6624 = fract(_6346 * (fma(_10360, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _6633 = _6624 + float2(dot(_6624, _6624.yx + float2(15.4340000152587890625)));
            float2 _6636 = _6633.yx;
            float2 _6352 = _6330 + float2(0.0, 1.0);
            float2 _6795 = fract(_6352 * 1324.5179443359375);
            float2 _6804 = _6795 + float2(dot(_6795, _6795.yx + float2(22.5410003662109375)));
            float _6808 = _6804.y;
            float _6813 = fract((_6804.x + _6808) * _6808);
            float _6697 = buffer.u_Evolution + _6813;
            float _6699 = floor(_6697);
            float _10361;
            float _10362;
            if (_5737)
            {
                _10362 = floor(mod(_6697 + 1.0, buffer.u_Cycle));
                _10361 = floor(mod(_6697, buffer.u_Cycle));
            }
            else
            {
                _10362 = _6699 + 1.0;
                _10361 = _6699;
            }
            float2 _6725 = fract(_6352 * (fma(_10361, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _6734 = _6725 + float2(dot(_6725, _6725.yx + float2(15.4340000152587890625)));
            float2 _6737 = _6734.yx;
            float2 _6745 = float2(_6813);
            float2 _6758 = fract(_6352 * (fma(_10362, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _6767 = _6758 + float2(dot(_6758, _6758.yx + float2(15.4340000152587890625)));
            float2 _6770 = _6767.yx;
            float2 _6358 = _6330 + float2(1.0);
            float2 _6929 = fract(_6358 * 1324.5179443359375);
            float2 _6938 = _6929 + float2(dot(_6929, _6929.yx + float2(22.5410003662109375)));
            float _6942 = _6938.y;
            float _6947 = fract((_6938.x + _6942) * _6942);
            float _6831 = buffer.u_Evolution + _6947;
            float _6833 = floor(_6831);
            float _10363;
            float _10364;
            if (_5737)
            {
                _10364 = floor(mod(_6831 + 1.0, buffer.u_Cycle));
                _10363 = floor(mod(_6831, buffer.u_Cycle));
            }
            else
            {
                _10364 = _6833 + 1.0;
                _10363 = _6833;
            }
            float2 _6859 = fract(_6358 * (fma(_10363, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _6868 = _6859 + float2(dot(_6859, _6859.yx + float2(15.4340000152587890625)));
            float2 _6871 = _6868.yx;
            float2 _6879 = float2(_6947);
            float2 _6892 = fract(_6358 * (fma(_10364, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
            float2 _6901 = _6892 + float2(dot(_6892, _6892.yx + float2(15.4340000152587890625)));
            float2 _6904 = _6901.yx;
            float2 _6375 = ((_6336 * _6336) * _6336) * fma(_6336, (_6336 * 6.0) - float2(15.0), float2(10.0));
            float _6389 = _6375.x;
            float _6411 = fma(mix(mix(dot((mix(fract(fma((_6466 + _6469) + float2(0.5230000019073486328125), _6469, _6477)), fract(fma((_6499 + _6502) + float2(0.5230000019073486328125), _6502, _6477)), float2(fract(_6429))) * 2.0) - float2(1.0), _6336), dot((mix(fract(fma((_6600 + _6603) + float2(0.5230000019073486328125), _6603, _6611)), fract(fma((_6633 + _6636) + float2(0.5230000019073486328125), _6636, _6611)), float2(fract(_6563))) * 2.0) - float2(1.0), _6336 - float2(1.0, 0.0)), _6389), mix(dot((mix(fract(fma((_6734 + _6737) + float2(0.5230000019073486328125), _6737, _6745)), fract(fma((_6767 + _6770) + float2(0.5230000019073486328125), _6770, _6745)), float2(fract(_6697))) * 2.0) - float2(1.0), _6336 - float2(0.0, 1.0)), dot((mix(fract(fma((_6868 + _6871) + float2(0.5230000019073486328125), _6871, _6879)), fract(fma((_6901 + _6904) + float2(0.5230000019073486328125), _6904, _6879)), float2(fract(_6831))) * 2.0) - float2(1.0), _6336 - float2(1.0)), _6389), _6375.y), 0.5, 0.5);
            _5550 = _10374 + _10369;
            _5553 = _10369 * buffer.u_SubImpact;
            _5556 = fma(_6411, _10369, _10379);
        }
        float2 _5563 = buffer.u_SubOffset / _5500;
        float2 _5565 = _10352 - _5563;
        float _5568 = buffer.u_SubRotate * 0.01745329238474369049072265625;
        float2 _10212 = _5565;
        _10212.y = _5565.y * _1079;
        float _6963 = sin(_5568);
        float _6965 = cos(_5568);
        float2x2 _6973 = float2x2(float2(_6965, _6963), float2(-_6963, _6965));
        float2 _6982 = (_6973 * (_10212 - float2(0.5))) + float2(0.5);
        float2 _10215 = _6982;
        _10215.y = _6982.y * _1109;
        float2 _7027 = ((_10215 * _972) * _5500) * float2(0.00999999977648258209228515625);
        float2 _7028 = floor(_7027);
        float2 _7034 = fract(_7027);
        float2 _7225 = fract(_7028 * 1324.5179443359375);
        float2 _7234 = _7225 + float2(dot(_7225, _7225.yx + float2(22.5410003662109375)));
        float _7238 = _7234.y;
        float _7243 = fract((_7234.x + _7238) * _7238);
        float _7127 = buffer.u_Evolution + _7243;
        float _7129 = floor(_7127);
        float _10385;
        float _10386;
        if (_5737)
        {
            _10386 = floor(mod(_7127 + 1.0, buffer.u_Cycle));
            _10385 = floor(mod(_7127, buffer.u_Cycle));
        }
        else
        {
            _10386 = _7129 + 1.0;
            _10385 = _7129;
        }
        float2 _7155 = fract(_7028 * (fma(_10385, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _7164 = _7155 + float2(dot(_7155, _7155.yx + float2(15.4340000152587890625)));
        float2 _7167 = _7164.yx;
        float2 _7175 = float2(_7243);
        float2 _7188 = fract(_7028 * (fma(_10386, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _7197 = _7188 + float2(dot(_7188, _7188.yx + float2(15.4340000152587890625)));
        float2 _7200 = _7197.yx;
        float2 _7044 = _7028 + float2(1.0, 0.0);
        float2 _7359 = fract(_7044 * 1324.5179443359375);
        float2 _7368 = _7359 + float2(dot(_7359, _7359.yx + float2(22.5410003662109375)));
        float _7372 = _7368.y;
        float _7377 = fract((_7368.x + _7372) * _7372);
        float _7261 = buffer.u_Evolution + _7377;
        float _7263 = floor(_7261);
        float _10387;
        float _10388;
        if (_5737)
        {
            _10388 = floor(mod(_7261 + 1.0, buffer.u_Cycle));
            _10387 = floor(mod(_7261, buffer.u_Cycle));
        }
        else
        {
            _10388 = _7263 + 1.0;
            _10387 = _7263;
        }
        float2 _7289 = fract(_7044 * (fma(_10387, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _7298 = _7289 + float2(dot(_7289, _7289.yx + float2(15.4340000152587890625)));
        float2 _7301 = _7298.yx;
        float2 _7309 = float2(_7377);
        float2 _7322 = fract(_7044 * (fma(_10388, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _7331 = _7322 + float2(dot(_7322, _7322.yx + float2(15.4340000152587890625)));
        float2 _7334 = _7331.yx;
        float2 _7050 = _7028 + float2(0.0, 1.0);
        float2 _7493 = fract(_7050 * 1324.5179443359375);
        float2 _7502 = _7493 + float2(dot(_7493, _7493.yx + float2(22.5410003662109375)));
        float _7506 = _7502.y;
        float _7511 = fract((_7502.x + _7506) * _7506);
        float _7395 = buffer.u_Evolution + _7511;
        float _7397 = floor(_7395);
        float _10389;
        float _10390;
        if (_5737)
        {
            _10390 = floor(mod(_7395 + 1.0, buffer.u_Cycle));
            _10389 = floor(mod(_7395, buffer.u_Cycle));
        }
        else
        {
            _10390 = _7397 + 1.0;
            _10389 = _7397;
        }
        float2 _7423 = fract(_7050 * (fma(_10389, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _7432 = _7423 + float2(dot(_7423, _7423.yx + float2(15.4340000152587890625)));
        float2 _7435 = _7432.yx;
        float2 _7443 = float2(_7511);
        float2 _7456 = fract(_7050 * (fma(_10390, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _7465 = _7456 + float2(dot(_7456, _7456.yx + float2(15.4340000152587890625)));
        float2 _7468 = _7465.yx;
        float2 _7056 = _7028 + float2(1.0);
        float2 _7627 = fract(_7056 * 1324.5179443359375);
        float2 _7636 = _7627 + float2(dot(_7627, _7627.yx + float2(22.5410003662109375)));
        float _7640 = _7636.y;
        float _7645 = fract((_7636.x + _7640) * _7640);
        float _7529 = buffer.u_Evolution + _7645;
        float _7531 = floor(_7529);
        float _10391;
        float _10392;
        if (_5737)
        {
            _10392 = floor(mod(_7529 + 1.0, buffer.u_Cycle));
            _10391 = floor(mod(_7529, buffer.u_Cycle));
        }
        else
        {
            _10392 = _7531 + 1.0;
            _10391 = _7531;
        }
        float2 _7557 = fract(_7056 * (fma(_10391, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _7566 = _7557 + float2(dot(_7557, _7557.yx + float2(15.4340000152587890625)));
        float2 _7569 = _7566.yx;
        float2 _7577 = float2(_7645);
        float2 _7590 = fract(_7056 * (fma(_10392, 2.4119999408721923828125, 34.532001495361328125) + 0.80309998989105224609375));
        float2 _7599 = _7590 + float2(dot(_7590, _7590.yx + float2(15.4340000152587890625)));
        float2 _7602 = _7599.yx;
        float2 _7073 = ((_7034 * _7034) * _7034) * fma(_7034, (_7034 * 6.0) - float2(15.0), float2(10.0));
        float _7087 = _7073.x;
        float _7109 = fma(mix(mix(dot((mix(fract(fma((_7164 + _7167) + float2(0.5230000019073486328125), _7167, _7175)), fract(fma((_7197 + _7200) + float2(0.5230000019073486328125), _7200, _7175)), float2(fract(_7127))) * 2.0) - float2(1.0), _7034), dot((mix(fract(fma((_7298 + _7301) + float2(0.5230000019073486328125), _7301, _7309)), fract(fma((_7331 + _7334) + float2(0.5230000019073486328125), _7334, _7309)), float2(fract(_7261))) * 2.0) - float2(1.0), _7034 - float2(1.0, 0.0)), _7087), mix(dot((mix(fract(fma((_7432 + _7435) + float2(0.5230000019073486328125), _7435, _7443)), fract(fma((_7465 + _7468) + float2(0.5230000019073486328125), _7468, _7443)), float2(fract(_7395))) * 2.0) - float2(1.0), _7034 - float2(0.0, 1.0)), dot((mix(fract(fma((_7566 + _7569) + float2(0.5230000019073486328125), _7569, _7577)), fract(fma((_7599 + _7602) + float2(0.5230000019073486328125), _7602, _7577)), float2(fract(_7529))) * 2.0) - float2(1.0), _7034 - float2(1.0)), _7087), _7073.y), 0.5, 0.5);
        float2 _980 = float2(_941.x, 0.5);
        float2 _7808 = (_980 * _5500) * float2(0.00999999977648258209228515625);
        float2 _7809 = floor(_7808);
        float2 _7815 = fract(_7808);
        float2 _8006 = fract(_7809 * 1324.5179443359375);
        float2 _8015 = _8006 + float2(dot(_8006, _8006.yx + float2(22.5410003662109375)));
        float _8019 = _8015.y;
        float _8024 = fract((_8015.x + _8019) * _8019);
        float _7908 = buffer.u_Evolution + _8024;
        float _7910 = floor(_7908);
        float _10408;
        float _10409;
        if (_5737)
        {
            _10409 = floor(mod(_7908 + 1.0, buffer.u_Cycle));
            _10408 = floor(mod(_7908, buffer.u_Cycle));
        }
        else
        {
            _10409 = _7910 + 1.0;
            _10408 = _7910;
        }
        float2 _7936 = fract(_7809 * (fma(_10408, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _7945 = _7936 + float2(dot(_7936, _7936.yx + float2(15.4340000152587890625)));
        float2 _7948 = _7945.yx;
        float2 _7956 = float2(_8024);
        float2 _7969 = fract(_7809 * (fma(_10409, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _7978 = _7969 + float2(dot(_7969, _7969.yx + float2(15.4340000152587890625)));
        float2 _7981 = _7978.yx;
        float2 _7825 = _7809 + float2(1.0, 0.0);
        float2 _8140 = fract(_7825 * 1324.5179443359375);
        float2 _8149 = _8140 + float2(dot(_8140, _8140.yx + float2(22.5410003662109375)));
        float _8153 = _8149.y;
        float _8158 = fract((_8149.x + _8153) * _8153);
        float _8042 = buffer.u_Evolution + _8158;
        float _8044 = floor(_8042);
        float _10410;
        float _10411;
        if (_5737)
        {
            _10411 = floor(mod(_8042 + 1.0, buffer.u_Cycle));
            _10410 = floor(mod(_8042, buffer.u_Cycle));
        }
        else
        {
            _10411 = _8044 + 1.0;
            _10410 = _8044;
        }
        float2 _8070 = fract(_7825 * (fma(_10410, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _8079 = _8070 + float2(dot(_8070, _8070.yx + float2(15.4340000152587890625)));
        float2 _8082 = _8079.yx;
        float2 _8090 = float2(_8158);
        float2 _8103 = fract(_7825 * (fma(_10411, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _8112 = _8103 + float2(dot(_8103, _8103.yx + float2(15.4340000152587890625)));
        float2 _8115 = _8112.yx;
        float2 _7831 = _7809 + float2(0.0, 1.0);
        float2 _8274 = fract(_7831 * 1324.5179443359375);
        float2 _8283 = _8274 + float2(dot(_8274, _8274.yx + float2(22.5410003662109375)));
        float _8287 = _8283.y;
        float _8292 = fract((_8283.x + _8287) * _8287);
        float _8176 = buffer.u_Evolution + _8292;
        float _8178 = floor(_8176);
        float _10412;
        float _10413;
        if (_5737)
        {
            _10413 = floor(mod(_8176 + 1.0, buffer.u_Cycle));
            _10412 = floor(mod(_8176, buffer.u_Cycle));
        }
        else
        {
            _10413 = _8178 + 1.0;
            _10412 = _8178;
        }
        float2 _8204 = fract(_7831 * (fma(_10412, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _8213 = _8204 + float2(dot(_8204, _8204.yx + float2(15.4340000152587890625)));
        float2 _8216 = _8213.yx;
        float2 _8224 = float2(_8292);
        float2 _8237 = fract(_7831 * (fma(_10413, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _8246 = _8237 + float2(dot(_8237, _8237.yx + float2(15.4340000152587890625)));
        float2 _8249 = _8246.yx;
        float2 _7837 = _7809 + float2(1.0);
        float2 _8408 = fract(_7837 * 1324.5179443359375);
        float2 _8417 = _8408 + float2(dot(_8408, _8408.yx + float2(22.5410003662109375)));
        float _8421 = _8417.y;
        float _8426 = fract((_8417.x + _8421) * _8421);
        float _8310 = buffer.u_Evolution + _8426;
        float _8312 = floor(_8310);
        float _10414;
        float _10415;
        if (_5737)
        {
            _10415 = floor(mod(_8310 + 1.0, buffer.u_Cycle));
            _10414 = floor(mod(_8310, buffer.u_Cycle));
        }
        else
        {
            _10415 = _8312 + 1.0;
            _10414 = _8312;
        }
        float2 _8338 = fract(_7837 * (fma(_10414, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _8347 = _8338 + float2(dot(_8338, _8338.yx + float2(15.4340000152587890625)));
        float2 _8350 = _8347.yx;
        float2 _8358 = float2(_8426);
        float2 _8371 = fract(_7837 * (fma(_10415, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _8380 = _8371 + float2(dot(_8371, _8371.yx + float2(15.4340000152587890625)));
        float2 _8383 = _8380.yx;
        float2 _7854 = ((_7815 * _7815) * _7815) * fma(_7815, (_7815 * 6.0) - float2(15.0), float2(10.0));
        float _7868 = _7854.x;
        float _7890 = fma(mix(mix(dot((mix(fract(fma((_7945 + _7948) + float2(0.5230000019073486328125), _7948, _7956)), fract(fma((_7978 + _7981) + float2(0.5230000019073486328125), _7981, _7956)), float2(fract(_7908))) * 2.0) - float2(1.0), _7815), dot((mix(fract(fma((_8079 + _8082) + float2(0.5230000019073486328125), _8082, _8090)), fract(fma((_8112 + _8115) + float2(0.5230000019073486328125), _8115, _8090)), float2(fract(_8042))) * 2.0) - float2(1.0), _7815 - float2(1.0, 0.0)), _7868), mix(dot((mix(fract(fma((_8213 + _8216) + float2(0.5230000019073486328125), _8216, _8224)), fract(fma((_8246 + _8249) + float2(0.5230000019073486328125), _8249, _8224)), float2(fract(_8176))) * 2.0) - float2(1.0), _7815 - float2(0.0, 1.0)), dot((mix(fract(fma((_8347 + _8350) + float2(0.5230000019073486328125), _8350, _8358)), fract(fma((_8380 + _8383) + float2(0.5230000019073486328125), _8383, _8358)), float2(fract(_8310))) * 2.0) - float2(1.0), _7815 - float2(1.0)), _7868), _7854.y), 0.5, 0.5);
        float2 _10417;
        float _10434;
        float _10439;
        float _10444;
        _10444 = _7890;
        _10439 = 1.0;
        _10434 = buffer.u_SubImpact;
        _10417 = _980;
        float2 _7716;
        float _7727;
        float _7730;
        float _7733;
        for (float _10416 = 2.0; _10416 <= 10.0; _10444 = _7733, _10439 = _7727, _10434 = _7730, _10417 = _7716, _10416 += 1.0)
        {
            if (_10416 > _5502)
            {
                break;
            }
            float2 _7708 = _10417 - _5563;
            float2 _10273 = _7708;
            _10273.y = _7708.y * _1079;
            float2 _8461 = (_6973 * (_10273 - float2(0.5))) + float2(0.5);
            float2 _10276 = _8461;
            _10276.y = _8461.y * _1109;
            _7716 = _10276 * _972;
            float2 _8506 = (_7716 * _5500) * float2(0.00999999977648258209228515625);
            float2 _8507 = floor(_8506);
            float2 _8513 = fract(_8506);
            float2 _8704 = fract(_8507 * 1324.5179443359375);
            float2 _8713 = _8704 + float2(dot(_8704, _8704.yx + float2(22.5410003662109375)));
            float _8717 = _8713.y;
            float _8722 = fract((_8713.x + _8717) * _8717);
            float _8606 = buffer.u_Evolution + _8722;
            float _8608 = floor(_8606);
            float _10422;
            float _10423;
            if (_5737)
            {
                _10423 = floor(mod(_8606 + 1.0, buffer.u_Cycle));
                _10422 = floor(mod(_8606, buffer.u_Cycle));
            }
            else
            {
                _10423 = _8608 + 1.0;
                _10422 = _8608;
            }
            float2 _8634 = fract(_8507 * (fma(_10422, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _8643 = _8634 + float2(dot(_8634, _8634.yx + float2(15.4340000152587890625)));
            float2 _8646 = _8643.yx;
            float2 _8654 = float2(_8722);
            float2 _8667 = fract(_8507 * (fma(_10423, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _8676 = _8667 + float2(dot(_8667, _8667.yx + float2(15.4340000152587890625)));
            float2 _8679 = _8676.yx;
            float2 _8523 = _8507 + float2(1.0, 0.0);
            float2 _8838 = fract(_8523 * 1324.5179443359375);
            float2 _8847 = _8838 + float2(dot(_8838, _8838.yx + float2(22.5410003662109375)));
            float _8851 = _8847.y;
            float _8856 = fract((_8847.x + _8851) * _8851);
            float _8740 = buffer.u_Evolution + _8856;
            float _8742 = floor(_8740);
            float _10424;
            float _10425;
            if (_5737)
            {
                _10425 = floor(mod(_8740 + 1.0, buffer.u_Cycle));
                _10424 = floor(mod(_8740, buffer.u_Cycle));
            }
            else
            {
                _10425 = _8742 + 1.0;
                _10424 = _8742;
            }
            float2 _8768 = fract(_8523 * (fma(_10424, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _8777 = _8768 + float2(dot(_8768, _8768.yx + float2(15.4340000152587890625)));
            float2 _8780 = _8777.yx;
            float2 _8788 = float2(_8856);
            float2 _8801 = fract(_8523 * (fma(_10425, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _8810 = _8801 + float2(dot(_8801, _8801.yx + float2(15.4340000152587890625)));
            float2 _8813 = _8810.yx;
            float2 _8529 = _8507 + float2(0.0, 1.0);
            float2 _8972 = fract(_8529 * 1324.5179443359375);
            float2 _8981 = _8972 + float2(dot(_8972, _8972.yx + float2(22.5410003662109375)));
            float _8985 = _8981.y;
            float _8990 = fract((_8981.x + _8985) * _8985);
            float _8874 = buffer.u_Evolution + _8990;
            float _8876 = floor(_8874);
            float _10426;
            float _10427;
            if (_5737)
            {
                _10427 = floor(mod(_8874 + 1.0, buffer.u_Cycle));
                _10426 = floor(mod(_8874, buffer.u_Cycle));
            }
            else
            {
                _10427 = _8876 + 1.0;
                _10426 = _8876;
            }
            float2 _8902 = fract(_8529 * (fma(_10426, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _8911 = _8902 + float2(dot(_8902, _8902.yx + float2(15.4340000152587890625)));
            float2 _8914 = _8911.yx;
            float2 _8922 = float2(_8990);
            float2 _8935 = fract(_8529 * (fma(_10427, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _8944 = _8935 + float2(dot(_8935, _8935.yx + float2(15.4340000152587890625)));
            float2 _8947 = _8944.yx;
            float2 _8535 = _8507 + float2(1.0);
            float2 _9106 = fract(_8535 * 1324.5179443359375);
            float2 _9115 = _9106 + float2(dot(_9106, _9106.yx + float2(22.5410003662109375)));
            float _9119 = _9115.y;
            float _9124 = fract((_9115.x + _9119) * _9119);
            float _9008 = buffer.u_Evolution + _9124;
            float _9010 = floor(_9008);
            float _10428;
            float _10429;
            if (_5737)
            {
                _10429 = floor(mod(_9008 + 1.0, buffer.u_Cycle));
                _10428 = floor(mod(_9008, buffer.u_Cycle));
            }
            else
            {
                _10429 = _9010 + 1.0;
                _10428 = _9010;
            }
            float2 _9036 = fract(_8535 * (fma(_10428, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _9045 = _9036 + float2(dot(_9036, _9036.yx + float2(15.4340000152587890625)));
            float2 _9048 = _9045.yx;
            float2 _9056 = float2(_9124);
            float2 _9069 = fract(_8535 * (fma(_10429, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
            float2 _9078 = _9069 + float2(dot(_9069, _9069.yx + float2(15.4340000152587890625)));
            float2 _9081 = _9078.yx;
            float2 _8552 = ((_8513 * _8513) * _8513) * fma(_8513, (_8513 * 6.0) - float2(15.0), float2(10.0));
            float _8566 = _8552.x;
            float _8588 = fma(mix(mix(dot((mix(fract(fma((_8643 + _8646) + float2(0.5230000019073486328125), _8646, _8654)), fract(fma((_8676 + _8679) + float2(0.5230000019073486328125), _8679, _8654)), float2(fract(_8606))) * 2.0) - float2(1.0), _8513), dot((mix(fract(fma((_8777 + _8780) + float2(0.5230000019073486328125), _8780, _8788)), fract(fma((_8810 + _8813) + float2(0.5230000019073486328125), _8813, _8788)), float2(fract(_8740))) * 2.0) - float2(1.0), _8513 - float2(1.0, 0.0)), _8566), mix(dot((mix(fract(fma((_8911 + _8914) + float2(0.5230000019073486328125), _8914, _8922)), fract(fma((_8944 + _8947) + float2(0.5230000019073486328125), _8947, _8922)), float2(fract(_8874))) * 2.0) - float2(1.0), _8513 - float2(0.0, 1.0)), dot((mix(fract(fma((_9045 + _9048) + float2(0.5230000019073486328125), _9048, _9056)), fract(fma((_9078 + _9081) + float2(0.5230000019073486328125), _9081, _9056)), float2(fract(_9008))) * 2.0) - float2(1.0), _8513 - float2(1.0)), _8566), _8552.y), 0.5, 0.5);
            _7727 = _10439 + _10434;
            _7730 = _10434 * buffer.u_SubImpact;
            _7733 = fma(_8588, _10434, _10444);
        }
        float2 _7742 = _10417 - _5563;
        float2 _10306 = _7742;
        _10306.y = _7742.y * _1079;
        float2 _9159 = (_6973 * (_10306 - float2(0.5))) + float2(0.5);
        float2 _10309 = _9159;
        _10309.y = _9159.y * _1109;
        float2 _9204 = ((_10309 * _972) * _5500) * float2(0.00999999977648258209228515625);
        float2 _9205 = floor(_9204);
        float2 _9211 = fract(_9204);
        float2 _9402 = fract(_9205 * 1324.5179443359375);
        float2 _9411 = _9402 + float2(dot(_9402, _9402.yx + float2(22.5410003662109375)));
        float _9415 = _9411.y;
        float _9420 = fract((_9411.x + _9415) * _9415);
        float _9304 = buffer.u_Evolution + _9420;
        float _9306 = floor(_9304);
        float _10450;
        float _10451;
        if (_5737)
        {
            _10451 = floor(mod(_9304 + 1.0, buffer.u_Cycle));
            _10450 = floor(mod(_9304, buffer.u_Cycle));
        }
        else
        {
            _10451 = _9306 + 1.0;
            _10450 = _9306;
        }
        float2 _9332 = fract(_9205 * (fma(_10450, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _9341 = _9332 + float2(dot(_9332, _9332.yx + float2(15.4340000152587890625)));
        float2 _9344 = _9341.yx;
        float2 _9352 = float2(_9420);
        float2 _9365 = fract(_9205 * (fma(_10451, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _9374 = _9365 + float2(dot(_9365, _9365.yx + float2(15.4340000152587890625)));
        float2 _9377 = _9374.yx;
        float2 _9221 = _9205 + float2(1.0, 0.0);
        float2 _9536 = fract(_9221 * 1324.5179443359375);
        float2 _9545 = _9536 + float2(dot(_9536, _9536.yx + float2(22.5410003662109375)));
        float _9549 = _9545.y;
        float _9554 = fract((_9545.x + _9549) * _9549);
        float _9438 = buffer.u_Evolution + _9554;
        float _9440 = floor(_9438);
        float _10452;
        float _10453;
        if (_5737)
        {
            _10453 = floor(mod(_9438 + 1.0, buffer.u_Cycle));
            _10452 = floor(mod(_9438, buffer.u_Cycle));
        }
        else
        {
            _10453 = _9440 + 1.0;
            _10452 = _9440;
        }
        float2 _9466 = fract(_9221 * (fma(_10452, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _9475 = _9466 + float2(dot(_9466, _9466.yx + float2(15.4340000152587890625)));
        float2 _9478 = _9475.yx;
        float2 _9486 = float2(_9554);
        float2 _9499 = fract(_9221 * (fma(_10453, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _9508 = _9499 + float2(dot(_9499, _9499.yx + float2(15.4340000152587890625)));
        float2 _9511 = _9508.yx;
        float2 _9227 = _9205 + float2(0.0, 1.0);
        float2 _9670 = fract(_9227 * 1324.5179443359375);
        float2 _9679 = _9670 + float2(dot(_9670, _9670.yx + float2(22.5410003662109375)));
        float _9683 = _9679.y;
        float _9688 = fract((_9679.x + _9683) * _9683);
        float _9572 = buffer.u_Evolution + _9688;
        float _9574 = floor(_9572);
        float _10454;
        float _10455;
        if (_5737)
        {
            _10455 = floor(mod(_9572 + 1.0, buffer.u_Cycle));
            _10454 = floor(mod(_9572, buffer.u_Cycle));
        }
        else
        {
            _10455 = _9574 + 1.0;
            _10454 = _9574;
        }
        float2 _9600 = fract(_9227 * (fma(_10454, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _9609 = _9600 + float2(dot(_9600, _9600.yx + float2(15.4340000152587890625)));
        float2 _9612 = _9609.yx;
        float2 _9620 = float2(_9688);
        float2 _9633 = fract(_9227 * (fma(_10455, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _9642 = _9633 + float2(dot(_9633, _9633.yx + float2(15.4340000152587890625)));
        float2 _9645 = _9642.yx;
        float2 _9233 = _9205 + float2(1.0);
        float2 _9804 = fract(_9233 * 1324.5179443359375);
        float2 _9813 = _9804 + float2(dot(_9804, _9804.yx + float2(22.5410003662109375)));
        float _9817 = _9813.y;
        float _9822 = fract((_9813.x + _9817) * _9817);
        float _9706 = buffer.u_Evolution + _9822;
        float _9708 = floor(_9706);
        float _10456;
        float _10457;
        if (_5737)
        {
            _10457 = floor(mod(_9706 + 1.0, buffer.u_Cycle));
            _10456 = floor(mod(_9706, buffer.u_Cycle));
        }
        else
        {
            _10457 = _9708 + 1.0;
            _10456 = _9708;
        }
        float2 _9734 = fract(_9233 * (fma(_10456, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _9743 = _9734 + float2(dot(_9734, _9734.yx + float2(15.4340000152587890625)));
        float2 _9746 = _9743.yx;
        float2 _9754 = float2(_9822);
        float2 _9767 = fract(_9233 * (fma(_10457, 2.4119999408721923828125, 34.532001495361328125) + 2.4092998504638671875));
        float2 _9776 = _9767 + float2(dot(_9767, _9767.yx + float2(15.4340000152587890625)));
        float2 _9779 = _9776.yx;
        float2 _9250 = ((_9211 * _9211) * _9211) * fma(_9211, (_9211 * 6.0) - float2(15.0), float2(10.0));
        float _9264 = _9250.x;
        float _9286 = fma(mix(mix(dot((mix(fract(fma((_9341 + _9344) + float2(0.5230000019073486328125), _9344, _9352)), fract(fma((_9374 + _9377) + float2(0.5230000019073486328125), _9377, _9352)), float2(fract(_9304))) * 2.0) - float2(1.0), _9211), dot((mix(fract(fma((_9475 + _9478) + float2(0.5230000019073486328125), _9478, _9486)), fract(fma((_9508 + _9511) + float2(0.5230000019073486328125), _9511, _9486)), float2(fract(_9438))) * 2.0) - float2(1.0), _9211 - float2(1.0, 0.0)), _9264), mix(dot((mix(fract(fma((_9609 + _9612) + float2(0.5230000019073486328125), _9612, _9620)), fract(fma((_9642 + _9645) + float2(0.5230000019073486328125), _9645, _9620)), float2(fract(_9572))) * 2.0) - float2(1.0), _9211 - float2(0.0, 1.0)), dot((mix(fract(fma((_9743 + _9746) + float2(0.5230000019073486328125), _9746, _9754)), fract(fma((_9776 + _9779) + float2(0.5230000019073486328125), _9779, _9754)), float2(fract(_9706))) * 2.0) - float2(1.0), _9211 - float2(1.0)), _9264), _9250.y), 0.5, 0.5);
        _10634 = fast::clamp(fma(_9286 * _10434, _5504, _10444) / fma(_10434, _5504, _10439), 0.0, 1.0);
        _10603 = fast::clamp(fma(_7109 * _10369, _5504, _10379) / fma(_10369, _5504, _10374), 0.0, 1.0);
    }
    float _9827 = _10603 + buffer.u_Brightness;
    bool _9829 = buffer.u_Contrast > 0.0;
    float _10632;
    if (_9829)
    {
        _10632 = fma(_9827 - 0.5, fma(buffer.u_Contrast, 10.0, 1.0), 0.5);
    }
    else
    {
        _10632 = fma(_9827 - 0.5, buffer.u_Contrast + 1.0, 0.5);
    }
    float _9851 = _10634 + buffer.u_Brightness;
    float _10635;
    if (_9829)
    {
        _10635 = fma(_9851 - 0.5, fma(buffer.u_Contrast, 10.0, 1.0), 0.5);
    }
    else
    {
        _10635 = fma(_9851 - 0.5, buffer.u_Contrast + 1.0, 0.5);
    }
    float _1003 = fast::clamp(buffer.u_Scale.x, 0.00999999977648258209228515625, 1.0) * buffer.u_Range;
    float2 _10637;
    if (_943)
    {
        _10637 = float2(fma(_10632 - 0.5, _1003, in.uv0.x), fma(_10635 - 0.5, _1003, in.uv0.y));
    }
    else
    {
        float2 _10638;
        if (buffer.u_type < 0.1500000059604644775390625)
        {
            _10638 = float2(fma(_10632 - 0.5, _1003, in.uv0.x), in.uv0.y);
        }
        else
        {
            float2 _10639;
            if (buffer.u_type < 0.25)
            {
                _10639 = float2(in.uv0.x, fma(_10635 - 0.5, _1003, in.uv0.y));
            }
            else
            {
                _10639 = float2(0.0);
            }
            _10638 = _10639;
        }
        _10637 = _10638;
    }
    float2 _9887 = buffer.u_ScreenParams.xy / float2(fast::max(buffer.u_ScreenParams.x, buffer.u_ScreenParams.y));
    float _9898 = fast::max(_1109, _1079);
    float2 _10641;
    _10641 = _10637;
    for (int _10640 = 1; _10640 < 16; )
    {
        float2 _9909 = (_10641 - float2(0.5)) * _9887;
        float _9912 = length(_9909 * 2.0);
        _10641 = ((_9909 * pow(fma(_9912, _9912, 1.0), -pow((((buffer.u_fov * (_9898 * 0.5625)) * buffer.u_strength) * buffer.intensity) * 0.00593749992549419403076171875, 3.0))) / _9887) + float2(0.5);
        _10640++;
        continue;
    }
    out.gl_FragColor = pow(inputTex.sample(inputTexSmplr, _10641) * pow(0.75, -buffer.u_Intensity), float4(1.0));
    return out;
}

