#pragma clang diagnostic ignored "-Wmissing-prototypes"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

// Implementation of the GLSL mod() function, which is slightly different than Metal fmod()
template<typename Tx, typename Ty>
inline Tx mod(Tx x, Ty y)
{
    return x - y * floor(x / y);
}

struct buffer_t
{
    float chromatic_red;
    float chromatic_blue;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputTex [[texture(0)]], sampler inputTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float4 _59 = inputTex.sample(inputTexSmplr, abs(mod(float2(in.uv0.x + buffer.chromatic_red, in.uv0.y) - float2(1.0), float2(2.0)) - float2(1.0)));
    float4 _69 = inputTex.sample(inputTexSmplr, abs(mod(in.uv0 - float2(1.0), float2(2.0)) - float2(1.0)));
    float4 _82 = inputTex.sample(inputTexSmplr, abs(mod(float2(in.uv0.x - buffer.chromatic_blue, in.uv0.y) - float2(1.0), float2(2.0)) - float2(1.0)));
    out.gl_FragColor = float4(_59.x, _69.y, _82.z, fast::max((_59.w + _69.w) + _82.w, 1.0));
    return out;
}

