#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float u_Quality;
    float4 u_ScreenParams;
    float u_Amount;
    float2 u_Center;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputTex [[texture(0)]], sampler inputTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _83 = in.uv0 - buffer.u_Center;
    float _114 = 2.0 * fma((abs(buffer.u_Amount * 7.900000095367431640625) * length(_83)) * (((fast::clamp(buffer.u_Quality * 0.00999999977648258209228515625, 0.100000001490116119384765625, 1.0) * 2.599999904632568359375) * buffer.u_ScreenParams.x) * 0.001388888922519981861114501953125), 0.5, 1.0);
    float _119 = (buffer.u_Amount * 1.77750003337860107421875) / _114;
    float4 _203;
    float _204;
    _204 = 0.0;
    _203 = float4(0.0);
    float4 _157;
    float _160;
    for (float _202 = 0.0; _202 < 1000.0; _204 = _160, _203 = _157, _202 += 1.0)
    {
        if (_202 > _114)
        {
            break;
        }
        float _181 = fma(buffer.u_Amount, -0.888750016689300537109375, _202 * _119) * 0.01745329238474369049072265625;
        float _183 = sin(_181);
        float _185 = cos(_181);
        _157 = _203 + (inputTex.sample(inputTexSmplr, ((float2x2(float2(_185, _183), float2(-_183, _185)) * _83) + buffer.u_Center)) * 1.0);
        _160 = _204 + 1.0;
    }
    out.gl_FragColor = _203 / float4(_204);
    return out;
}

