precision highp float;
varying highp vec2 uv0;
uniform sampler2D inputTex;
uniform vec2 u_Center;
uniform vec4 u_ScreenParams;
uniform float u_Amount;
uniform float u_Quality;
#define PI 3.1415926
vec2 rotate(vec2 uv, vec2 center, float angle)
{
    float theta = angle * PI / 180.0;
    float sint = sin(theta), cost = cos(theta);
    uv -= center;
    uv = mat2(cost, sint, -sint, cost) * uv;
    return uv + center;

}
void main()
{
    const int SAMPLES = 32;
    float quality = clamp(u_Quality * 0.01, 0.1, 1.0) * 2.6 * u_ScreenParams.x / 720.0;
    float amount = u_Amount * 7.9;
    vec2 uv = uv0;
    float x = length(uv - u_Center);
    float weight = 0.0;
    vec4 res = texture2D(inputTex, uv) * weight;
    float sumWeight = weight;
    float s = abs(amount) * x * quality * 0.5 + 1.0;
    float angle = 0.225;
    float a = 2.*s;
    angle = angle * (amount) / (a);
    for (float i = 0.0; i < 1000.; i += 1.0)
    {
        if(i>a)break;
        weight = 1.0;
        vec2 tmpUV = rotate(uv, u_Center, -(amount) * 0.225 * 0.5 + i * angle);
        res += texture2D(inputTex, tmpUV) * weight;
        sumWeight += weight;
    }

    gl_FragColor = vec4(res / sumWeight);
}