#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float blend_alpha;
    float attenuation;
    float grabing;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> curTex [[texture(0)]], texture2d<float> lastTex [[texture(1)]], sampler curTexSmplr [[sampler(0)]], sampler lastTexSmplr [[sampler(1)]])
{
    main0_out out = {};
    float4 _72 = curTex.sample(curTexSmplr, in.uv0);
    float4 _77 = lastTex.sample(lastTexSmplr, in.uv0);
    out.gl_FragColor = select(mix(_77, float4(mix(_72.xyz, float3(fma(_72.x - 1.0, 1.0 - _77.x, 1.0), fma(_72.y - 1.0, 1.0 - _77.y, 1.0), fma(_72.z - 1.0, 1.0 - _77.z, 1.0)), float3(buffer.blend_alpha * 0.800000011920928955078125)), 1.0), float4(buffer.attenuation)), _72, bool4(buffer.grabing < 0.5));
    return out;
}

