precision highp float;
varying highp vec2 uv0;
uniform sampler2D curTex;
uniform sampler2D lastTex;

uniform float attenuation;
uniform vec4 u_ScreenParams;

uniform float grabing;

uniform float blend_alpha;

// screen
float blendScreen(float base, float blend) {
    return 1.0-((1.0-base)*(1.0-blend));
}

vec3 blendScreen(vec3 base, vec3 blend) {
    return vec3(blendScreen(base.r,blend.r),blendScreen(base.g,blend.g),blendScreen(base.b,blend.b));
}

void main()
{
    vec2 uv1 = uv0;
    vec4 curcol = texture2D(curTex, uv1);
    vec4 lastcol = texture2D(lastTex, uv1);

    vec3 blendCol = blendScreen(curcol.rgb, lastcol.rgb);
    blendCol = mix(curcol.rgb, blendCol.rgb, blend_alpha * 0.8);

    vec4 res = mix(lastcol, vec4(blendCol, 1.), attenuation);
    if(grabing < 0.5) res = curcol;
    // res = curcol;
    gl_FragColor = res;
}