#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float2 pos;
    float scale;
    float rot;
    float4 u_ScreenParams;
    float2 u_Center;
    float u_Radius;
    float u_Convergence;
    float u_Intensity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputTex [[texture(0)]], sampler inputTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _267 = ((in.uv0 + buffer.pos) - float2(0.5)) / float2(buffer.scale);
    float _358 = buffer.rot * (-0.01745329238474369049072265625);
    float _366 = buffer.u_ScreenParams.x / buffer.u_ScreenParams.y;
    float2 _551 = _267;
    _551.x = _267.x * _366;
    float _372 = cos(_358);
    float _374 = sin(_358);
    float2 _384 = _551 * float2x2(float2(_372, _374), float2(-_374, _372));
    float2 _556 = _384;
    _556.x = _384.x / _366;
    float2 _411 = (_556 + float2(0.5)) - buffer.u_Center;
    float _416 = buffer.u_ScreenParams.y / buffer.u_ScreenParams.x;
    float2 _561 = _411;
    _561.x = _411.x / _416;
    bool _425 = buffer.u_ScreenParams.y > buffer.u_ScreenParams.x;
    float2 _584;
    if (_425)
    {
        _584 = _561 * fast::max(1.0, (_416 + 1.0) * 0.550000011920928955078125);
    }
    else
    {
        _584 = _561;
    }
    float _447 = length(_584);
    float _454 = _447 * fma((buffer.u_Convergence * (-104.99999237060546875)) / pow(buffer.u_Radius, 2.0), pow(_447, 2.0), 1.0);
    float _459 = precise::atan2(_584.x, _584.y);
    float2 _472 = float2(sin(_459) * _454, cos(_459) * _454);
    float2 _585;
    if (_425)
    {
        _585 = _472 / float2(fast::max(1.0, (_416 + 1.0) * 0.550000011920928955078125));
    }
    else
    {
        _585 = _472;
    }
    float2 _576 = _585;
    _576.x = _585.x * _416;
    float2 _502 = _576 + buffer.u_Center;
    float _505 = _502.x;
    float _506 = _502.y;
    float2 _302 = float3(_505, _506, _447).xy;
    float2 _514 = step(float2(0.0), _302) * step(_302, float2(1.0));
    out.gl_FragColor = pow(((inputTex.sample(inputTexSmplr, _302) * ((_514.x * _514.y) * step(_447, buffer.u_Radius * 0.01019999943673610687255859375))) * (((step(0.0, _505) * step(_505, 1.0)) * step(0.0, _506)) * step(_506, 1.0))) * pow(0.75, -buffer.u_Intensity), float4(1.0));
    return out;
}

