#pragma clang diagnostic ignored "-Wmissing-prototypes"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

// Implementation of the GLSL mod() function, which is slightly different than Metal fmod()
template<typename Tx, typename Ty>
inline Tx mod(Tx x, Ty y)
{
    return x - y * floor(x / y);
}

struct buffer_t
{
    float scale;
    float chromatic_red;
    float chromatic_blue;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputTex [[texture(0)]], sampler inputTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _38 = (in.uv0 - float2(0.5)) / float2(buffer.scale);
    float2 _41 = _38 + float2(0.5);
    float _54 = _41.x;
    float _60 = _41.y;
    float4 _64 = inputTex.sample(inputTexSmplr, abs(mod(float2(_54 + buffer.chromatic_red, _60) - float2(1.0), float2(2.0)) - float2(1.0)));
    float4 _74 = inputTex.sample(inputTexSmplr, abs(mod(_38 + float2(-0.5), float2(2.0)) - float2(1.0)));
    float4 _87 = inputTex.sample(inputTexSmplr, abs(mod(float2(_54 - buffer.chromatic_blue, _60) - float2(1.0), float2(2.0)) - float2(1.0)));
    out.gl_FragColor = float4(_64.x, _74.y, _87.z, fast::max((_64.w + _74.w) + _87.w, 1.0));
    return out;
}

