#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float4 u_ScreenParams;
    float u_fov;
    float u_strength;
    float intensity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputTex [[texture(0)]], sampler inputTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _139 = buffer.u_ScreenParams.xy / float2(fast::max(buffer.u_ScreenParams.x, buffer.u_ScreenParams.y));
    float _150 = fast::max(buffer.u_ScreenParams.x / buffer.u_ScreenParams.y, buffer.u_ScreenParams.y / buffer.u_ScreenParams.x);
    float2 _195;
    _195 = in.uv0;
    for (int _194 = 1; _194 < 16; )
    {
        float2 _161 = (_195 - float2(0.5)) * _139;
        float _164 = length(_161 * 2.0);
        _195 = ((_161 * pow(fma(_164, _164, 1.0), -pow((((buffer.u_fov * (_150 * 0.5625)) * buffer.u_strength) * buffer.intensity) * 0.00593749992549419403076171875, 3.0))) / _139) + float2(0.5);
        _194++;
        continue;
    }
    out.gl_FragColor = inputTex.sample(inputTexSmplr, _195);
    return out;
}

