precision highp float;

varying vec2 uv0;

uniform sampler2D inputTex;

uniform float u_fov;
uniform float u_strength;
uniform float intensity;

uniform vec4 u_ScreenParams;

void fov_transform(inout vec2 io_uv){
    vec2 uv = io_uv;
    vec2 ratio = (u_ScreenParams.xy / max(u_ScreenParams.x, u_ScreenParams.y));
    float scale = max(u_ScreenParams.x / u_ScreenParams.y, u_ScreenParams.y / u_ScreenParams.x);
    for (int i = 1; i < 16; ++i)
    {
        uv -= 0.5;
        uv *= ratio;
        float d = length(uv * 2.0);
        uv = uv * pow((d*d) + 1.0, -pow(u_fov * (scale / (16. / 9.)) * u_strength * intensity * 0.0059375, 3.0));
        uv /= ratio;

        uv += 0.5;
    }

    io_uv = uv;
}

void main()
{

    vec2 uv1 = uv0;
    fov_transform(uv1);
    vec4 res = texture2D(inputTex, uv1);
    gl_FragColor = res;
}
