#pragma clang diagnostic ignored "-Wmissing-prototypes"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

// Implementation of the GLSL mod() function, which is slightly different than Metal fmod()
template<typename Tx, typename Ty>
inline Tx mod(Tx x, Ty y)
{
    return x - y * floor(x / y);
}

struct buffer_t
{
    float2 pos;
    float4 u_ScreenParams;
    float white_alpha;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputTex [[texture(0)]], sampler inputTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _164 = ((in.uv0 - float2(0.5)) + float2(-buffer.pos.x, buffer.pos.y)) * float2(0.89999997615814208984375);
    float _177 = buffer.u_ScreenParams.x / buffer.u_ScreenParams.y;
    float2 _220 = _164;
    _220.x = _164.x * _177;
    float2 _191 = float2x2(float2(1.0, 0.0), float2(-0.0, 1.0)) * _220;
    float2 _225 = _191;
    _225.x = _191.x / _177;
    out.gl_FragColor = fast::clamp(inputTex.sample(inputTexSmplr, abs(mod(_225 + float2(1.5), float2(2.0)) - float2(1.0))) + (float4(1.0) * buffer.white_alpha), float4(0.0), float4(1.0));
    return out;
}

