precision highp float;
varying highp vec2 uv0;
uniform sampler2D inputTex;

uniform vec4 u_ScreenParams;

uniform float white_alpha;

uniform vec2 pos;

const float PI = 3.1415926;

float cut(vec2 u) {return step(0.,u.x)*step(u.x,1.)*step(0.,u.y)*step(u.y,1.);}
vec2 mirror(vec2 x) { return abs(mod(x+1., 2.)-1.); }

void TRS(inout vec2 io_u, vec2 _t, float _r, vec2 _s, vec2 _screensize){
    io_u -= 0.5;
    io_u += vec2(-_t.x, _t.y);
    io_u /= _s;

    // rotate
    const float TRS_PI = 3.1415926;
    float r = -_r/180.*TRS_PI;
    float s = sin(r);
    float c = cos(r);

    io_u.x *= _screensize.x/_screensize.y;
    io_u = mat2(c, -s, s,  c) * io_u;
    io_u.x /= _screensize.x/_screensize.y;

    io_u += 0.5;
}

void main()
{
    vec2 uv1 = uv0;
    TRS(uv1, pos, 0., vec2(1)/0.9, u_ScreenParams.xy);
    vec4 inputCol = texture2D(inputTex, mirror(uv1));

    vec4 white = vec4(1);
    vec4 res = inputCol + white*white_alpha;
    res = clamp(res, vec4(0), vec4(1));
    
    gl_FragColor = res;
}