#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float2 u_TextRect;
    float u_Offset;
    float u_Strength;
    float u_Strength1;
    float u_TrailAlpha;
    float u_Alpha;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> _MainTex [[texture(0)]], sampler _MainTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float4 resColor = _MainTex.sample(_MainTexSmplr, in.uv0);
    float2 dir = float2(0.0, 1.0) / buffer.u_TextRect;
    if (buffer.u_Offset < 0.001000000047497451305389404296875)
    {
        dir = -dir;
    }
    float sumWeight = 1.0;
    for (int i = 1; i <= 24; i++)
    {
        float weight = pow(float(24 - i) / 24.0, 0.300000011920928955078125);
        float2 uv = in.uv0 - ((dir * float((i * 2) - 1)) * buffer.u_Strength);
        resColor += (_MainTex.sample(_MainTexSmplr, uv) * weight);
        uv = in.uv0 - ((dir * float(i * 2)) * buffer.u_Strength);
        resColor += (_MainTex.sample(_MainTexSmplr, uv) * weight);
        sumWeight += (2.0 * weight);
    }
    resColor /= float4(sumWeight);
    float2 uv1 = in.uv0 - float2(0.0, buffer.u_Offset);
    float4 resColor1 = _MainTex.sample(_MainTexSmplr, uv1);
    sumWeight = 1.0;
    for (int i_1 = 1; i_1 <= 24; i_1++)
    {
        float weight_1 = pow(float(24 - i_1) / 24.0, 0.100000001490116119384765625);
        float2 uv_1 = uv1 - ((dir * float((i_1 * 2) - 1)) * buffer.u_Strength1);
        resColor1 += (_MainTex.sample(_MainTexSmplr, uv_1) * weight_1);
        uv_1 = uv1 - ((dir * float(i_1 * 2)) * buffer.u_Strength1);
        resColor1 += (_MainTex.sample(_MainTexSmplr, uv_1) * weight_1);
        sumWeight += (2.0 * weight_1);
    }
    resColor1 /= float4(sumWeight);
    out.gl_FragColor = ((resColor + (((resColor1 * (1.0 - resColor.w)) * 1.0) * buffer.u_TrailAlpha)) * buffer.u_Alpha) * smoothstep(0.0, 0.100000001490116119384765625, in.uv0.y);
    return out;
}

