#pragma clang diagnostic ignored "-Wmissing-prototypes"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float4 _Scale2_Smoothing_AnimAlpha;
    float4 _Color1;
    float4 u_Time;
    float t;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float4 chcolor [[user(chcolor)]];
    float4 dis_grad [[user(dis_grad)]];
    float4 tex_ktv [[user(tex_ktv)]];
    float2 ktv_angle [[user(ktv_angle)]];
    float smoothing_fwidth [[user(smoothing_fwidth)]];
    float4 WH [[user(WH)]];
};

static inline __attribute__((always_inline))
float3 random3(thread const float3& c)
{
    float j = 4096.0 * sin(dot(c, float3(17.0, 59.40000152587890625, 15.0)));
    float3 r;
    r.z = fract(512.0 * j);
    j *= 0.125;
    r.x = fract(512.0 * j);
    j *= 0.125;
    r.y = fract(512.0 * j);
    return r - float3(0.5);
}

static inline __attribute__((always_inline))
float simplex3d(thread const float3& p)
{
    float3 s = floor(p + float3(dot(p, float3(0.333333313465118408203125))));
    float3 x = (p - s) + float3(dot(s, float3(0.16666670143604278564453125)));
    float3 e = step(float3(0.0), x - x.yzx);
    float3 i1 = e * (float3(1.0) - e.zxy);
    float3 i2 = float3(1.0) - (e.zxy * (float3(1.0) - e));
    float3 x1 = (x - i1) + float3(0.16666670143604278564453125);
    float3 x2 = (x - i2) + float3(0.3333334028720855712890625);
    float3 x3 = (x - float3(1.0)) + float3(0.50000011920928955078125);
    float4 w;
    w.x = dot(x, x);
    w.y = dot(x1, x1);
    w.z = dot(x2, x2);
    w.w = dot(x3, x3);
    w = fast::max(float4(0.60000002384185791015625) - w, float4(0.0));
    float3 param = s;
    float4 d;
    d.x = dot(random3(param), x);
    float3 param_1 = s + i1;
    d.y = dot(random3(param_1), x1);
    float3 param_2 = s + i2;
    d.z = dot(random3(param_2), x2);
    float3 param_3 = s + float3(1.0);
    d.w = dot(random3(param_3), x3);
    w *= w;
    w *= w;
    d *= w;
    return dot(d, float4(52.0));
}

static inline __attribute__((always_inline))
float _noise(thread const float3& m)
{
    float3 param = m;
    float3 param_1 = m * 2.0;
    float3 param_2 = m * 4.0;
    float3 param_3 = m * 8.0;
    return (((0.533333301544189453125 * simplex3d(param)) + (0.266666710376739501953125 * simplex3d(param_1))) + (0.1333332955837249755859375 * simplex3d(param_2))) + (0.066666699945926666259765625 * simplex3d(param_3));
}

static inline __attribute__((always_inline))
float unpack16(thread const float2& color)
{
    return dot(color, float2(0.00390625, 1.0));
}

static inline __attribute__((always_inline))
float linearstep(thread const float& edge0, thread const float& edge1, thread const float& x)
{
    float t = (x - edge0) / (edge1 - edge0);
    return fast::clamp(t, 0.0, 1.0);
}

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> _MainTex [[texture(0)]], sampler _MainTexSmplr [[sampler(0)]])
{
    main0_out out = {};
    float scale2_Smoothing_AnimAlpha_x = buffer._Scale2_Smoothing_AnimAlpha.x;
    float scale2_Smoothing_AnimAlpha_y = buffer._Scale2_Smoothing_AnimAlpha.y;
    float smoothing = buffer._Scale2_Smoothing_AnimAlpha.z + in.smoothing_fwidth;
    float4 cc = buffer._Color1;
    float x = 0.0;
    float2 uvN = (in.dis_grad.zw * 4.0) - float2(2.0);
    float3 param = float3(((uvN * 2.0) + float2(buffer.u_Time.x * 8.0, 0.0)) + ((in.WH.xy - in.WH.zw) * 100.0), buffer.u_Time.y * 4.0) + float3(12.0);
    float offx = _noise(param);
    float3 param_1 = float3((((float2(1.0) - uvN.yx) * 2.0) + float2(0.0, buffer.u_Time.x * 8.0)) - ((in.WH.xy - in.WH.zw) * 100.0), buffer.u_Time.y * 4.0) - float3(12.0);
    float offy = _noise(param_1);
    float2 uvi = in.dis_grad.xy + ((float2(offx, offy) * 0.0024999999441206455230712890625) / float2(in.WH.xy - in.WH.zw));
    float4 dis_tex = _MainTex.sample(_MainTexSmplr, uvi);
    float2 param_2 = dis_tex.zw;
    float distance_smooth = unpack16(param_2);
    float2 param_3 = dis_tex.xy;
    float distance_clear = unpack16(param_3);
    float ratio = smoothstep(0.0, 0.100000001490116119384765625, buffer._Scale2_Smoothing_AnimAlpha.z);
    float _distance = (distance_clear * (1.0 - ratio)) + (distance_smooth * ratio);
    float alpha = 1.0;
    float l = fast::clamp((1.0 - scale2_Smoothing_AnimAlpha_x) - smoothing, 0.0, 1.0);
    float param_4 = l;
    float param_5 = (1.0 - scale2_Smoothing_AnimAlpha_x) + smoothing;
    float param_6 = _distance;
    alpha *= (1.0 - linearstep(param_4, param_5, param_6));
    l = fast::clamp((1.0 - scale2_Smoothing_AnimAlpha_y) - smoothing, 0.0, 1.0);
    float param_7 = l;
    float param_8 = (1.0 - scale2_Smoothing_AnimAlpha_y) + smoothing;
    float param_9 = _distance;
    alpha *= linearstep(param_7, param_8, param_9);
    dis_tex = _MainTex.sample(_MainTexSmplr, in.dis_grad.xy);
    float2 param_10 = dis_tex.zw;
    distance_smooth = unpack16(param_10);
    float2 param_11 = dis_tex.xy;
    distance_clear = unpack16(param_11);
    ratio = smoothstep(0.0, 0.100000001490116119384765625, buffer._Scale2_Smoothing_AnimAlpha.z);
    _distance = (distance_clear * (1.0 - ratio)) + (distance_smooth * ratio);
    float alpha1 = 1.0;
    l = fast::clamp((1.0 - scale2_Smoothing_AnimAlpha_x) - smoothing, 0.0, 1.0);
    float param_12 = l;
    float param_13 = (1.0 - scale2_Smoothing_AnimAlpha_x) + smoothing;
    float param_14 = _distance;
    alpha1 *= (1.0 - linearstep(param_12, param_13, param_14));
    l = fast::clamp((1.0 - scale2_Smoothing_AnimAlpha_y) - smoothing, 0.0, 1.0);
    float param_15 = l;
    float param_16 = (1.0 - scale2_Smoothing_AnimAlpha_y) + smoothing;
    float param_17 = _distance;
    alpha1 *= linearstep(param_15, param_16, param_17);
    alpha = alpha1 + (alpha * (1.0 - alpha1));
    cc *= in.chcolor;
    float ktvDist = (in.dis_grad.z * in.ktv_angle.x) + (in.dis_grad.w * in.ktv_angle.y);
    float alpha_less = step(in.tex_ktv.w, 0.0);
    float alpha_greater = 1.0 - alpha_less;
    float ktv_right = step(ktvDist, in.tex_ktv.z);
    float ktv_alpha = ((1.0 - ktv_right) * alpha_less) + (ktv_right * alpha_greater);
    alpha *= ktv_alpha;
    out.gl_FragColor = float4((cc.xyz * alpha) * cc.w, cc.w * alpha);
    out.gl_FragColor = float4(cc * alpha);
    float2 uvdis = (in.dis_grad.zw * 2.0) - float2(1.0);
    float2 mm = in.WH.xy - in.WH.zw;
    float3 p3 = float3(uvdis, (buffer.t * 2.400000095367431640625) * (mm.x + mm.y));
    float3 param_18 = float3((p3 * 4.0) + float3(12.0));
    float intensity = _noise(param_18);
    float y = abs(((intensity * 0.20000000298023223876953125) + _distance) - 0.4699999988079071044921875);
    float g = pow(y, 0.180000007152557373046875);
    float3 col = float3(0.5, 1.7799999713897705078125, 0.89999997615814208984375);
    float m = 1.7799999713897705078125 - (g * 1.7799999713897705078125);
    m *= m;
    m *= m;
    m = alpha1 + (m * (1.0 - alpha1));
    out.gl_FragColor = cc * m;
    return out;
}

