#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float4 u_ScreenParams;
    float sharpness;
    float white_gam;
    float black_gam;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], sampler inputImageTextureSmplr [[sampler(0)]])
{
    main0_out out = {};
    float2 _24 = float2(1.0 / buffer.u_ScreenParams.x, 1.0 / buffer.u_ScreenParams.y);
    float4 _35 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0);
    float4 _62 = inputImageTexture.sample(inputImageTextureSmplr, fma(_24, float2(-1.0), in.uv0));
    float4 _72 = inputImageTexture.sample(inputImageTextureSmplr, fma(_24, float2(0.0, -1.0), in.uv0));
    float4 _82 = inputImageTexture.sample(inputImageTextureSmplr, fma(_24, float2(1.0, -1.0), in.uv0));
    float4 _92 = inputImageTexture.sample(inputImageTextureSmplr, fma(_24, float2(-1.0, 0.0), in.uv0));
    float3 _104 = float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _35.xyz;
    float4 _112 = inputImageTexture.sample(inputImageTextureSmplr, fma(_24, float2(1.0, 0.0), in.uv0));
    float4 _122 = inputImageTexture.sample(inputImageTextureSmplr, fma(_24, float2(-1.0, 1.0), in.uv0));
    float4 _132 = inputImageTexture.sample(inputImageTextureSmplr, fma(_24, float2(0.0, 1.0), in.uv0));
    float4 _142 = inputImageTexture.sample(inputImageTextureSmplr, (in.uv0 + _24));
    float _149 = _104.x;
    float _156 = fma(2.0, _149, -(float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _92.xyz).x) - (float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _112.xyz).x;
    float _166 = fma(2.0, _149, -(float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _72.xyz).x) - (float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _132.xyz).x;
    float _176 = fma(2.0, _149, -(float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _82.xyz).x) - (float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _122.xyz).x;
    float _186 = fma(2.0, _149, -(float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _62.xyz).x) - (float3x3(float3(0.2989999949932098388671875, -0.16873599588871002197265625, 0.5), float3(0.58700001239776611328125, -0.3312639892101287841796875, -0.418687999248504638671875), float3(0.114000000059604644775390625, 0.5, -0.081312000751495361328125)) * _142.xyz).x;
    float _189 = abs(_156);
    float _191 = abs(_166);
    float _194 = abs(_176);
    float _197 = abs(_186);
    float _198 = fast::max(fast::max(fast::max(_189, _191), _194), _197);
    float3 _369;
    if (abs(_189 - _198) <= 0.00999999977648258209228515625)
    {
        float3 _370;
        if (_156 > 0.0)
        {
            _370 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * (_104 + float3((buffer.sharpness * _156) * buffer.white_gam, 0.0, 0.0));
        }
        else
        {
            _370 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * (_104 + float3((buffer.sharpness * _156) * buffer.black_gam, 0.0, 0.0));
        }
        _369 = _370;
    }
    else
    {
        float3 _371;
        if (abs(_191 - _198) <= 0.00999999977648258209228515625)
        {
            float3 _372;
            if (_166 > 0.0)
            {
                _372 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * (_104 + float3((buffer.sharpness * _166) * buffer.white_gam, 0.0, 0.0));
            }
            else
            {
                _372 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * (_104 + float3((buffer.sharpness * _166) * buffer.black_gam, 0.0, 0.0));
            }
            _371 = _372;
        }
        else
        {
            float3 _373;
            if (abs(_194 - _198) <= 0.00999999977648258209228515625)
            {
                float3 _374;
                if (_176 > 0.0)
                {
                    _374 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * (_104 + float3((buffer.sharpness * _176) * buffer.white_gam, 0.0, 0.0));
                }
                else
                {
                    _374 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * (_104 + float3((buffer.sharpness * _176) * buffer.black_gam, 0.0, 0.0));
                }
                _373 = _374;
            }
            else
            {
                float3 _375;
                if (abs(_197 - _198) <= 0.00999999977648258209228515625)
                {
                    float3 _376;
                    if (_186 > 0.0)
                    {
                        _376 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * (_104 + float3((buffer.sharpness * _186) * buffer.white_gam, 0.0, 0.0));
                    }
                    else
                    {
                        _376 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * (_104 + float3((buffer.sharpness * _186) * buffer.black_gam, 0.0, 0.0));
                    }
                    _375 = _376;
                }
                else
                {
                    _375 = float3x3(float3(1.0), float3(0.0, -0.3441359996795654296875, 1.77199995517730712890625), float3(1.401999950408935546875, -0.71413600444793701171875, 0.0)) * _104;
                }
                _373 = _375;
            }
            _371 = _373;
        }
        _369 = _371;
    }
    out.gl_FragColor = float4(fast::clamp(_369, float3(0.0), float3(1.0)), _35.w);
    return out;
}

