#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float OffsetR;
    float OffsetG;
    float OffsetB;
    float LiftY;
    float GammaY;
    float GainY;
    float LiftR;
    float GammaR;
    float GainR;
    float LiftG;
    float GammaG;
    float GainG;
    float LiftB;
    float GammaB;
    float GainB;
    float LumaMix;
    float OffsetS;
    float LiftS;
    float GammaS;
    float GainS;
    float Intensity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], sampler inputImageTextureSmplr [[sampler(0)]])
{
    main0_out out = {};
    float4 _358 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0);
    float4 _371 = _358 + float4(buffer.OffsetR, buffer.OffsetG, buffer.OffsetB, 0.0);
    float _590 = fma(0.072200000286102294921875, buffer.OffsetB, fma(0.2125999927520751953125, buffer.OffsetR, 0.715200006961822509765625 * buffer.OffsetG));
    float _594 = _371.x;
    float _597 = _371.y;
    float _601 = _371.z;
    float _610 = fast::min(buffer.LiftY, 0.4995000064373016357421875);
    float _618 = 1.0 / fast::max(buffer.GainY, 0.001000000047497451305389404296875);
    float _622 = fast::min(_610 / (_610 - 0.5), _618 - 0.0005000000237487256526947021484375);
    float _633 = (((fma(0.072200000286102294921875, _601, fma(0.2125999927520751953125, _594, 0.715200006961822509765625 * _597)) - _590) - _622) / (_618 - _622)) + _590;
    float _1332;
    if (_633 >= 0.0)
    {
        _1332 = pow(_633, buffer.GammaY);
    }
    else
    {
        _1332 = -pow(-_633, buffer.GammaY);
    }
    float _654 = fast::min(buffer.LiftR, 0.4995000064373016357421875);
    float _662 = 1.0 / fast::max(buffer.GainR, 0.001000000047497451305389404296875);
    float _666 = fast::min(_654 / (_654 - 0.5), _662 - 0.0005000000237487256526947021484375);
    float _677 = (((_594 - buffer.OffsetR) - _666) / (_662 - _666)) + buffer.OffsetR;
    float _1334;
    if (_677 >= 0.0)
    {
        _1334 = pow(_677, buffer.GammaR);
    }
    else
    {
        _1334 = -pow(-_677, buffer.GammaR);
    }
    float4 _1279 = _371;
    _1279.x = _1334;
    float _698 = fast::min(buffer.LiftG, 0.4995000064373016357421875);
    float _706 = 1.0 / fast::max(buffer.GainG, 0.001000000047497451305389404296875);
    float _710 = fast::min(_698 / (_698 - 0.5), _706 - 0.0005000000237487256526947021484375);
    float _721 = (((_597 - buffer.OffsetG) - _710) / (_706 - _710)) + buffer.OffsetG;
    float _1336;
    if (_721 >= 0.0)
    {
        _1336 = pow(_721, buffer.GammaG);
    }
    else
    {
        _1336 = -pow(-_721, buffer.GammaG);
    }
    float4 _1283 = _1279;
    _1283.y = _1336;
    float _742 = fast::min(buffer.LiftB, 0.4995000064373016357421875);
    float _750 = 1.0 / fast::max(buffer.GainB, 0.001000000047497451305389404296875);
    float _754 = fast::min(_742 / (_742 - 0.5), _750 - 0.0005000000237487256526947021484375);
    float _765 = (((_601 - buffer.OffsetB) - _754) / (_750 - _754)) + buffer.OffsetB;
    float _1338;
    if (_765 >= 0.0)
    {
        _1338 = pow(_765, buffer.GammaB);
    }
    else
    {
        _1338 = -pow(-_765, buffer.GammaB);
    }
    float4 _1287 = _1283;
    _1287.z = _1338;
    float3 _461 = _1287.xyz + float3((_1332 - fma(0.072200000286102294921875, _1338, fma(0.2125999927520751953125, _1334, 0.715200006961822509765625 * _1336))) * buffer.LumaMix);
    float4 _1292 = _1287;
    _1292.x = _461.x;
    float4 _1294 = _1292;
    _1294.y = _461.y;
    float4 _1296 = _1294;
    _1296.z = _461.z;
    float4 _471 = fast::clamp(_1296, float4(0.0), float4(1.0));
    float _796 = _471.x;
    float _799 = _471.y;
    float _803 = _471.z;
    float _805 = fma(0.072200000286102294921875, _803, fma(0.2125999927520751953125, _796, 0.715200006961822509765625 * _799));
    float _827 = fast::max(_796, fast::max(_799, _803));
    float _832 = fast::min(_796, fast::min(_799, _803));
    float _835 = _827 - _832;
    float _838 = _827 + _832;
    float _839 = _838 * 0.5;
    float _1343;
    float _1347;
    if (_835 < 9.9999997473787516355514526367188e-06)
    {
        _1347 = 0.0;
        _1343 = 0.0;
    }
    else
    {
        float _1350;
        if (_839 <= 0.5)
        {
            _1350 = _835 / _838;
        }
        else
        {
            _1350 = _835 / (2.0 - _838);
        }
        float _1344;
        if ((_827 - _796) < 9.9999997473787516355514526367188e-06)
        {
            float _1345;
            if (_799 >= _803)
            {
                _1345 = (60.0 * (_799 - _803)) / _835;
            }
            else
            {
                _1345 = ((60.0 * (_799 - _803)) / _835) + 360.0;
            }
            _1344 = _1345;
        }
        else
        {
            float _1346;
            if ((_827 - _799) < 9.9999997473787516355514526367188e-06)
            {
                _1346 = ((60.0 * (_803 - _796)) / _835) + 120.0;
            }
            else
            {
                _1346 = ((60.0 * (_796 - _799)) / _835) + 240.0;
            }
            _1344 = _1346;
        }
        _1347 = _1350;
        _1343 = _1344;
    }
    float _918 = fast::min(buffer.LiftS, 0.4995000064373016357421875);
    float _930 = fast::min(_918 / (_918 - 0.5), 0.999499976634979248046875);
    float _939 = (_805 - _930) / (1.0 - _930);
    float _1352;
    if (_939 >= 0.0)
    {
        _1352 = pow(_939, 1.0);
    }
    else
    {
        _1352 = -pow(-_939, 1.0);
    }
    float _1354;
    if (_805 >= 0.0)
    {
        _1354 = pow(_805, buffer.GammaS);
    }
    else
    {
        _1354 = -pow(-_805, buffer.GammaS);
    }
    float _1014 = 1.0 / fast::max(buffer.GainS, 0.001000000047497451305389404296875);
    float _1018 = fast::min(-0.0, _1014 - 0.0005000000237487256526947021484375);
    float _1027 = (_805 - _1018) / (_1014 - _1018);
    float _1356;
    if (_1027 >= 0.0)
    {
        _1356 = pow(_1027, 1.0);
    }
    else
    {
        _1356 = -pow(-_1027, 1.0);
    }
    float _525 = fast::clamp(((buffer.OffsetS + (_1352 - _805)) + (_1354 - _805)) + (_1356 - _805), -1.0, 2.0);
    float _534 = fast::clamp(_1347 * (1.0 + _525), 0.0, 1.0);
    float4 _1402;
    if (abs(_525) > 9.9999997473787516355514526367188e-06)
    {
        float _1064 = _1343 * 0.00277777784503996372222900390625;
        float _1371;
        float _1378;
        float _1382;
        if (_534 == 0.0)
        {
            _1382 = _839;
            _1378 = _839;
            _1371 = _839;
        }
        else
        {
            float _1361;
            if (_839 < 0.5)
            {
                _1361 = _839 * (1.0 + _534);
            }
            else
            {
                _1361 = fma(_838 * (-0.5), _534, fma(_838, 0.5, _534));
            }
            float _1100 = _838 - _1361;
            float _1102 = fma(_1343, 0.00277777784503996372222900390625, 0.3333333432674407958984375);
            float _1364;
            do
            {
                float _1362;
                if (_1102 < 0.0)
                {
                    _1362 = _1102 + 1.0;
                }
                else
                {
                    _1362 = _1102;
                }
                float _1363;
                if (_1362 > 1.0)
                {
                    _1363 = _1362 - 1.0;
                }
                else
                {
                    _1363 = _1362;
                }
                if (_1363 < 0.16666667163372039794921875)
                {
                    _1364 = fma((_1361 - _1100) * 6.0, _1363, _1100);
                    break;
                }
                if (_1363 < 0.5)
                {
                    _1364 = _1361;
                    break;
                }
                if (_1363 < 0.666666686534881591796875)
                {
                    _1364 = fma((_1361 - _1100) * (0.666666686534881591796875 - _1363), 6.0, _1100);
                    break;
                }
                _1364 = _1100;
                break;
            } while(false);
            float _1367;
            do
            {
                float _1365;
                if (_1064 < 0.0)
                {
                    _1365 = fma(_1343, 0.00277777784503996372222900390625, 1.0);
                }
                else
                {
                    _1365 = _1064;
                }
                float _1366;
                if (_1365 > 1.0)
                {
                    _1366 = _1365 - 1.0;
                }
                else
                {
                    _1366 = _1365;
                }
                if (_1366 < 0.16666667163372039794921875)
                {
                    _1367 = fma((_1361 - _1100) * 6.0, _1366, _1100);
                    break;
                }
                if (_1366 < 0.5)
                {
                    _1367 = _1361;
                    break;
                }
                if (_1366 < 0.666666686534881591796875)
                {
                    _1367 = fma((_1361 - _1100) * (0.666666686534881591796875 - _1366), 6.0, _1100);
                    break;
                }
                _1367 = _1100;
                break;
            } while(false);
            float _1111 = fma(_1343, 0.00277777784503996372222900390625, -0.3333333432674407958984375);
            float _1370;
            do
            {
                float _1368;
                if (_1111 < 0.0)
                {
                    _1368 = _1111 + 1.0;
                }
                else
                {
                    _1368 = _1111;
                }
                float _1369;
                if (_1368 > 1.0)
                {
                    _1369 = _1368 - 1.0;
                }
                else
                {
                    _1369 = _1368;
                }
                if (_1369 < 0.16666667163372039794921875)
                {
                    _1370 = fma((_1361 - _1100) * 6.0, _1369, _1100);
                    break;
                }
                if (_1369 < 0.5)
                {
                    _1370 = _1361;
                    break;
                }
                if (_1369 < 0.666666686534881591796875)
                {
                    _1370 = fma((_1361 - _1100) * (0.666666686534881591796875 - _1369), 6.0, _1100);
                    break;
                }
                _1370 = _1100;
                break;
            } while(false);
            _1382 = _1370;
            _1378 = _1367;
            _1371 = _1364;
        }
        float4 _1321 = _471;
        _1321.x = _1371;
        float4 _1323 = _1321;
        _1323.y = _1378;
        float4 _1325 = _1323;
        _1325.z = _1382;
        _1402 = _1325;
    }
    else
    {
        _1402 = _471;
    }
    float3 _557 = mix(_358.xyz, _1402.xyz, float3(buffer.Intensity));
    float4 _1327 = _1402;
    _1327.x = _557.x;
    float4 _1329 = _1327;
    _1329.y = _557.y;
    float4 _1331 = _1329;
    _1331.z = _557.z;
    out.gl_FragColor = fast::clamp(_1331, float4(0.0), float4(1.0));
    return out;
}

