#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float Seed;
    float Intensity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], sampler inputImageTextureSmplr [[sampler(0)]])
{
    main0_out out = {};
    float4 _77 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0);
    float3 _130 = fract(float3(in.uv0 * 9331.990234375, buffer.Seed * 9331.990234375) * 0.103100001811981201171875) + float3(buffer.Seed);
    float3 _139 = _130 + float3(dot(_130, _130.yzx + float3(33.3300018310546875)));
    float3 _91 = _77.xyz + float3((fract((_139.x + _139.y) * _139.z) - 0.5) * buffer.Intensity);
    float4 _158 = _77;
    _158.x = _91.x;
    float4 _160 = _158;
    _160.y = _91.y;
    float4 _162 = _160;
    _162.z = _91.z;
    float3 _104 = fast::clamp(_162.xyz, float3(0.0), float3(1.0));
    float4 _164 = _162;
    _164.x = _104.x;
    float4 _166 = _164;
    _166.y = _104.y;
    float4 _168 = _166;
    _168.z = _104.z;
    out.gl_FragColor = _168;
    return out;
}

