#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float RngDown;
    float RngUp;
    float ShadowR;
    float MidtoneR;
    float HightlightsR;
    float OffsetR;
    float4 s2mR;
    float4 h2mR;
    float4 s2hR;
    float ShadowG;
    float MidtoneG;
    float HightlightsG;
    float OffsetG;
    float4 s2mG;
    float4 h2mG;
    float4 s2hG;
    float ShadowB;
    float MidtoneB;
    float HightlightsB;
    float OffsetB;
    float4 s2mB;
    float4 h2mB;
    float4 s2hB;
    float ShadowS;
    float MidtoneS;
    float HightlightsS;
    float4 s2mS;
    float4 h2mS;
    float4 s2hS;
    float OffsetS;
    float Intensity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], sampler inputImageTextureSmplr [[sampler(0)]])
{
    main0_out out = {};
    float4 _676 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0);
    float _685 = fast::min(buffer.RngDown, buffer.RngUp);
    float _902 = _676.x + buffer.OffsetR;
    float _906 = (_685 + buffer.RngUp) * 0.5;
    float _909 = buffer.RngUp - _685;
    bool _911 = _909 < 0.0500000007450580596923828125;
    bool _918;
    if (_911)
    {
        _918 = (_685 - 0.0500000007450580596923828125) < _902;
    }
    else
    {
        _918 = _911;
    }
    bool _925;
    if (_918)
    {
        _925 = _902 < (buffer.RngUp + 0.0500000007450580596923828125);
    }
    else
    {
        _925 = _918;
    }
    float _2840;
    if (_925)
    {
        float _1012 = _902 * _902;
        _2840 = fma(buffer.s2hR.w, _1012 * _902, fma(buffer.s2hR.z, _1012, fma(buffer.s2hR.y, _902, buffer.s2hR.x)));
    }
    else
    {
        float _933 = _685 - 0.0500000007450580596923828125;
        float _2841;
        if (_902 <= _933)
        {
            float _2838;
            if (buffer.ShadowR > 0.0)
            {
                _2838 = fma(_902, 1.0 - buffer.ShadowR, _685 * buffer.ShadowR);
            }
            else
            {
                float _1055 = (_685 - buffer.ShadowR) / fast::max(_685, 9.9999999747524270787835121154785e-07);
                float _2839;
                if (_1055 <= 9.0)
                {
                    _2839 = fma(_902, _1055, buffer.ShadowR);
                }
                else
                {
                    _2839 = fma(_902, 9.0, (-8.0) * _685);
                }
                _2838 = _2839;
            }
            _2841 = _2838;
        }
        else
        {
            bool _944 = _933 < _902;
            bool _953;
            if (_944)
            {
                _953 = _902 < fast::min(_685 + 0.0500000007450580596923828125, _906);
            }
            else
            {
                _953 = _944;
            }
            float _2842;
            if (_953)
            {
                float _1080 = _902 * _902;
                _2842 = fma(buffer.s2mR.w, _1080 * _902, fma(buffer.s2mR.z, _1080, fma(buffer.s2mR.y, _902, buffer.s2mR.x)));
            }
            else
            {
                bool _962 = (_685 + 0.0500000007450580596923828125) <= _902;
                bool _969;
                if (_962)
                {
                    _969 = _902 <= (buffer.RngUp - 0.0500000007450580596923828125);
                }
                else
                {
                    _969 = _962;
                }
                float _2843;
                if (_969)
                {
                    float _1145 = buffer.MidtoneR * buffer.MidtoneR;
                    float _1148 = _1145 * buffer.MidtoneR;
                    float _1151 = _1148 * buffer.MidtoneR;
                    float _1154 = _1151 * buffer.MidtoneR;
                    float _1157 = _1154 * buffer.MidtoneR;
                    float _1181 = fma(-0.90916597843170166015625, _1157 * buffer.MidtoneR, fma(1.0932400226593017578125, _1157, fma(0.2726530134677886962890625, _1154, fma(-0.25341498851776123046875, _1151, fma(-0.68149197101593017578125, _1148, fma(0.906076014041900634765625, _1145, fma(-1.1014499664306640625, buffer.MidtoneR, 1.0)))))));
                    _2843 = fma(1.0 - pow(1.0 - pow((_902 - _685) / fast::max(_909, 9.9999999747524270787835121154785e-07), _1181), 1.0 / _1181), _909, _685);
                }
                else
                {
                    bool _982 = fast::max(buffer.RngUp - 0.0500000007450580596923828125, _906) < _902;
                    bool _989;
                    if (_982)
                    {
                        _989 = _902 < (buffer.RngUp + 0.0500000007450580596923828125);
                    }
                    else
                    {
                        _989 = _982;
                    }
                    float _2844;
                    if (_989)
                    {
                        float _1190 = _902 * _902;
                        _2844 = fma(buffer.h2mR.w, _1190 * _902, fma(buffer.h2mR.z, _1190, fma(buffer.h2mR.y, _902, buffer.h2mR.x)));
                    }
                    else
                    {
                        float _2836;
                        if (buffer.HightlightsR > 0.0)
                        {
                            float _1220 = 1.0 - buffer.RngUp;
                            float _1225 = fast::max(_1220, 9.9999999747524270787835121154785e-07);
                            float _1226 = (_1220 + buffer.HightlightsR) / _1225;
                            float _2837;
                            if (_1226 <= 9.0)
                            {
                                _2837 = fma(_902, _1226, -((buffer.RngUp * buffer.HightlightsR) / _1225));
                            }
                            else
                            {
                                _2837 = fma(_902, 9.0, (-8.0) * buffer.RngUp);
                            }
                            _2836 = _2837;
                        }
                        else
                        {
                            _2836 = fma(_902, 1.0 + buffer.HightlightsR, -(buffer.RngUp * buffer.HightlightsR));
                        }
                        _2844 = _2836;
                    }
                    _2843 = _2844;
                }
                _2842 = _2843;
            }
            _2841 = _2842;
        }
        _2840 = _2841;
    }
    float4 _2758 = _676;
    _2758.x = _2840;
    float _1282 = _676.y + buffer.OffsetG;
    bool _1298;
    if (_911)
    {
        _1298 = (_685 - 0.0500000007450580596923828125) < _1282;
    }
    else
    {
        _1298 = _911;
    }
    bool _1305;
    if (_1298)
    {
        _1305 = _1282 < (buffer.RngUp + 0.0500000007450580596923828125);
    }
    else
    {
        _1305 = _1298;
    }
    float _2863;
    if (_1305)
    {
        float _1392 = _1282 * _1282;
        _2863 = fma(buffer.s2hG.w, _1392 * _1282, fma(buffer.s2hG.z, _1392, fma(buffer.s2hG.y, _1282, buffer.s2hG.x)));
    }
    else
    {
        float _1313 = _685 - 0.0500000007450580596923828125;
        float _2864;
        if (_1282 <= _1313)
        {
            float _2861;
            if (buffer.ShadowG > 0.0)
            {
                _2861 = fma(_1282, 1.0 - buffer.ShadowG, _685 * buffer.ShadowG);
            }
            else
            {
                float _1435 = (_685 - buffer.ShadowG) / fast::max(_685, 9.9999999747524270787835121154785e-07);
                float _2862;
                if (_1435 <= 9.0)
                {
                    _2862 = fma(_1282, _1435, buffer.ShadowG);
                }
                else
                {
                    _2862 = fma(_1282, 9.0, (-8.0) * _685);
                }
                _2861 = _2862;
            }
            _2864 = _2861;
        }
        else
        {
            bool _1324 = _1313 < _1282;
            bool _1333;
            if (_1324)
            {
                _1333 = _1282 < fast::min(_685 + 0.0500000007450580596923828125, _906);
            }
            else
            {
                _1333 = _1324;
            }
            float _2865;
            if (_1333)
            {
                float _1460 = _1282 * _1282;
                _2865 = fma(buffer.s2mG.w, _1460 * _1282, fma(buffer.s2mG.z, _1460, fma(buffer.s2mG.y, _1282, buffer.s2mG.x)));
            }
            else
            {
                bool _1342 = (_685 + 0.0500000007450580596923828125) <= _1282;
                bool _1349;
                if (_1342)
                {
                    _1349 = _1282 <= (buffer.RngUp - 0.0500000007450580596923828125);
                }
                else
                {
                    _1349 = _1342;
                }
                float _2866;
                if (_1349)
                {
                    float _1525 = buffer.MidtoneG * buffer.MidtoneG;
                    float _1528 = _1525 * buffer.MidtoneG;
                    float _1531 = _1528 * buffer.MidtoneG;
                    float _1534 = _1531 * buffer.MidtoneG;
                    float _1537 = _1534 * buffer.MidtoneG;
                    float _1561 = fma(-0.90916597843170166015625, _1537 * buffer.MidtoneG, fma(1.0932400226593017578125, _1537, fma(0.2726530134677886962890625, _1534, fma(-0.25341498851776123046875, _1531, fma(-0.68149197101593017578125, _1528, fma(0.906076014041900634765625, _1525, fma(-1.1014499664306640625, buffer.MidtoneG, 1.0)))))));
                    _2866 = fma(1.0 - pow(1.0 - pow((_1282 - _685) / fast::max(_909, 9.9999999747524270787835121154785e-07), _1561), 1.0 / _1561), _909, _685);
                }
                else
                {
                    bool _1362 = fast::max(buffer.RngUp - 0.0500000007450580596923828125, _906) < _1282;
                    bool _1369;
                    if (_1362)
                    {
                        _1369 = _1282 < (buffer.RngUp + 0.0500000007450580596923828125);
                    }
                    else
                    {
                        _1369 = _1362;
                    }
                    float _2867;
                    if (_1369)
                    {
                        float _1570 = _1282 * _1282;
                        _2867 = fma(buffer.h2mG.w, _1570 * _1282, fma(buffer.h2mG.z, _1570, fma(buffer.h2mG.y, _1282, buffer.h2mG.x)));
                    }
                    else
                    {
                        float _2859;
                        if (buffer.HightlightsG > 0.0)
                        {
                            float _1600 = 1.0 - buffer.RngUp;
                            float _1605 = fast::max(_1600, 9.9999999747524270787835121154785e-07);
                            float _1606 = (_1600 + buffer.HightlightsG) / _1605;
                            float _2860;
                            if (_1606 <= 9.0)
                            {
                                _2860 = fma(_1282, _1606, -((buffer.RngUp * buffer.HightlightsG) / _1605));
                            }
                            else
                            {
                                _2860 = fma(_1282, 9.0, (-8.0) * buffer.RngUp);
                            }
                            _2859 = _2860;
                        }
                        else
                        {
                            _2859 = fma(_1282, 1.0 + buffer.HightlightsG, -(buffer.RngUp * buffer.HightlightsG));
                        }
                        _2867 = _2859;
                    }
                    _2866 = _2867;
                }
                _2865 = _2866;
            }
            _2864 = _2865;
        }
        _2863 = _2864;
    }
    float4 _2773 = _2758;
    _2773.y = _2863;
    float _1662 = _676.z + buffer.OffsetB;
    bool _1678;
    if (_911)
    {
        _1678 = (_685 - 0.0500000007450580596923828125) < _1662;
    }
    else
    {
        _1678 = _911;
    }
    bool _1685;
    if (_1678)
    {
        _1685 = _1662 < (buffer.RngUp + 0.0500000007450580596923828125);
    }
    else
    {
        _1685 = _1678;
    }
    float _2886;
    if (_1685)
    {
        float _1772 = _1662 * _1662;
        _2886 = fma(buffer.s2hB.w, _1772 * _1662, fma(buffer.s2hB.z, _1772, fma(buffer.s2hB.y, _1662, buffer.s2hB.x)));
    }
    else
    {
        float _1693 = _685 - 0.0500000007450580596923828125;
        float _2887;
        if (_1662 <= _1693)
        {
            float _2884;
            if (buffer.ShadowB > 0.0)
            {
                _2884 = fma(_1662, 1.0 - buffer.ShadowB, _685 * buffer.ShadowB);
            }
            else
            {
                float _1815 = (_685 - buffer.ShadowB) / fast::max(_685, 9.9999999747524270787835121154785e-07);
                float _2885;
                if (_1815 <= 9.0)
                {
                    _2885 = fma(_1662, _1815, buffer.ShadowB);
                }
                else
                {
                    _2885 = fma(_1662, 9.0, (-8.0) * _685);
                }
                _2884 = _2885;
            }
            _2887 = _2884;
        }
        else
        {
            bool _1704 = _1693 < _1662;
            bool _1713;
            if (_1704)
            {
                _1713 = _1662 < fast::min(_685 + 0.0500000007450580596923828125, _906);
            }
            else
            {
                _1713 = _1704;
            }
            float _2888;
            if (_1713)
            {
                float _1840 = _1662 * _1662;
                _2888 = fma(buffer.s2mB.w, _1840 * _1662, fma(buffer.s2mB.z, _1840, fma(buffer.s2mB.y, _1662, buffer.s2mB.x)));
            }
            else
            {
                bool _1722 = (_685 + 0.0500000007450580596923828125) <= _1662;
                bool _1729;
                if (_1722)
                {
                    _1729 = _1662 <= (buffer.RngUp - 0.0500000007450580596923828125);
                }
                else
                {
                    _1729 = _1722;
                }
                float _2889;
                if (_1729)
                {
                    float _1905 = buffer.MidtoneB * buffer.MidtoneB;
                    float _1908 = _1905 * buffer.MidtoneB;
                    float _1911 = _1908 * buffer.MidtoneB;
                    float _1914 = _1911 * buffer.MidtoneB;
                    float _1917 = _1914 * buffer.MidtoneB;
                    float _1941 = fma(-0.90916597843170166015625, _1917 * buffer.MidtoneB, fma(1.0932400226593017578125, _1917, fma(0.2726530134677886962890625, _1914, fma(-0.25341498851776123046875, _1911, fma(-0.68149197101593017578125, _1908, fma(0.906076014041900634765625, _1905, fma(-1.1014499664306640625, buffer.MidtoneB, 1.0)))))));
                    _2889 = fma(1.0 - pow(1.0 - pow((_1662 - _685) / fast::max(_909, 9.9999999747524270787835121154785e-07), _1941), 1.0 / _1941), _909, _685);
                }
                else
                {
                    bool _1742 = fast::max(buffer.RngUp - 0.0500000007450580596923828125, _906) < _1662;
                    bool _1749;
                    if (_1742)
                    {
                        _1749 = _1662 < (buffer.RngUp + 0.0500000007450580596923828125);
                    }
                    else
                    {
                        _1749 = _1742;
                    }
                    float _2890;
                    if (_1749)
                    {
                        float _1950 = _1662 * _1662;
                        _2890 = fma(buffer.h2mB.w, _1950 * _1662, fma(buffer.h2mB.z, _1950, fma(buffer.h2mB.y, _1662, buffer.h2mB.x)));
                    }
                    else
                    {
                        float _2882;
                        if (buffer.HightlightsB > 0.0)
                        {
                            float _1980 = 1.0 - buffer.RngUp;
                            float _1985 = fast::max(_1980, 9.9999999747524270787835121154785e-07);
                            float _1986 = (_1980 + buffer.HightlightsB) / _1985;
                            float _2883;
                            if (_1986 <= 9.0)
                            {
                                _2883 = fma(_1662, _1986, -((buffer.RngUp * buffer.HightlightsB) / _1985));
                            }
                            else
                            {
                                _2883 = fma(_1662, 9.0, (-8.0) * buffer.RngUp);
                            }
                            _2882 = _2883;
                        }
                        else
                        {
                            _2882 = fma(_1662, 1.0 + buffer.HightlightsB, -(buffer.RngUp * buffer.HightlightsB));
                        }
                        _2890 = _2882;
                    }
                    _2889 = _2890;
                }
                _2888 = _2889;
            }
            _2887 = _2888;
        }
        _2886 = _2887;
    }
    float4 _2788 = _2773;
    _2788.z = _2886;
    float4 _780 = fast::clamp(_2788, float4(0.0), float4(1.0));
    float _2031 = _780.x;
    float _2033 = _780.y;
    float _2035 = _780.z;
    float _2040 = fast::max(_2031, fast::max(_2033, _2035));
    float _2045 = fast::min(_2031, fast::min(_2033, _2035));
    float _2048 = _2040 - _2045;
    float _2051 = _2040 + _2045;
    float _2052 = _2051 * 0.5;
    float _2905;
    float _2909;
    if (_2048 < 9.9999997473787516355514526367188e-06)
    {
        _2909 = 0.0;
        _2905 = 0.0;
    }
    else
    {
        float _2912;
        if (_2052 <= 0.5)
        {
            _2912 = _2048 / _2051;
        }
        else
        {
            _2912 = _2048 / (2.0 - _2051);
        }
        float _2906;
        if ((_2040 - _2031) < 9.9999997473787516355514526367188e-06)
        {
            float _2907;
            if (_2033 >= _2035)
            {
                _2907 = (60.0 * (_2033 - _2035)) / _2048;
            }
            else
            {
                _2907 = ((60.0 * (_2033 - _2035)) / _2048) + 360.0;
            }
            _2906 = _2907;
        }
        else
        {
            float _2908;
            if ((_2040 - _2033) < 9.9999997473787516355514526367188e-06)
            {
                _2908 = ((60.0 * (_2035 - _2031)) / _2048) + 120.0;
            }
            else
            {
                _2908 = ((60.0 * (_2031 - _2033)) / _2048) + 240.0;
            }
            _2906 = _2908;
        }
        _2909 = _2912;
        _2905 = _2906;
    }
    float _2137 = fma(0.072200000286102294921875, _2035, fma(0.2125999927520751953125, _2031, 0.715200006961822509765625 * _2033));
    bool _2177;
    if (_911)
    {
        _2177 = (_685 - 0.0500000007450580596923828125) < _2137;
    }
    else
    {
        _2177 = _911;
    }
    bool _2184;
    if (_2177)
    {
        _2184 = _2137 < (buffer.RngUp + 0.0500000007450580596923828125);
    }
    else
    {
        _2184 = _2177;
    }
    float _2923;
    if (_2184)
    {
        float _2271 = _2137 * _2137;
        _2923 = fma(buffer.s2hS.w, _2271 * _2137, fma(buffer.s2hS.z, _2271, fma(buffer.s2hS.y, _2137, buffer.s2hS.x)));
    }
    else
    {
        float _2192 = _685 - 0.0500000007450580596923828125;
        float _2924;
        if (_2137 <= _2192)
        {
            float _2921;
            if (buffer.ShadowS > 0.0)
            {
                _2921 = fma(_2137, 1.0 - buffer.ShadowS, _685 * buffer.ShadowS);
            }
            else
            {
                float _2314 = (_685 - buffer.ShadowS) / fast::max(_685, 9.9999999747524270787835121154785e-07);
                float _2922;
                if (_2314 <= 9.0)
                {
                    _2922 = fma(_2137, _2314, buffer.ShadowS);
                }
                else
                {
                    _2922 = fma(_2137, 9.0, (-8.0) * _685);
                }
                _2921 = _2922;
            }
            _2924 = _2921;
        }
        else
        {
            bool _2203 = _2192 < _2137;
            bool _2212;
            if (_2203)
            {
                _2212 = _2137 < fast::min(_685 + 0.0500000007450580596923828125, _906);
            }
            else
            {
                _2212 = _2203;
            }
            float _2925;
            if (_2212)
            {
                float _2339 = _2137 * _2137;
                _2925 = fma(buffer.s2mS.w, _2339 * _2137, fma(buffer.s2mS.z, _2339, fma(buffer.s2mS.y, _2137, buffer.s2mS.x)));
            }
            else
            {
                bool _2221 = (_685 + 0.0500000007450580596923828125) <= _2137;
                bool _2228;
                if (_2221)
                {
                    _2228 = _2137 <= (buffer.RngUp - 0.0500000007450580596923828125);
                }
                else
                {
                    _2228 = _2221;
                }
                float _2926;
                if (_2228)
                {
                    float _2404 = buffer.MidtoneS * buffer.MidtoneS;
                    float _2407 = _2404 * buffer.MidtoneS;
                    float _2410 = _2407 * buffer.MidtoneS;
                    float _2413 = _2410 * buffer.MidtoneS;
                    float _2416 = _2413 * buffer.MidtoneS;
                    float _2440 = fma(-0.90916597843170166015625, _2416 * buffer.MidtoneS, fma(1.0932400226593017578125, _2416, fma(0.2726530134677886962890625, _2413, fma(-0.25341498851776123046875, _2410, fma(-0.68149197101593017578125, _2407, fma(0.906076014041900634765625, _2404, fma(-1.1014499664306640625, buffer.MidtoneS, 1.0)))))));
                    _2926 = fma(1.0 - pow(1.0 - pow((_2137 - _685) / fast::max(_909, 9.9999999747524270787835121154785e-07), _2440), 1.0 / _2440), _909, _685);
                }
                else
                {
                    bool _2241 = fast::max(buffer.RngUp - 0.0500000007450580596923828125, _906) < _2137;
                    bool _2248;
                    if (_2241)
                    {
                        _2248 = _2137 < (buffer.RngUp + 0.0500000007450580596923828125);
                    }
                    else
                    {
                        _2248 = _2241;
                    }
                    float _2927;
                    if (_2248)
                    {
                        float _2449 = _2137 * _2137;
                        _2927 = fma(buffer.h2mS.w, _2449 * _2137, fma(buffer.h2mS.z, _2449, fma(buffer.h2mS.y, _2137, buffer.h2mS.x)));
                    }
                    else
                    {
                        float _2919;
                        if (buffer.HightlightsS > 0.0)
                        {
                            float _2479 = 1.0 - buffer.RngUp;
                            float _2484 = fast::max(_2479, 9.9999999747524270787835121154785e-07);
                            float _2485 = (_2479 + buffer.HightlightsS) / _2484;
                            float _2920;
                            if (_2485 <= 9.0)
                            {
                                _2920 = fma(_2137, _2485, -((buffer.RngUp * buffer.HightlightsS) / _2484));
                            }
                            else
                            {
                                _2920 = fma(_2137, 9.0, (-8.0) * buffer.RngUp);
                            }
                            _2919 = _2920;
                        }
                        else
                        {
                            _2919 = fma(_2137, 1.0 + buffer.HightlightsS, -(buffer.RngUp * buffer.HightlightsS));
                        }
                        _2927 = _2919;
                    }
                    _2926 = _2927;
                }
                _2925 = _2926;
            }
            _2924 = _2925;
        }
        _2923 = _2924;
    }
    float _826 = fma(_2923 - _2137, 12.0, buffer.OffsetS);
    float _835 = fast::clamp(_2909 * (1.0 + _826), 0.0, 1.0);
    float4 _2989;
    if (abs(_826) > 9.9999997473787516355514526367188e-06)
    {
        float _2538 = _2905 * 0.00277777784503996372222900390625;
        float _2952;
        float _2959;
        float _2963;
        if (_835 == 0.0)
        {
            _2963 = _2052;
            _2959 = _2052;
            _2952 = _2052;
        }
        else
        {
            float _2942;
            if (_2052 < 0.5)
            {
                _2942 = _2052 * (1.0 + _835);
            }
            else
            {
                _2942 = fma(_2051 * (-0.5), _835, fma(_2051, 0.5, _835));
            }
            float _2574 = _2051 - _2942;
            float _2576 = fma(_2905, 0.00277777784503996372222900390625, 0.3333333432674407958984375);
            float _2945;
            do
            {
                float _2943;
                if (_2576 < 0.0)
                {
                    _2943 = _2576 + 1.0;
                }
                else
                {
                    _2943 = _2576;
                }
                float _2944;
                if (_2943 > 1.0)
                {
                    _2944 = _2943 - 1.0;
                }
                else
                {
                    _2944 = _2943;
                }
                if (_2944 < 0.16666667163372039794921875)
                {
                    _2945 = fma((_2942 - _2574) * 6.0, _2944, _2574);
                    break;
                }
                if (_2944 < 0.5)
                {
                    _2945 = _2942;
                    break;
                }
                if (_2944 < 0.666666686534881591796875)
                {
                    _2945 = fma((_2942 - _2574) * (0.666666686534881591796875 - _2944), 6.0, _2574);
                    break;
                }
                _2945 = _2574;
                break;
            } while(false);
            float _2948;
            do
            {
                float _2946;
                if (_2538 < 0.0)
                {
                    _2946 = fma(_2905, 0.00277777784503996372222900390625, 1.0);
                }
                else
                {
                    _2946 = _2538;
                }
                float _2947;
                if (_2946 > 1.0)
                {
                    _2947 = _2946 - 1.0;
                }
                else
                {
                    _2947 = _2946;
                }
                if (_2947 < 0.16666667163372039794921875)
                {
                    _2948 = fma((_2942 - _2574) * 6.0, _2947, _2574);
                    break;
                }
                if (_2947 < 0.5)
                {
                    _2948 = _2942;
                    break;
                }
                if (_2947 < 0.666666686534881591796875)
                {
                    _2948 = fma((_2942 - _2574) * (0.666666686534881591796875 - _2947), 6.0, _2574);
                    break;
                }
                _2948 = _2574;
                break;
            } while(false);
            float _2585 = fma(_2905, 0.00277777784503996372222900390625, -0.3333333432674407958984375);
            float _2951;
            do
            {
                float _2949;
                if (_2585 < 0.0)
                {
                    _2949 = _2585 + 1.0;
                }
                else
                {
                    _2949 = _2585;
                }
                float _2950;
                if (_2949 > 1.0)
                {
                    _2950 = _2949 - 1.0;
                }
                else
                {
                    _2950 = _2949;
                }
                if (_2950 < 0.16666667163372039794921875)
                {
                    _2951 = fma((_2942 - _2574) * 6.0, _2950, _2574);
                    break;
                }
                if (_2950 < 0.5)
                {
                    _2951 = _2942;
                    break;
                }
                if (_2950 < 0.666666686534881591796875)
                {
                    _2951 = fma((_2942 - _2574) * (0.666666686534881591796875 - _2950), 6.0, _2574);
                    break;
                }
                _2951 = _2574;
                break;
            } while(false);
            _2963 = _2951;
            _2959 = _2948;
            _2952 = _2945;
        }
        float4 _2825 = _780;
        _2825.x = _2952;
        float4 _2827 = _2825;
        _2827.y = _2959;
        float4 _2829 = _2827;
        _2829.z = _2963;
        _2989 = _2829;
    }
    else
    {
        _2989 = _780;
    }
    float3 _858 = mix(_676.xyz, _2989.xyz, float3(buffer.Intensity));
    float4 _2831 = _2989;
    _2831.x = _858.x;
    float4 _2833 = _2831;
    _2833.y = _858.y;
    float4 _2835 = _2833;
    _2835.z = _858.z;
    out.gl_FragColor = fast::clamp(_2835, float4(0.0), float4(1.0));
    return out;
}

