#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float intensityY;
    float intensityR;
    float intensityG;
    float intensityB;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> lutY [[texture(0)]], texture2d<float> lutR [[texture(1)]], texture2d<float> lutG [[texture(2)]], texture2d<float> lutB [[texture(3)]], texture2d<float> inputImageTexture [[texture(4)]], sampler lutYSmplr [[sampler(0)]], sampler lutRSmplr [[sampler(1)]], sampler lutGSmplr [[sampler(2)]], sampler lutBSmplr [[sampler(3)]], sampler inputImageTextureSmplr [[sampler(4)]])
{
    main0_out out = {};
    float4 _222 = inputImageTexture.sample(inputImageTextureSmplr, in.uv0);
    float _263 = _222.x;
    float4 _265 = lutR.sample(lutRSmplr, float2(_263, 0.5));
    float _294 = fma(_265.z, 0.0039215688593685626983642578125, fma(_265.x, 255.0, _265.y));
    float _542;
    if (_265.w < 0.5)
    {
        _542 = _294;
    }
    else
    {
        _542 = -_294;
    }
    float _278 = fma(_542 - _263, buffer.intensityR, _263);
    float4 _501 = _222;
    _501.x = _278;
    float _314 = _222.y;
    float4 _316 = lutG.sample(lutGSmplr, float2(_314, 0.5));
    float _345 = fma(_316.z, 0.0039215688593685626983642578125, fma(_316.x, 255.0, _316.y));
    float _544;
    if (_316.w < 0.5)
    {
        _544 = _345;
    }
    else
    {
        _544 = -_345;
    }
    float _329 = fma(_544 - _314, buffer.intensityG, _314);
    float4 _513 = _501;
    _513.y = _329;
    float _365 = _222.z;
    float4 _367 = lutB.sample(lutBSmplr, float2(_365, 0.5));
    float _396 = fma(_367.z, 0.0039215688593685626983642578125, fma(_367.x, 255.0, _367.y));
    float _546;
    if (_367.w < 0.5)
    {
        _546 = _396;
    }
    else
    {
        _546 = -_396;
    }
    float _380 = fma(_546 - _365, buffer.intensityB, _365);
    float4 _525 = _513;
    _525.z = _380;
    float _427 = fma(0.072200000286102294921875, _365, fma(0.2125999927520751953125, _263, 0.715200006961822509765625 * _314));
    float4 _442 = lutY.sample(lutYSmplr, float2(_427, 0.5));
    float _478 = fma(_442.z, 0.0039215688593685626983642578125, fma(_442.x, 255.0, _442.y));
    float _548;
    if (_442.w < 0.5)
    {
        _548 = _478;
    }
    else
    {
        _548 = -_478;
    }
    float3 _457 = _525.xyz + float3(fma(_548 - _427, buffer.intensityY, -(fma(0.072200000286102294921875, _380, fma(0.2125999927520751953125, _278, 0.715200006961822509765625 * _329)) - _427)));
    float4 _537 = _525;
    _537.x = _457.x;
    float4 _539 = _537;
    _539.y = _457.y;
    float4 _541 = _539;
    _541.z = _457.z;
    out.gl_FragColor = fast::clamp(_541, float4(0.0), float4(1.0));
    return out;
}

