#pragma clang diagnostic ignored "-Wmissing-prototypes"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

// Implementation of the GLSL mod() function, which is slightly different than Metal fmod()
template<typename Tx, typename Ty>
inline Tx mod(Tx x, Ty y)
{
    return x - y * floor(x / y);
}

struct buffer_t
{
    float u_contrastPivotSlope;
    float u_contrastLeftSlopeDiff;
    float u_contrastLeftDiff;
    float u_contrastRightSlopeDiff;
    float u_contrastRightDiff;
    int u_enableBrightness;
    float u_brightnessParam;
    int u_enableContrast;
    float u_contrastParam;
    float u_contrastPivot;
    float u_contrastXFactor;
    int u_enableSaturation;
    float u_saturationParam;
    int u_enableVibrance;
    float u_vibranceParam;
    int u_enableHighlight;
    float u_highlightParam;
    int u_enableShadow;
    float u_shadowParam;
    int u_enableBlackWhite;
    float u_blackWhiteSlope;
    float u_blackWhiteBias;
    int u_enableTemperatureTint;
    float3 u_temperatureTintRedVec3;
    float3 u_temperatureTintGreenVec3;
    float3 u_temperatureTintBlueVec3;
    int u_enableFade;
    float u_fadeParam;
    int u_enableLightSensation;
    float u_lightSensationParam;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv0 [[user(uv0)]];
};

static inline __attribute__((always_inline))
float getContrastSigmoidValue(thread const float& x, thread const float& xFactor, thread const float& pivot)
{
    float res = ((1.0 / (1.0 + exp((-xFactor) * (x - pivot)))) + pivot) - 0.5;
    return res;
}

static inline __attribute__((always_inline))
float getContrastSigmoidDerivative(thread const float& x, thread const float& xFactor, thread const float& pivot)
{
    float s = 1.0 / (1.0 + exp((-xFactor) * (x - pivot)));
    float k = (xFactor * s) * (1.0 - s);
    return k;
}

static inline __attribute__((always_inline))
float enchanceContrast(thread const float& x, thread const float& xFactor, thread const float& pivot, constant float& u_contrastPivotSlope, constant float& u_contrastLeftSlopeDiff, constant float& u_contrastLeftDiff, constant float& u_contrastRightSlopeDiff, constant float& u_contrastRightDiff)
{
    float param = x;
    float param_1 = xFactor;
    float param_2 = pivot;
    float res = getContrastSigmoidValue(param, param_1, param_2);
    float param_3 = x;
    float param_4 = xFactor;
    float param_5 = pivot;
    float k = getContrastSigmoidDerivative(param_3, param_4, param_5);
    if (x <= pivot)
    {
        float scale = (u_contrastPivotSlope - k) / u_contrastLeftSlopeDiff;
        scale *= scale;
        res += (scale * u_contrastLeftDiff);
    }
    else
    {
        float scale_1 = (u_contrastPivotSlope - k) / u_contrastRightSlopeDiff;
        scale_1 *= scale_1;
        res += (scale_1 * u_contrastRightDiff);
    }
    return res;
}

static inline __attribute__((always_inline))
float calcSaturation(thread const float3& color)
{
    float maxVal = fast::max(fast::max(color.x, color.y), color.z);
    float minVal = fast::min(fast::min(color.x, color.y), color.z);
    return maxVal - minVal;
}

static inline __attribute__((always_inline))
float calcDstSaturation(thread float& value, thread const float& sat)
{
    float dstSat = sat;
    value = fast::clamp(value, -100.0, 100.0);
    if (value > 0.0)
    {
        float factor = 1.15339004993438720703125 / (1.0 + exp((0.011138699948787689208984375 * value) - 1.85153996944427490234375));
        dstSat = 1.0 - pow(1.0 - pow(sat, factor), 1.0 / factor);
    }
    else
    {
        float factor_1 = (((5.6566398143331753090023994445801e-07 * ((value * value) * value)) + (0.00010740500147221609950065612792969 * (value * value))) + (0.011087999679148197174072265625 * value)) + 1.0;
        dstSat = factor_1 * sat;
    }
    return dstSat;
}

static inline __attribute__((always_inline))
float3 rgb_to_hsv(thread const float3& rgb)
{
    float cmax = fast::max(fast::max(rgb.x, rgb.y), rgb.z);
    float cmin = fast::min(fast::min(rgb.x, rgb.y), rgb.z);
    float delta = cmax - cmin;
    float3 hsv = float3(0.0);
    hsv.z = cmax;
    if (cmax > 0.0)
    {
        hsv.y = delta / cmax;
    }
    else
    {
        hsv.y = 0.0;
        return hsv;
    }
    if (delta == 0.0)
    {
        hsv.x = 0.0;
    }
    else
    {
        if (cmax == rgb.x)
        {
            hsv.x = 60.0 * mod((rgb.y - rgb.z) / delta, 6.0);
        }
        else
        {
            if (cmax == rgb.y)
            {
                hsv.x = 60.0 * (((rgb.z - rgb.x) / delta) + 2.0);
            }
            else
            {
                hsv.x = 60.0 * (((rgb.x - rgb.y) / delta) + 4.0);
            }
        }
    }
    if (hsv.x < 0.0)
    {
        hsv.x += 360.0;
    }
    return hsv;
}

static inline __attribute__((always_inline))
float3 hsv_to_rgb(thread const float3& hsv)
{
    float c = hsv.z * hsv.y;
    float x = c * (1.0 - abs(mod(hsv.x / 60.0, 2.0) - 1.0));
    float m = hsv.z - c;
    float3 rgb;
    if (hsv.x < 60.0)
    {
        rgb = float3(c, x, 0.0);
    }
    else
    {
        if (hsv.x < 120.0)
        {
            rgb = float3(x, c, 0.0);
        }
        else
        {
            if (hsv.x < 180.0)
            {
                rgb = float3(0.0, c, x);
            }
            else
            {
                if (hsv.x < 240.0)
                {
                    rgb = float3(0.0, x, c);
                }
                else
                {
                    if (hsv.x < 300.0)
                    {
                        rgb = float3(x, 0.0, c);
                    }
                    else
                    {
                        rgb = float3(c, 0.0, x);
                    }
                }
            }
        }
    }
    return rgb + float3(m);
}

static inline __attribute__((always_inline))
float3 adjustSaturation(thread const float3& rgb, thread const float& adjustParam)
{
    float3 param = rgb;
    float3 hsv = rgb_to_hsv(param);
    hsv.y = fast::clamp(hsv.y * adjustParam, 0.0, 1.0);
    float3 param_1 = hsv;
    return hsv_to_rgb(param_1);
}

static inline __attribute__((always_inline))
float3 adjustHighlight(thread const float3& color, thread const float& p)
{
    float3 t = float3(1.0) - color;
    float3 t2 = t * t;
    float3 t3 = t2 * t;
    float3 resColor = (float3(1.0) - pow(t, float3(p))) - ((t2 - t3) * (p - 1.0));
    return resColor;
}

static inline __attribute__((always_inline))
float3 adjustShadow(thread const float3& color, thread const float& p)
{
    float3 color2 = color * color;
    float3 color3 = color2 * color;
    float3 resColor = pow(color, float3(p)) + ((color2 - color3) * (p - 1.0));
    return resColor;
}

static inline __attribute__((always_inline))
float4 applyLut3D(thread const float4& color, texture2d<float> lutTexture, sampler lutTextureSmplr, thread const float& gridSampleX, thread const float& gridSampleY, thread const float& gridNumX, thread const float& gridNumY)
{
    float gridNum = gridNumX * gridNumY;
    float lutWidth = gridSampleX * gridNumX;
    float lutHeight = gridSampleY * gridNumY;
    float gridSizeX = 1.0 / gridNumX;
    float gridSizeY = 1.0 / gridNumY;
    float blue = color.z * (gridNum - 1.0);
    float2 gridPos = float2(0.0);
    float gridIndex = floor(blue);
    gridPos.y = floor(gridIndex / gridNumX);
    gridPos.x = gridIndex - (gridPos.y * gridNumX);
    float scaleX = (1.0 / gridNumX) - (1.0 / lutWidth);
    float scaleY = (1.0 / gridNumY) - (1.0 / lutHeight);
    float2 texturePos = float2(0.0);
    texturePos.x = ((gridPos.x * gridSizeX) + (0.5 / lutWidth)) + (scaleX * color.x);
    texturePos.y = ((gridPos.y * gridSizeY) + (0.5 / lutHeight)) + (scaleY * color.y);
    float4 color1 = lutTexture.sample(lutTextureSmplr, texturePos);
    gridIndex = ceil(blue);
    gridPos.y = floor(gridIndex / gridNumX);
    gridPos.x = gridIndex - (gridPos.y * gridNumX);
    texturePos.x = ((gridPos.x * gridSizeX) + (0.5 / lutWidth)) + (scaleX * color.x);
    texturePos.y = ((gridPos.y * gridSizeY) + (0.5 / lutHeight)) + (scaleY * color.y);
    float4 color2 = lutTexture.sample(lutTextureSmplr, texturePos);
    float4 resultColor = mix(color1, color2, float4(fract(blue)));
    return resultColor;
}

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> u_inputTexture [[texture(0)]], texture2d<float> u_fadeMaxTexture [[texture(1)]], texture2d<float> u_lightSensationMinTexture [[texture(2)]], texture2d<float> u_lightSensationMaxTexture [[texture(3)]], sampler u_inputTextureSmplr [[sampler(0)]], sampler u_fadeMaxTextureSmplr [[sampler(1)]], sampler u_lightSensationMinTextureSmplr [[sampler(2)]], sampler u_lightSensationMaxTextureSmplr [[sampler(3)]])
{
    main0_out out = {};
    float4 color = u_inputTexture.sample(u_inputTextureSmplr, in.uv0);
    if (buffer.u_enableBrightness == 1)
    {
        float p = 0.0;
        if (buffer.u_brightnessParam > 0.0)
        {
            p = 1.0 + (buffer.u_brightnessParam * 5.0);
        }
        else
        {
            p = 1.0 / (1.0 - (buffer.u_brightnessParam * 2.5));
            float4 _676 = color;
            float3 _679 = _676.xyz - float3((-buffer.u_brightnessParam) * 0.00999999977648258209228515625);
            color.x = _679.x;
            color.y = _679.y;
            color.z = _679.z;
        }
        float4 _686 = color;
        float3 _694 = float3(1.0) - pow(float3(1.0) - _686.xyz, float3(p));
        color.x = _694.x;
        color.y = _694.y;
        color.z = _694.z;
        float4 _701 = color;
        float3 _705 = fast::clamp(_701.xyz, float3(0.0), float3(1.0));
        color.x = _705.x;
        color.y = _705.y;
        color.z = _705.z;
    }
    if (buffer.u_enableContrast == 1)
    {
        if (buffer.u_contrastParam <= 1.0)
        {
            float4 _723 = color;
            float3 _732 = ((_723.xyz - float3(buffer.u_contrastPivot)) * buffer.u_contrastParam) + float3(buffer.u_contrastPivot);
            color.x = _732.x;
            color.y = _732.y;
            color.z = _732.z;
        }
        else
        {
            float param = color.x;
            float param_1 = buffer.u_contrastXFactor;
            float param_2 = buffer.u_contrastPivot;
            color.x = enchanceContrast(param, param_1, param_2, buffer.u_contrastPivotSlope, buffer.u_contrastLeftSlopeDiff, buffer.u_contrastLeftDiff, buffer.u_contrastRightSlopeDiff, buffer.u_contrastRightDiff);
            float param_3 = color.y;
            float param_4 = buffer.u_contrastXFactor;
            float param_5 = buffer.u_contrastPivot;
            color.y = enchanceContrast(param_3, param_4, param_5, buffer.u_contrastPivotSlope, buffer.u_contrastLeftSlopeDiff, buffer.u_contrastLeftDiff, buffer.u_contrastRightSlopeDiff, buffer.u_contrastRightDiff);
            float param_6 = color.z;
            float param_7 = buffer.u_contrastXFactor;
            float param_8 = buffer.u_contrastPivot;
            color.z = enchanceContrast(param_6, param_7, param_8, buffer.u_contrastPivotSlope, buffer.u_contrastLeftSlopeDiff, buffer.u_contrastLeftDiff, buffer.u_contrastRightSlopeDiff, buffer.u_contrastRightDiff);
        }
        float4 _768 = color;
        float3 _772 = fast::clamp(_768.xyz, float3(0.0), float3(1.0));
        color.x = _772.x;
        color.y = _772.y;
        color.z = _772.z;
    }
    if (buffer.u_enableSaturation == 1)
    {
        float3 rgb = color.xyz;
        float3 baseAdjustVec = float3(0.2085399925708770751953125, 0.702085971832275390625, 0.089373998343944549560546875) * (1.0 - buffer.u_saturationParam);
        float3 adjustVec = baseAdjustVec + float3(buffer.u_saturationParam, 0.0, 0.0);
        color.x = dot(rgb, adjustVec);
        adjustVec = baseAdjustVec + float3(0.0, buffer.u_saturationParam, 0.0);
        color.y = dot(rgb, adjustVec);
        adjustVec = baseAdjustVec + float3(0.0, 0.0, buffer.u_saturationParam);
        color.z = dot(rgb, adjustVec);
        float4 _821 = color;
        float3 _825 = fast::clamp(_821.xyz, float3(0.0), float3(1.0));
        color.x = _825.x;
        color.y = _825.y;
        color.z = _825.z;
    }
    if (buffer.u_enableVibrance == 1)
    {
        float3 rgb_1 = color.xyz;
        float3 param_9 = rgb_1;
        float sat = calcSaturation(param_9);
        if (abs(sat) > 9.9999997473787516355514526367188e-06)
        {
            float param_10 = buffer.u_vibranceParam;
            float param_11 = sat;
            float _856 = calcDstSaturation(param_10, param_11);
            float dstSat = _856;
            float adjustParam = dstSat / sat;
            float3 param_12 = rgb_1;
            float param_13 = adjustParam;
            float3 _865 = adjustSaturation(param_12, param_13);
            color.x = _865.x;
            color.y = _865.y;
            color.z = _865.z;
        }
    }
    if (buffer.u_enableHighlight == 1)
    {
        float3 param_14 = color.xyz;
        float param_15 = buffer.u_highlightParam;
        float3 _883 = adjustHighlight(param_14, param_15);
        color.x = _883.x;
        color.y = _883.y;
        color.z = _883.z;
        float4 _890 = color;
        float3 _894 = fast::clamp(_890.xyz, float3(0.0), float3(1.0));
        color.x = _894.x;
        color.y = _894.y;
        color.z = _894.z;
    }
    if (buffer.u_enableShadow == 1)
    {
        float3 param_16 = color.xyz;
        float param_17 = buffer.u_shadowParam;
        float3 _912 = adjustShadow(param_16, param_17);
        color.x = _912.x;
        color.y = _912.y;
        color.z = _912.z;
        float4 _919 = color;
        float3 _923 = fast::clamp(_919.xyz, float3(0.0), float3(1.0));
        color.x = _923.x;
        color.y = _923.y;
        color.z = _923.z;
    }
    if (buffer.u_enableBlackWhite == 1)
    {
        float4 _937 = color;
        float3 _943 = (_937.xyz * buffer.u_blackWhiteSlope) + float3(buffer.u_blackWhiteBias);
        color.x = _943.x;
        color.y = _943.y;
        color.z = _943.z;
        float4 _950 = color;
        float3 _954 = fast::clamp(_950.xyz, float3(0.0), float3(1.0));
        color.x = _954.x;
        color.y = _954.y;
        color.z = _954.z;
    }
    if (buffer.u_enableTemperatureTint == 1)
    {
        float3 rgb_2 = color.xyz;
        color.x = dot(rgb_2, buffer.u_temperatureTintRedVec3);
        color.y = dot(rgb_2, buffer.u_temperatureTintGreenVec3);
        color.z = dot(rgb_2, buffer.u_temperatureTintBlueVec3);
        float4 _985 = color;
        float3 _989 = fast::clamp(_985.xyz, float3(0.0), float3(1.0));
        color.x = _989.x;
        color.y = _989.y;
        color.z = _989.z;
    }
    if (buffer.u_enableFade == 1)
    {
        float4 param_18 = color;
        float param_19 = 17.0;
        float param_20 = 17.0;
        float param_21 = 17.0;
        float param_22 = 1.0;
        float4 fadeColor = applyLut3D(param_18, u_fadeMaxTexture, u_fadeMaxTextureSmplr, param_19, param_20, param_21, param_22);
        float4 _1011 = color;
        float3 _1018 = mix(_1011.xyz, fadeColor.xyz, float3(buffer.u_fadeParam));
        color.x = _1018.x;
        color.y = _1018.y;
        color.z = _1018.z;
        float4 _1025 = color;
        float3 _1029 = fast::clamp(_1025.xyz, float3(0.0), float3(1.0));
        color.x = _1029.x;
        color.y = _1029.y;
        color.z = _1029.z;
    }
    if (buffer.u_enableLightSensation == 1)
    {
        float4 newColor = color;
        if (buffer.u_lightSensationParam <= 0.0)
        {
            float4 param_23 = color;
            float param_24 = 17.0;
            float param_25 = 17.0;
            float param_26 = 17.0;
            float param_27 = 1.0;
            newColor = applyLut3D(param_23, u_lightSensationMinTexture, u_lightSensationMinTextureSmplr, param_24, param_25, param_26, param_27);
        }
        else
        {
            float4 param_28 = color;
            float param_29 = 17.0;
            float param_30 = 17.0;
            float param_31 = 17.0;
            float param_32 = 1.0;
            newColor = applyLut3D(param_28, u_lightSensationMaxTexture, u_lightSensationMaxTextureSmplr, param_29, param_30, param_31, param_32);
        }
        float4 _1065 = color;
        float3 _1072 = mix(_1065.xyz, newColor.xyz, float3(abs(buffer.u_lightSensationParam)));
        color.x = _1072.x;
        color.y = _1072.y;
        color.z = _1072.z;
        float4 _1079 = color;
        float3 _1083 = fast::clamp(_1079.xyz, float3(0.0), float3(1.0));
        color.x = _1083.x;
        color.y = _1083.y;
        color.z = _1083.z;
    }
    out.gl_FragColor = fast::clamp(color, float4(0.0), float4(1.0));
    return out;
}

