
local exports = exports or {}
local GraphSystem = GraphSystem or {}
GraphSystem.__index = GraphSystem





function GraphSystem.new(construct, ...)
    local self = setmetatable({}, GraphSystem)
    local lua = {}
    self.nodes = {}
    self.callbackNode ={}
    self.callbackNode["onStart"] = {}
    self.callbackNode["onUpdate"] = {}
    self.callbackNode["onEvent"] = {}
    self.callbackNode["onComponentRemoved"] = {}
    self.callbackNode["onCallBack"] = {}
    self.callbackNode["tempOnStart"] = {}
    self.callbackNode["onDestroy"] = {}
    self.autoResetFlag = true
    self.system = nil
    -- member variable init
    self.defaultValues = {}
    self.propertyNodes = {}
      -- include file 
    -- end include file
        -- network connect
    --  end network connect
if #self.callbackNode["tempOnStart"] > 0 then
    for k, v in pairs(self.callbackNode["tempOnStart"]) do
        table.insert(self.callbackNode["onStart"], v)
    end
end
    return self
end

function GraphSystem:constructor()
    -- print('running: GraphSystem:constructor')
end

function GraphSystem:onComponentAdded(sys, comp)
    -- print('running: GraphSystem:onComponentAdded')
end

function GraphSystem:onComponentRemoved(sys, comp)
    -- print('running: GraphSystem:onComponentRemoved')
    -- print('running: GraphSystem:onStart')
    self.system = sys
    for i=1, #self.callbackNode["onComponentRemoved"] do
        self.callbackNode["onComponentRemoved"][i]:onDestroy(sys)
    end
end

function GraphSystem:onDestroy(sys)
    for i=1, #self.callbackNode["onDestroy"] do
        self.callbackNode["onDestroy"][i]:onDestroy(self.system)
    end
    self.system = nil
end

function GraphSystem:onStart(sys)
    for i = 1, #self.propertyNodes do
        self.propertyNodes[i]:initValue()
    end
    -- print('running: GraphSystem:onStart')
    for i=1, #self.callbackNode["onStart"] do
        self.callbackNode["onStart"][i]:execute(sys)
    end
end

function GraphSystem:onEvent(sys, event)
    -- print('running: GraphSystem:onEvent')
    if event.type == Amaz.AppEventType.COMPAT_BEF then
        local event_result = event.args:get(0)
        if event_result == Amaz.BEFEventType.BET_RECORD_VIDEO then
            local event_result = event.args:get(1)
            if event_result == 1 and self.autoResetFlag then
                for k, v in pairs(self.defaultValues) do
                    self[k] = v
                end
                for k, v in pairs(self.nodes) do
                    if v.onReset then
                    	v:onReset()
                    end
                end           
                -- Also trigger CGOnStart node.
                for k, v in pairs(self.nodes) do
                    if string.sub(k, 0, 7) == "OnStart" then
                    	v:execute()
                    end
                    if string.sub(k, 0, 13) == "Timer_Trigger" then
                    	v:execute(sys)
                    end
                end
            end
        end
    end
    for i=1, #self.callbackNode["onEvent"] do
        self.callbackNode["onEvent"][i]:onEvent(sys, event)
    end
end

function GraphSystem:onCallBack(sys, userData, eventType)
    -- print('running: GraphSystem:onCallBack')
    for i=1, #self.callbackNode["onCallBack"] do
        self.callbackNode["onCallBack"][i]:callback(sys, userData, eventType)
    end
end

function GraphSystem:onUpdate(sys,deltaTime)
    -- print('running: GraphSystem:onUpdate')
    for i = 1, #self.callbackNode["onUpdate"] do
        self.callbackNode["onUpdate"][i]:update(sys, deltaTime)
    end
end




function generateEmptyNode()
    local node = {}
    node.nexts = {}
    node.inputs = {}
    node.setNext = function(__self, __index, __next) __self.nexts[__index] = __next end
    node.setInput = function(__self, __index, __func) __self.inputs[__index] = __func end
    return node
end

exports.GraphSystem = GraphSystem
return exports
