local exports = exports or {}

local EffectFaceMakeupSystemScript = EffectFaceMakeupSystemScript or {}
EffectFaceMakeupSystemScript.__index = EffectFaceMakeupSystemScript

function EffectFaceMakeupSystemScript.new(construct, ...)
    local self = setmetatable({}, EffectFaceMakeupSystemScript)

    if construct and EffectFaceMakeupSystemScript.constructor then
        EffectFaceMakeupSystemScript.constructor(self, ...)
    end

    self.comps = {}
    self.genderReg = false
    self.intensity = 1
    return self
end

function EffectFaceMakeupSystemScript:constructor()
    Amaz.Algorithm.setAlgorithmParamInt("", "expression_detect_0", "face_attr_force_detect", 1)
end

function EffectFaceMakeupSystemScript:onStart(sys)
    self.sticker = sys.scene:findEntityBy("1825684423217955809"):getComponent("MeshRenderer").material
end

function EffectFaceMakeupSystemScript:onComponentAdded(sys, comp)
    if comp:isInstanceOf("EffectFaceMakeup") then
        table.insert(self.comps, comp)
    end
end

function  EffectFaceMakeupSystemScript:onComponentRemoved(sys, comp)
    if comp:isInstanceOf("EffectFaceMakeup") then
        local compCount = #self.comps
        for i = 1, compCount do
            if self.comps[i] == comp then
                table.remove(self.comps, i)
            end
        end
    end
end

function EffectFaceMakeupSystemScript:_setOpacity(comp, faceid, opacity)
    local renderer = comp.entity:getComponent("Renderer")
    local materials = renderer.materials
    opacity = opacity * self.intensity
    comp:setFaceUniform("opacity", faceid, opacity)

    if comp.type == Amaz.EffectFaceMakeupType.FACEU_PUPIL then
        comp:setFaceUniform("reflectOpacity", faceid, opacity)
    end

    renderer.materials = materials
    materials = nil
end

function EffectFaceMakeupSystemScript:onUpdate(sys,deltaTime)
    for i = 1, #self.comps do
        local makeupComponent = self.comps[i]
        if makeupComponent ~= nil then
            local femaleOpacity = makeupComponent.femaleOpacity
            local maleOpacity = makeupComponent.maleOpacity

            local result = Amaz.Algorithm.getAEAlgorithmResult()
            if result ~= nil then
                local faceCount = result:getFaceCount()
                for faceid = 0, faceCount-1 do
                    if femaleOpacity == 1.0 and maleOpacity == 1.0 then
                        self:_setOpacity(makeupComponent, faceid, 1.0)
                    else
                        local faceAttr = result:getFaceAttributeInfo(faceid)
                        local faceExtra = result:getFaceExtraInfo(faceid)
                        if faceAttr ~= nil and faceExtra ~= nil then
                            if self.genderReg == false then
                                Amaz.Algorithm.setAlgorithmParamInt("", "expression_detect_0", "face_attr_force_detect", 0)
                                self.genderReg = true
                            end
                            if faceAttr.gender == 1 then
                                self:_setOpacity(makeupComponent, faceid, maleOpacity)
                            elseif faceAttr.gender == 2 then
                                self:_setOpacity(makeupComponent, faceid, femaleOpacity)
                            end
                        end
                    end
                end
            end
        end
    end
end

function EffectFaceMakeupSystemScript:onEvent (sys, event)
    if "effects_adjust_intensity" == event.args:get(0) then
        self.intensity = event.args:get(1)
        self.sticker:setFloat("u_opacity", self.intensity)
    end
end

exports.EffectFaceMakeupSystemScript = EffectFaceMakeupSystemScript

return exports
