#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float4x4 u_Model;
    float4x4 u_TransposeInvModel;
    float4x4 u_MVP;
};

struct main0_out
{
    float2 fTexCoord [[user(fTexCoord)]];
    float3 g_vary_WorldPosition [[user(g_vary_WorldPosition)]];
    float3 g_vary_WorldNormal [[user(g_vary_WorldNormal)]];
    float2 g_vary_ScreenCoord [[user(g_vary_ScreenCoord)]];
    float4 gl_Position [[position]];
};

struct main0_in
{
    float3 attPosition [[attribute(0)]];
    float3 attNormal [[attribute(1)]];
    float2 attTexcoord0 [[attribute(2)]];
};

vertex main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer)
{
    main0_out out = {};
    out.fTexCoord.x = in.attTexcoord0.x;
    out.fTexCoord.y = 1.0 - in.attTexcoord0.y;
    float4 _39 = float4(in.attPosition, 1.0);
    out.g_vary_WorldPosition = (buffer.u_Model * _39).xyz;
    out.g_vary_WorldNormal = (buffer.u_TransposeInvModel * float4(in.attNormal, 0.0)).xyz;
    out.g_vary_WorldNormal = fast::normalize(out.g_vary_WorldNormal);
    float4 _65 = buffer.u_MVP * _39;
    out.g_vary_ScreenCoord = _65.xy / float2(_65.w);
    out.gl_Position = _65;
    out.gl_Position.z = (out.gl_Position.z + out.gl_Position.w) * 0.5;       // Adjust clip-space for Metal
    return out;
}

