#define AE_DirLightNum 1


precision highp float;

attribute vec3 attPosition;
attribute vec3 attNormal;
attribute vec2 attTexcoord0;
varying vec2 fTexCoord;
uniform mat4 u_MVP;
uniform mat4 u_TransposeInvModel;
uniform mat4 u_Model;

varying vec3 g_vary_WorldPosition;
varying vec3 g_vary_WorldNormal;
varying vec2 g_vary_ScreenCoord;

void main()
{
    fTexCoord.x = attTexcoord0.x;
    fTexCoord.y  = 1.0 - attTexcoord0.y;
    g_vary_WorldPosition = (u_Model * vec4(attPosition, 1.0)).xyz;
    g_vary_WorldNormal = (u_TransposeInvModel * vec4(attNormal, 0.0)).xyz;
    g_vary_WorldNormal = normalize(g_vary_WorldNormal);
    vec4 vertex_pos = u_MVP * vec4(attPosition, 1.0);
    g_vary_ScreenCoord = vertex_pos.xy / vertex_pos.w;
    gl_Position = u_MVP * vec4(attPosition, 1.0);
}



