#define AE_DirLightNum 1
#define AMAZING_USE_BLENDMODE_MUTIPLAY 1

#if defined(AE_FRAMEBUFFER_FETCH)
    #if defined(GL_EXT_shader_framebuffer_fetch)
        #extension GL_EXT_shader_framebuffer_fetch : require
    #elif defined(GL_ARM_shader_framebuffer_fetch)
        #extension GL_ARM_shader_framebuffer_fetch : require
    #endif
#endif
#define ae_insert_flip_uniform // FlipPatch will insert flip uniform here

precision highp float;


const int MAX_NUM_DIR = 1;
const int MAX_NUM_POINT = 1;
const int MAX_NUM_SPOT = 0;
const float PI = 3.1415926535897932384626433832795;

uniform vec3 u_WorldSpaceCameraPos;
varying vec2 fTexCoord;
varying vec3 g_vary_WorldPosition;
varying vec3 g_vary_WorldNormal;
varying vec2 g_vary_ScreenCoord;
uniform sampler2D u_AlbedoTexture;

// DirLight
uniform float u_DirLightNum;
uniform float u_DirLightsEnabled[MAX_NUM_DIR];
uniform vec3 u_DirLightsDirection[MAX_NUM_DIR];
uniform vec3 u_DirLightsColor[MAX_NUM_DIR];
uniform float u_DirLightsIntensity[MAX_NUM_DIR];

// PointLight
uniform float u_PointLightNum;
uniform float u_PointLightsEnabled[MAX_NUM_POINT];
uniform vec3 u_PointLightsPosition[MAX_NUM_POINT];
uniform vec3 u_PointLightsColor[MAX_NUM_POINT];
uniform float u_PointLightsIntensity[MAX_NUM_POINT];
uniform float u_PointLightsAttenRangeInv[MAX_NUM_POINT];

uniform vec4 u_SpecularColor;
uniform vec4 u_EmissiveColor;
uniform float u_Shininess;
uniform float u_Translucency;
uniform float u_opacity;

uniform float u_UseLight;
uniform float u_AmbientLightIntensity;

vec3 InvGammaColor(vec3 color)
{
	return pow(color, vec3(2.2));
}

float InvGammaColor(float x)
{
	return pow(x, 2.2);
}

vec3 GammaColor(vec3 color)
{
    return pow(color, vec3(0.45454545));
}

vec4 Color2D(sampler2D sampler, vec2 uv)
{
    return texture2D(sampler, uv);
}

vec4 Texture2DScale(sampler2D sampler, vec2 uv, float scale)
{
    return Color2D(sampler, uv * scale);
}

vec3 TransformTangentToWorld(vec3 v, mat3 TBN)
{
    return normalize(TBN * v);
}

vec3 TransformTexTangentToWorld(vec3 v, mat3 TBN)
{
    return TransformTangentToWorld(v * 2.0 - 1.0, TBN);
}

vec3 TransformWorldToTangent(vec3 v, mat3 TBN)
{
    return normalize(v * TBN);
}

vec3 rimColor(vec3 n, vec3 v, vec3 rimColor, float rimPower)
{
    float revNV = 1.0 - max(0.0, dot(n,v));
    vec3 rc = rimColor * pow(revNV, rimPower);
    return rc;
}

float Fresnel(float F0, float vh, float exp)
{
    return F0 + (1.0 - F0) * pow(1.0 - vh, exp);
}

float Grey(vec3 color)
{
    return color.r * 0.299 + color.g * 0.587 + color.b * 0.114;
}

float Luminance(vec3 color)
{
    return color.r * 0.2126 + color.g * 0.7152 + color.b * 0.0722;
}

vec4 EncodeRGBE8(vec4 rgba)
{
    vec4 rgbe8;
    float maxComponent = max(max(rgba.x, rgba.y), rgba.z);
    float exponent = ceil(log2(maxComponent) );
    rgbe8.xyz = rgba.rgb / exp2(exponent);
    rgbe8.w = (exponent + 128.0) / 255.0;
    return rgbe8;
}

vec3 DecodeRGBE8(vec4 rgbe8)
{
    float exponent = rgbe8.w * 255.0 - 128.0;
    return rgbe8.xyz * exp2(exponent);
}

vec4 EncodeColor(vec4 color)
{
    color.rgb = GammaColor(color.rgb);
    color.r = clamp(color.r, 0.0, 1.0);
    color.g = clamp(color.g, 0.0, 1.0);
    color.b = clamp(color.b, 0.0, 1.0);
    return color;
}

vec3 ACESToneMapping(vec3 color, float adapted_lum)
{
    const float A = 2.51;
    const float B = 0.03;
    const float C = 2.43;
    const float D = 0.59;
    const float E = 0.14;

    color *= adapted_lum;
    return (color * (A * color + B)) / (color * (C * color + D) + E);
}


////
float RoughnessCurveCorrect(float roughness)
{
    float curve = pow(sin(roughness), 1.5);
    return clamp(curve, 0.0, 0.6);
}


uniform sampler2D u_FBOTexture;
vec4 textureFromFBO(vec2 uv)
{
    #if defined(AE_FRAMEBUFFER_FETCH)
        #if defined(GL_EXT_shader_framebuffer_fetch)
            vec4 result = gl_LastFragData[0].rgba;
        #elif defined(GL_ARM_shader_framebuffer_fetch)
            vec4 result = gl_LastFragColorARM;
        #else
            #error AE_FRAMEBUFFER_FETCH but no ext found!
        #endif
    #else
         vec4 result = texture2D(u_FBOTexture, uv);
    #endif
    return result;
}


vec3 BlinnPhongShading(vec3 normal, vec3 view, vec3 light, vec3 diffColor, vec3 speColor, float shiness)
{
    float nl = dot(light, normal) * 0.5 + 0.5;
    vec3 halfway = normalize(light + view);
    float nh = clamp(dot(normal, halfway), 0.0, 1.0);
    return nl * diffColor + pow(nh, shiness) * speColor;
}

#ifdef AMAZING_USE_BLENDMODE_MUTIPLAY
vec3 BlendMultiply(vec3 base, vec3 blend)
{
    return base * blend;
}
vec3 BlendMultiply(vec3 base, vec3 blend, float opacity)
{
    return (BlendMultiply(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_OVERLAY
float BlendOverlay(float base, float blend)
{
    return base < 0.5 ? (2.0 * base * blend) :(1.0 - 2.0 * (1.0 - base) * (1.0 - blend));
}
vec3 BlendOverlay(vec3 base, vec3 blend)
{
    return vec3(BlendOverlay(base.r, blend.r), BlendOverlay(base.g, blend.g), BlendOverlay(base.b, blend.b));
}
vec3 BlendOverlay(vec3 base, vec3 blend, float opacity)
{
    return (BlendOverlay(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_ADD
vec3 BlendAdd(vec3 base, vec3 blend)
{
    return min(base + blend,vec3(1.0));
}
vec3 BlendAdd(vec3 base, vec3 blend, float opacity)
{
    return (BlendAdd(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_SCREEN
vec3 BlendScreen(vec3 base, vec3 blend)
{
    return vec3(1.0) - ((vec3(1.0) - base) * (vec3(1.0) - blend));
}
vec3 BlendScreen(vec3 base, vec3 blend, float opacity)
{
    return (BlendScreen(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_SOFTLIGHT
float BlendSoftLight(float base, float blend)
{
    return (blend<0.5)?(2.0*base*blend+base*base*(1.0-2.0*blend)):(sqrt(base)*(2.0*blend-1.0)+2.0*base*(1.0-blend));
}
vec3 BlendSoftLight(vec3 base, vec3 blend)
{
    return vec3(BlendSoftLight(base.r,blend.r),BlendSoftLight(base.g,blend.g),BlendSoftLight(base.b,blend.b));
}
vec3 BlendSoftLight(vec3 base, vec3 blend, float opacity)
{
    return (BlendSoftLight(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_AVERAGE
vec3 BlendAverage(vec3 base, vec3 blend)
{
    return (base + blend) / 2.0;
}
vec3 BlendAverage(vec3 base, vec3 blend, float opacity)
{
    return (BlendAverage(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_COLORBURN
float BlendColorBurn(float base, float blend)
{
    return (blend == 0.0) ? blend : max((1.0 - ((1.0 - base) / blend)),0.0);
}
vec3 BlendColorBurn(vec3 base, vec3 blend)
{
    return vec3(BlendColorBurn(base.r, blend.r), BlendColorBurn(base.g, blend.g), BlendColorBurn(base.b, blend.b));
}
vec3 BlendColorBurn(vec3 base, vec3 blend, float opacity)
{
    return (BlendColorBurn(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_COLORDODGE
float BlendColorDodge(float base, float blend)
{
    return (blend == 1.0) ? blend : min(base / (1.0 - blend), 1.0);
}
vec3 BlendColorDodge(vec3 base, vec3 blend)
{
    return vec3(BlendColorDodge(base.r, blend.r), BlendColorDodge(base.g, blend.g), BlendColorDodge(base.b, blend.b));
}
vec3 BlendColorDodge(vec3 base, vec3 blend, float opacity)
{
    return (BlendColorDodge(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_DARKEN
float BlendDarken(float base, float blend)
{
    return min(blend,base);
}
vec3 BlendDarken(vec3 base, vec3 blend)
{
    return vec3(BlendDarken(base.r,blend.r), BlendDarken(base.g,blend.g), BlendDarken(base.b,blend.b));
}
vec3 BlendDarken(vec3 base, vec3 blend, float opacity)
{
    return (BlendDarken(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_DIFFERENCE
vec3 BlendDifference(vec3 base, vec3 blend)
{
    return abs(base - blend);
}
vec3 BlendDifference(vec3 base, vec3 blend, float opacity)
{
    return (BlendDifference(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_EXCLUSION
vec3 BlendExclusion(vec3 base, vec3 blend)
{
    return base + blend - 2.0 * base * blend;
}
vec3 BlendExclusion(vec3 base, vec3 blend, float opacity)
{
    return (BlendExclusion(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_LIGHTEN
float BlendLighten(float base, float blend)
{
    return max(blend,base);
}
vec3 BlendLighten(vec3 base, vec3 blend)
{
    return vec3(BlendLighten(base.r,blend.r), BlendLighten(base.g,blend.g), BlendLighten(base.b,blend.b));
}
vec3 BlendLighten(vec3 base, vec3 blend, float opacity)
{
    return (BlendLighten(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

#ifdef AMAZING_USE_BLENDMODE_LINEARDODGE
float BlendLinearDodge(float base, float blend)
{
    return min(base + blend, 1.0);
}
vec3 BlendLinearDodge(vec3 base, vec3 blend)
{
    return min(base + blend,vec3(1.0));
}
vec3 BlendLinearDodge(vec3 base, vec3 blend, float opacity)
{
    return (BlendLinearDodge(base, blend) * opacity + base * (1.0 - opacity));
}
#endif

void main()
{
    vec3 world_view = normalize(u_WorldSpaceCameraPos.xyz - g_vary_WorldPosition);
    vec3 world_normal = normalize(g_vary_WorldNormal);
    vec4 tex_color = texture2D(u_AlbedoTexture, fTexCoord);
    tex_color.rgb = InvGammaColor(tex_color.rgb);
    vec3 diffColor = tex_color.rgb;
    float shiness = u_Shininess;
    vec3 speColor = u_SpecularColor.rgb;
    float translucency = tex_color.a * u_Translucency;

#ifdef AMAZING_USE_BLENDMODE_GLASS
    diffColor *= InvGammaColor(translucency);
#endif

    vec3 lightColor = vec3(0.0);

#ifdef AE_DirLightNum
#if (AE_DirLightNum > 0)
    vec3 dirColor = BlinnPhongShading(world_normal, world_view, -u_DirLightsDirection[0], diffColor, speColor, shiness);
    lightColor += dirColor * u_DirLightsIntensity[0] * u_DirLightsColor[0] * u_DirLightsEnabled[0];
#endif
#endif

#ifdef AE_PointLightNum
#if (AE_PointLightNum > 0)
    vec3 light_dir0 = (u_PointLightsPosition[0] - g_vary_WorldPosition) * u_PointLightsAttenRangeInv[0];
    float light_dist0 = length(light_dir0);
    vec3 light_normal_dir0 = light_dir0 / light_dist0;
    float nl0 = max(0.0, dot(world_normal, light_normal_dir0));
    float fall_off0 = pow(clamp(1.0 - pow(light_dist0 / 1.0, 4.0), 0.0, 1.0), 2.0) * PI / (4.0 * PI) * (pow(light_dist0, 2.0) + 1.0) * nl0;
    vec3 pointColor = BlinnPhongShading( world_normal, world_view, light_normal_dir0, diffColor, speColor, shiness);
    lightColor += pointColor * u_PointLightsIntensity[0] * u_PointLightsColor[0] * u_PointLightsEnabled[0];
#endif
#endif

    vec3 color = vec3(0.0);
#ifdef UseLight
    color = diffColor * u_AmbientLightIntensity + lightColor * tex_color.a;
#else
    color = diffColor;
#endif




    color += u_EmissiveColor.rgb;

    vec2 screen_coord = g_vary_ScreenCoord * 0.5 + vec2(0.5, 0.5);

#ifdef AMAZING_USE_BLENDMODE_COLOREDGLASS
    vec4 framecolor = texture2D(u_FBOTexture, screen_coord);
    vec3 framebuffer = InvGammaColor(framecolor.rgb);
    vec3 transmitted = framebuffer * mix(vec3(1.0), diffColor, translucency);
    translucency = 1.0;
    color += transmitted;
#endif

    vec3 final_color = GammaColor(color);


#ifdef AMAZING_USE_BLENDMODE_MUTIPLAY
    vec4 framecolor = textureFromFBO(screen_coord);
    vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
    final_color = BlendMultiply(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_OVERLAY
     vec4 framecolor = textureFromFBO(screen_coord);
     vec3 framebuffer = framecolor.rgb;
     // vec3 framebuffer = InvGammaColor(framecolor.rgb);
     final_color = BlendOverlay(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_ADD
   vec4 framecolor = textureFromFBO(screen_coord);
   vec3 framebuffer = InvGammaColor(framecolor.rgb);
   final_color = BlendAdd(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_SCREEN
   vec4 framecolor = textureFromFBO(screen_coord);
   vec3 framebuffer = framecolor.rgb;
   // vec3 framebuffer = InvGammaColor(framecolor.rgb);
   final_color = BlendScreen(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_SOFTLIGHT
   vec4 framecolor = textureFromFBO(screen_coord);
   vec3 framebuffer = framecolor.rgb;
   // vec3 framebuffer = InvGammaColor(framecolor.rgb);
   final_color = BlendSoftLight(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_AVERAGE
     vec4 framecolor = textureFromFBO(screen_coord);
     vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
     final_color = BlendAverage(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_COLORBURN
     vec4 framecolor = textureFromFBO(screen_coord);
     vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
     final_color = BlendColorBurn(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_COLORDODGE
    vec4 framecolor = textureFromFBO(screen_coord);
    vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
    final_color = BlendColorDodge(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_DARKEN
    vec4 framecolor = textureFromFBO(screen_coord);
    vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
    final_color = BlendDarken(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_DIFFERENCE
    vec4 framecolor = textureFromFBO(screen_coord);
    vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
    final_color = BlendDifference(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_EXCLUSION
    vec4 framecolor = textureFromFBO(screen_coord);
    vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
    final_color = BlendExclusion(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_LIGHTEN
    vec4 framecolor = textureFromFBO(screen_coord);
    vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
    final_color = BlendLighten(final_color, framebuffer, translucency);
#endif

#ifdef AMAZING_USE_BLENDMODE_LINEARDODGE
    vec4 framecolor = textureFromFBO(screen_coord);
    vec3 framebuffer = framecolor.rgb;
    // vec3 framebuffer = InvGammaColor(framecolor.rgb);
    final_color = BlendLinearDodge(final_color, framebuffer, translucency);
#endif

    gl_FragColor = vec4(final_color, translucency * u_opacity);
}


