#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float intensity;
    float opacity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 texCoord [[user(texCoord)]];
    float2 sucaiTexCoord [[user(sucaiTexCoord)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> u_FBOTexture [[texture(0)]], texture2d<float> sucaiImageTexture [[texture(1)]], sampler u_FBOTextureSmplr [[sampler(0)]], sampler sucaiImageTextureSmplr [[sampler(1)]])
{
    main0_out out = {};
    float4 _175 = u_FBOTexture.sample(u_FBOTextureSmplr, in.texCoord);
    float4 _93 = sucaiImageTexture.sample(sucaiImageTextureSmplr, in.sucaiTexCoord) * fast::clamp(buffer.intensity * buffer.opacity, 0.0, 1.0);
    float _98 = _175.w;
    float _108 = _93.w;
    float3 _123 = fast::clamp(_175.xyz / float3(fma(step(0.0, -_98), 9.9999999747524270787835121154785e-07, _98)), float3(0.0), float3(1.0));
    out.gl_FragColor = float4(mix(_123, (_123 * fast::clamp(_93.xyz / float3(fma(step(0.0, -_108), 9.9999999747524270787835121154785e-07, _108)), float3(0.0), float3(1.0))) * 1.0, float3(_108)) * fma(_108, 1.0 - _98, _98), _98);
    return out;
}

