#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float intensity;
    float opacity;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 texCoord [[user(texCoord)]];
    float2 sucaiTexCoord [[user(sucaiTexCoord)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> u_FBOTexture [[texture(0)]], texture2d<float> sucaiImageTexture [[texture(1)]], sampler u_FBOTextureSmplr [[sampler(0)]], sampler sucaiImageTextureSmplr [[sampler(1)]])
{
    main0_out out = {};
    float4 _238 = u_FBOTexture.sample(u_FBOTextureSmplr, in.texCoord);
    float4 _148 = sucaiImageTexture.sample(sucaiImageTextureSmplr, in.sucaiTexCoord);
    float4 _157 = _148 * fast::clamp(buffer.intensity * buffer.opacity, 0.0, 1.0);
    float _161 = _238.w;
    float _171 = _157.w;
    float3 _186 = fast::clamp(_238.xyz / float3(fma(step(0.0, -_161), 9.9999999747524270787835121154785e-07, _161)), float3(0.0), float3(1.0));
    float3 _194 = fast::clamp(_157.xyz / float3(fma(step(0.0, -_171), 9.9999999747524270787835121154785e-07, _171)), float3(0.0), float3(1.0));
    float _275 = _186.x;
    float _277 = _194.x;
    float _404;
    if (_277 < 0.5)
    {
        _404 = fma(2.0 * _275, _277, (_275 * _275) * fma(-2.0, _277, 1.0));
    }
    else
    {
        _404 = fma(sqrt(_275), fma(2.0, _277, -1.0), (2.0 * _275) * (1.0 - _277));
    }
    float _280 = _186.y;
    float _282 = _194.y;
    float _405;
    if (_282 < 0.5)
    {
        _405 = fma(2.0 * _280, _282, (_280 * _280) * fma(-2.0, _282, 1.0));
    }
    else
    {
        _405 = fma(sqrt(_280), fma(2.0, _282, -1.0), (2.0 * _280) * (1.0 - _282));
    }
    float _285 = _186.z;
    float _287 = _194.z;
    float _406;
    if (_287 < 0.5)
    {
        _406 = fma(2.0 * _285, _287, (_285 * _285) * fma(-2.0, _287, 1.0));
    }
    else
    {
        _406 = fma(sqrt(_285), fma(2.0, _287, -1.0), (2.0 * _285) * (1.0 - _287));
    }
    out.gl_FragColor = float4(mix(_186, float3(_404, _405, _406) * 1.0, float3(_171)) * fma(_171, 1.0 - _161, _161), _161);
    return out;
}

