#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    int openMouth;
    float intensity;
    float opacity;
    int isOpacityTexture;
    float4 color;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 texCoord [[user(texCoord)]];
    float2 sucaiTexCoord [[user(sucaiTexCoord)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> u_FBOTexture [[texture(0)]], texture2d<float> openSucaiImageTexture [[texture(1)]], texture2d<float> closeSucaiImageTexture [[texture(2)]], sampler u_FBOTextureSmplr [[sampler(0)]], sampler openSucaiImageTextureSmplr [[sampler(1)]], sampler closeSucaiImageTextureSmplr [[sampler(2)]])
{
    main0_out out = {};
    float4 _202 = u_FBOTexture.sample(u_FBOTextureSmplr, in.texCoord);
    float4 _244;
    if (buffer.openMouth > 0)
    {
        _244 = openSucaiImageTexture.sample(openSucaiImageTextureSmplr, in.sucaiTexCoord);
    }
    else
    {
        _244 = closeSucaiImageTexture.sample(closeSucaiImageTextureSmplr, in.sucaiTexCoord);
    }
    float4 _109 = _244 * fast::clamp(buffer.intensity * buffer.opacity, 0.0, 1.0);
    float4 _245;
    if (buffer.isOpacityTexture > 0)
    {
        _245 = buffer.color * _109.x;
    }
    else
    {
        _245 = _109;
    }
    float _126 = _202.w;
    float3 _151 = fast::clamp(_202.xyz / float3(fma(step(0.0, -_126), 9.9999999747524270787835121154785e-07, _126)), float3(0.0), float3(1.0));
    float _186 = fma(_245.w, 1.0 - _126, _126);
    out.gl_FragColor = float4(mix(_151, (_151 * fast::clamp(_245.xyz / float3(fma(step(0.0, -_245.w), 9.9999999747524270787835121154785e-07, _245.w)), float3(0.0), float3(1.0))) * 1.0, float3(_245.w)) * _186, _186);
    return out;
}

