#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float intensity;
    float opacity;
    float enableReflect;
    float reflectIntensity;
    float reflectOpacity;
};

constant float4 _239 = {};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 texCoord [[user(texCoord)]];
    float2 sucaiTexCoord [[user(sucaiTexCoord)]];
    float weight [[user(weight)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], texture2d<float> sucaiImageTexture [[texture(1)]], texture2d<float> reflectImageTexture [[texture(2)]], sampler inputImageTextureSmplr [[sampler(0)]], sampler sucaiImageTextureSmplr [[sampler(1)]], sampler reflectImageTextureSmplr [[sampler(2)]])
{
    main0_out out = {};
    float4 _84 = inputImageTexture.sample(inputImageTextureSmplr, in.texCoord);
    float4 _90 = sucaiImageTexture.sample(sucaiImageTextureSmplr, in.sucaiTexCoord);
    float _96 = _90.w;
    float3 _98 = _90.xyz / float3(_96);
    float4 _227 = _239;
    _227.x = _98.x;
    float4 _229 = _227;
    _229.y = _98.y;
    float4 _231 = _229;
    _231.z = _98.z;
    float3 _122 = _84.xyz;
    float3 _134 = mix(_122, fast::clamp(_231.xyz, float3(0.0), float3(1.0)), float3((_96 * buffer.intensity) * buffer.opacity));
    float3 _235;
    if (buffer.enableReflect > 0.5)
    {
        float4 _146 = reflectImageTexture.sample(reflectImageTextureSmplr, in.sucaiTexCoord);
        _235 = mix(_134, fma(_134 - float3(1.0), float3(1.0) - fast::clamp(_146.xyz, float3(0.0), float3(1.0)), float3(1.0)) * 1.0, float3((buffer.reflectIntensity * _146.w) * buffer.reflectOpacity));
    }
    else
    {
        _235 = _134;
    }
    out.gl_FragColor = float4(mix(_122, _235, float3(in.weight)), _84.w);
    return out;
}

