#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 texCoord [[user(texCoord)]];
    float2 maskTexCoord [[user(maskTexCoord)]];
};

fragment main0_out main0(main0_in in [[stage_in]], texture2d<float> inputImageTexture [[texture(0)]], texture2d<float> maskImageTexture [[texture(1)]], sampler inputImageTextureSmplr [[sampler(0)]], sampler maskImageTextureSmplr [[sampler(1)]])
{
    main0_out out = {};
    out.gl_FragColor = inputImageTexture.sample(inputImageTextureSmplr, in.texCoord) * maskImageTexture.sample(maskImageTextureSmplr, in.maskTexCoord).x;
    return out;
}

