--@input float curTime = 0.0{"widget":"slider","min":0,"max":3.0}
--@input float kira1_scale = 1.
--@input float kira2_scale = 1.
--@input float kira1_bright = 1.
--@input float kira2_bright = 1.
--@input float kira3_scale = 1.
--@input float kira3_bright = 1.
--@input float s1 = 1.
--@input float s2 = 1.
--@input float s3 = 1.
--@input float s4 = 1.
--@input float s5 = 1.
--@input float s6 = 1.
--@input float s7 = 1.
--@input float original_size = 720.

local kiraTextureUniform = "u_KiraTexture"

local exports = exports or {}
local Script1626078584 = Script1626078584 or {}
Script1626078584.__index = Script1626078584
function Script1626078584.new(construct, ...)
    local self = setmetatable({}, Script1626078584)
    if construct and Script1626078584.constructor then Script1626078584.constructor(self, ...) end
    self.startTime = 0.0
    self.endTime = 3.0
    self.curTime = 0.0
    self.width = 0
    self.height = 0
    self.ratio = {0.5625, 0.75, 1.0, 1.3333, 1.7777}
    self.number = {3, 2, 1, 1, 1}
    self.offset = {0, 1, 0, 0, 0}
    self.offsetX = 0
    self.offsetY = 0
    self.zoom_factor = 0.38
    self.isChangeIntensity = true
    self.scale = 200 --13
    self.kiraNum = 64
    self.MeshRenderer = nil
    self.resolution_scale = 1.0
    self.firstIn = 0.
    self.time2 = 0.0
    self.touchState = false
    self.shoot_state = false
    return self
end


local function remap(beforeMin, beforeMax, afterMin, afterMax, intensity)
    return (afterMax - afterMin) * (intensity - beforeMin) / (beforeMax - beforeMin) + afterMin
end

function Script1626078584:constructor()

end



function Script1626078584:createCustomMesh()
    local customMesh = Amaz.Mesh()
    local customSubMesh = Amaz.SubMesh()
    customSubMesh.primitive = Amaz.Primitive.TRIANGLES
    if customMesh and customSubMesh then
    -- Amaz.LOGD("guoyi", " =========== custom mesh & submesh created ")
    end

    local pos = Amaz.VertexAttribDesc()
    pos.semantic = Amaz.VertexAttribType.POSITION



    local uv = Amaz.VertexAttribDesc()
    uv.semantic = Amaz.VertexAttribType.TEXCOORD0
    -- local color = Amaz.VertexAttribDesc()
    -- color.semantic = Amaz.VertexAttribType.COLOR
    local vads = Amaz.Vector()
    vads:pushBack(pos)
    vads:pushBack(uv)


    -- vads:pushBack(color)
    customMesh.vertexAttribs = vads

    local vertexData = {}
    local indexData = {}

    for i = 0, self.kiraNum - 1 do
        for j = 0, self.kiraNum - 1 do
            for vertexIndex = 1, 4 do
                local point = {}
                point[1] = i * 1 / self.kiraNum + 1 / (self.kiraNum * 2)
                point[2] = j * 1 / self.kiraNum  + 1 / (self.kiraNum * 2)
                local scale = self.scale
                -- local r = math.random()
                -- local g = math.random()
                -- local b = math.random()
                local angle = math.random() * 90
                table.insert(vertexData, #vertexData + 1, point[2])
                table.insert(vertexData, #vertexData + 1, point[1])
                table.insert(vertexData, #vertexData + 1, scale)

                local uv = {}
                local width = 1.0
                if vertexIndex == 1 then
                    uv.x = -width;
                    uv.y = width;
                elseif vertexIndex ==  2 then
                    uv.x = width;
                    uv.y = width;
                elseif vertexIndex ==  3 then
                    uv.x = width;
                    uv.y = -width;
                else
                    uv.x = -width;
                    uv.y = -width;
                end

                table.insert(vertexData, #vertexData + 1, uv.x)
                table.insert(vertexData, #vertexData + 1, uv.y)


            end
            local index = ((i * self.kiraNum) + j)*4
            table.insert(indexData, #indexData + 1, 0 + index)
            table.insert(indexData, #indexData + 1, 1 + index)
            table.insert(indexData, #indexData + 1, 3 + index)
            table.insert(indexData, #indexData + 1, 1 + index)
            table.insert(indexData, #indexData + 1, 2 + index)
            table.insert(indexData, #indexData + 1, 3 + index)
        end

    end

    local fv = Amaz.FloatVector()
    for i = 1, table.getn(vertexData) do
        fv:pushBack(vertexData[i])
    end
    customMesh.vertices = fv

    local indices = Amaz.UInt16Vector()
    for i = 1, table.getn(indexData) do
        indices:pushBack(indexData[i])
    end
    customSubMesh.indices16 = indices
    customSubMesh.mesh = customMesh
    customMesh:addSubMesh(customSubMesh)


    return customMesh
end


function Script1626078584:onUpdate(comp, detalTime)
    --
    -- local props = comp.entity:getComponent("ScriptComponent").properties
    -- if props:has("curTime") then
    --     self:seekToTime(comp, props:get("curTime") - self.startTime)
    -- end
    --
    -- self.curTime = self.curTime + detalTime
    self:seekToTime(comp, self.curTime - self.startTime)
end

function Script1626078584:onStart(comp)
    
    self.props = comp.properties
    self.meshComp = comp.entity:getComponent("MeshRenderer")
    -- self.material = comp.entity.scene:findEntityBy("1"):getComponent("MeshRenderer").material
    self.customMesh = self:createCustomMesh()
    self.meshComp.mesh = self.customMesh

    -- configure algorithm params
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_0_bright_low", 100)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_0_bright_high", 150) 
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_0_area_low", 0)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_0_area_high", 2500)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_1_bright_low", 150)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_1_bright_high", 200) 
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_1_area_low", 0)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_1_area_high", 2500)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_2_bright_low", 200)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_2_bright_high", 255) 
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_2_area_low", 0)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_2_area_high", 2500)
    Amaz.Algorithm.setAlgorithmParamInt("", "kira_0", "kira_group_num", 3) 
    Amaz.Algorithm.setAlgorithmParamFloat("", "kira_0", "kira_ratio", 0.5)
  

    -- create kira texture
    self.MeshRenderer = self.meshComp
    if self.MeshRenderer then
        --self.MeshRenderer.useFrustumCulling = false
        -- self.MeshRenderer.mesh.clearAfterUpload = false
        local tex = Amaz.Texture2D()
        tex.filterMin = Amaz.FilterMode.NEAREST
        tex.filterMag = Amaz.FilterMode.NEAREST
        
        self.MeshRenderer.material:setTex(kiraTextureUniform, tex)
    end

    self.pass0Material =comp.entity.scene:findEntityBy("kira1626078584"):getComponent("MeshRenderer").material
    self.pass5Material = comp.entity.scene:findEntityBy("Pass5"):getComponent("MeshRenderer").material
    self.Pass5table = comp.entity.scene:findEntityBy("Pass5"):getComponent("TableComponent").table    
    self.pass6Material = comp.entity.scene:findEntityBy("Pass6"):getComponent("MeshRenderer").material
    
    self.pass0Material:setFloat("flagFloat", 1.)
    self.pass5Material:setFloat("flagFloat", 1.)

    -- Amaz.Algorithm.setAlgorithmEnable(comp.entity.scene.name, "kira_0", false) 
    -- Amaz.Algorithm.setAlgorithmEnable(comp.entity.scene.name, "kira_0", true) 
    self.highlightMaterial = comp.entity.scene:findEntityBy("highLight"):getComponent("MeshRenderer").material

    self.blurMaterial1 = comp.entity.scene:findEntityBy("blur1"):getComponent("MeshRenderer").material
    self.blurMaterial2 = comp.entity.scene:findEntityBy("blur2"):getComponent("MeshRenderer").material
    local w = Amaz.BuiltinObject:getInputTextureWidth()
    local h = Amaz.BuiltinObject:getInputTextureHeight()

    self.blurMaterial1:setFloat("baseTexWidth", w)
    self.blurMaterial1:setFloat("baseTexHeight", h)
    self.blurMaterial2:setFloat("baseTexWidth", w)
    self.blurMaterial2:setFloat("baseTexHeight", h)
    self.highlightMaterial["inputWidth"] = w
    self.highlightMaterial["inputHeight"] = h
    local intensity = 0.8
    self.GlowRange = intensity*200.0
    if self.GlowRange > 100 then
        self.blurMaterial1:setInt('u_RightBlur', 1)
        self.blurMaterial2:setInt('u_RightBlur2', 1)
    else
        self.blurMaterial1:setInt('u_RightBlur', 0)
        self.blurMaterial2:setInt('u_RightBlur2', 0)
    end
    local range = math.abs(self.GlowRange-100)
    local myrange1 = math.ceil(math.sqrt(range))
    if myrange1 == 0 then
        myrange1 = 0.5
    end
    local y_index =range/myrange1
    local myrange2 = math.ceil(y_index)
    self.blurMaterial1:setFloat("GlowRange",myrange1)
    self.blurMaterial1:setFloat("y_indez", y_index)
    self.blurMaterial2:setFloat("GlowRange",myrange2) 
    
    local intensity2 = 0.7
    self.blurMaterial2:setFloat("alpha", intensity2)
end

local function speed1(time)
    local scale = 0.0
    scale = math.abs(math.sin(time))
    return scale
end
function Script1626078584:seekToTime(comp, time)
    -- if self.first == nil then
    --     self.first = true
    --     self:start(comp)
    -- end
    self.count = self.count or 0
    self.count = self.count + 1 
    -- if self.count >1 then
    --     Amaz.Algorithm.setAlgorithmEnable(comp.entity.scene.name, "kira_0", true) 
    -- end
    -- else
    --     return
    -- end
    local w = Amaz.BuiltinObject:getInputTextureWidth()
    local h = Amaz.BuiltinObject:getInputTextureHeight()
    local original_size = 720
    -- self.pass0Material:setFloat("original_size",  self.props:find("original_size"))
    self.pass0Material:setFloat("original_size",  original_size)

    
    if w ~= self.width or h ~= self.height then
        -- if math.abs(w/(h + 0.0001) - self.width/(self.height + 0.0001)) > 0.001 then
        --     self.blurMaterial1:setFloat("baseTexWidth", w)
        --     self.blurMaterial1:setFloat("baseTexHeight", h)
        --     self.blurMaterial2:setFloat("baseTexWidth", w)
        --     self.blurMaterial2:setFloat("baseTexHeight", h)
        -- -- self.combMaterial["inputWidth"] = self.width
        --     --self.combMaterial["inputHeight"] = self.height
        --     self.highlightMaterial["inputWidth"] = w
        --     self.highlightMaterial["inputHeight"] = h
        -- end
        -- if self.width ~= 0 and (w < self.width and h < self.height and math.abs(w/(h+0.01) - self.width/(self.height+0.01))<0.1)  then
        --     self.touchState = true
        --     self.meshComp.material["sizeScale"] = w/self.width
        -- else
        --     self.meshComp.material["sizeScale"] = 1.0
        -- end
        -- self.pass0Material:setFloat("imageWidth", w)
        -- self.firstIn = self.firstIn + 1
        if self.width ~= 0 and self.width ~= w then
            self.touchState = true
        end
        self.width = w
        self.height = h
        -- if w > 0 and not self.init_state then
        -- self.init_state = true
        self.meshComp.material["screenSize"] = Amaz.Vector2f(self.width , self.height)
        
    end

    -- if self.Pass5table ~=nil then
    --     local shoot = self.Pass5table:get("shoot")
    --     if shoot == 1 then
    --         self.shoot_state = true
    --         self.Pass5table:set("shoot",0)
    --     else
    --         self.shoot_state = false
    --     end
        

    -- end
    Amaz.LOGI("wdg=====","state:"..tostring(self.touchState))
    local algorithm = Amaz.Algorithm.getAEAlgorithmResult()
    local kira = algorithm:getKiraInfo()
    local KiraPoints = kira and kira.points

    --paizhaoshihoutingdiao
    if kira and  self.touchState == false then
        self.MeshRenderer.material:getTex(kiraTextureUniform):storage(kira.mask)
        self.MeshRenderer.material["u_KiraNum"] = KiraPoints:size()
        -- self.touchState = true
    end

    self.time2 = self.time2 + 1.0

    

    local rot = self.meshComp.material:getFloat("kiraNumber")
    Amaz.Algorithm.setAlgorithmParamFloat("", "kira_0", "kira_ratio", 0.5)

    -- local final_corners_num = KiraPoints:size()
    -- for i = 1,final_corners_num do 
    --     local cur_corner = KiraPoints:get(i-1)  
    -- end

    self.MeshRenderer.material:setFloat("kira1_scale", self.props:find("kira1_scale"))
    self.MeshRenderer.material:setFloat("kira2_scale", self.props:find("kira2_scale"))
    self.MeshRenderer.material:setFloat("kira3_scale", self.props:find("kira3_scale"))

    self.MeshRenderer.material:setFloat("kira1_bright", self.props:find("kira1_bright"))
    self.MeshRenderer.material:setFloat("kira2_bright", self.props:find("kira2_bright"))
    self.MeshRenderer.material:setFloat("kira3_bright", self.props:find("kira3_bright"))

    local scale1 = speed1(2*1.5*time + 0.3) + 0.2
    if scale1 > 1.0 then
        scale1 = 1.0
    end
    local scale2 = speed1(2*time + 0.0) + 0.4
    if scale2 > 1.0 then
        scale2 = 1.0
    end

    local scale3 = speed1(2*1.3*time - 0.25)
    local scale4 = speed1(2*2.5*time - 0.1)

    -- self.pass0Material:setFloat("time", 0.5 * scale1)
    
    -- self.pass0Material["speed"] = Amaz.Vector4f(1.0,1.0,1.0,1.0)
    local rand = math.random() 
    self.pass0Material:setFloat("randValue", rand)
    self.sizeIntensity = self.sizeIntensity or 0.33
    self.pass0Material:setFloat("scaleSize", (2.3 * self.sizeIntensity))
    self.numberIntensity = self.numberIntensity or 1.0
    self.pass0Material:setFloat("numberIntensity", 1.0- self.numberIntensity)

    self.Intensity = self.Intensity or 1.0
    -- Amaz.Algorithm.setAlgorithmParamFloat("", "kira_0", "kira_ratio", self.ratioIntensity or 1.0)
    -- self.pass0Material:setFloat("Rotation", self.rotation*360)
    self.pass0Material:setFloat("strength", self.Intensity)
    -- Amaz.LOGI("zsd", rand)
    -- self.time2 = self.time2 + 0.2

end

function Script1626078584:onEvent(sys, event)

    if "effects_adjust_size" == event.args:get(0) then
        local intensity = event.args:get(1)
        self.sizeIntensity = intensity * 1.0
        self.Intensity = math.sqrt(intensity) * 0.8
    end

    if "effects_adjust_number" == event.args:get(0) then
        local intensity = event.args:get(1)
        self.numberIntensity = intensity
    end

    if "effects_adjust_filter" == event.args:get(0) then
        local intensity = event.args:get(1)
        self.alpha = intensity
        self.pass6Material:setFloat("uniAlpha", intensity)
        self.pass5Material:setFloat("sucaiAlpha", intensity)
    end


    -- if "Internal_Alpha" == event.args:get(0) then
    --     local intensity = event.args:get(2)
    --     self.Intensity = intensity
    -- end
    if("effects_adjust_texture" == event.args:get(0)) then
        local intensity = event.args:get(1)
        self.highlightMaterial:setFloat("lowValue", 1.0-intensity)
    end
    if (event.type == Amaz.EventType.TOUCH) then -- touch event
        local touch_phase = event.args:get(0)
        if (touch_phase.type == Amaz.TouchType.TOUCH_BEGAN) then
            self.touchState = true
        end
    end 
    -- if("Internal_Noise" == event.args:get(0)) then
    --     local intensity = event.args:get(2)
    --     -- print("Noise_intensity = ",intensity)
    --     self.pass5Material:setFloat("slider_value", intensity*2.0)
    -- end

end
exports.Script1626078584 = Script1626078584
return exports
