#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float baseTexWidth;
    float y_indez;
    int u_RightBlur2;
    float GlowRange;
    float alpha;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv [[user(uv)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], texture2d<float> oriImageTexture [[texture(1)]], sampler inputImageTextureSmplr [[sampler(0)]], sampler oriImageTextureSmplr [[sampler(1)]])
{
    main0_out out = {};
    float _101 = 2.0 / buffer.baseTexWidth;
    float4 _328;
    _328 = inputImageTexture.sample(inputImageTextureSmplr, in.uv);
    float _331;
    float _332;
    float4 _333;
    float4 _334;
    float _327 = 1.0;
    float _329 = 1.0;
    for (;;)
    {
        if (_327 < 11.0)
        {
            float _118 = _327 * _101;
            float _122 = fma(_118, buffer.y_indez, in.uv.x);
            float _236 = step(0.0, in.uv.y);
            float _241 = (step(0.0, _122) * _236) * step(_122, 1.0);
            float _244 = step(in.uv.y, 1.0);
            float4 _133 = inputImageTexture.sample(inputImageTextureSmplr, float2(_122, in.uv.y));
            float4 _138 = _328 + (_133 * (_241 * _244));
            float _142 = fma(_241, _244, _329);
            if (buffer.u_RightBlur2 > 0)
            {
                float _159 = fma(-_118, buffer.y_indez, in.uv.x);
                float _258 = (step(0.0, _159) * _236) * step(_159, 1.0);
                _334 = _138 + (inputImageTexture.sample(inputImageTextureSmplr, float2(_159, in.uv.y)) * (_258 * _244));
                _332 = fma(_258, _244, _142);
            }
            else
            {
                _334 = _138;
                _332 = _142;
            }
            if (_327 > buffer.GlowRange)
            {
                _333 = _334;
                _331 = _332;
                break;
            }
            _329 = _332;
            _328 = _334;
            _327 += 1.0;
            continue;
        }
        else
        {
            _333 = _328;
            _331 = _329;
            break;
        }
    }
    float4 _191 = _333 / float4(_331);
    float4 _196 = oriImageTexture.sample(oriImageTextureSmplr, in.uv);
    float _209 = _196.w;
    out.gl_FragColor = mix(_196, float4(fma(_196.x - 1.0, 1.0 - _191.x, 1.0), fma(_196.y - 1.0, 1.0 - _191.y, 1.0), fma(_196.z - 1.0, 1.0 - _191.z, 1.0), _209), float4(buffer.alpha * 0.800000011920928955078125));
    out.gl_FragColor = float4(out.gl_FragColor.xyz, _209);
    return out;
}

