
precision highp float;
varying vec2 uv;
uniform sampler2D inputImageTexture;
uniform sampler2D oriImageTexture;
// uniform sampler2D combImageTexture;
uniform float GlowRange; 
uniform float baseTexWidth;
uniform float baseTexHeight;
uniform float y_indez;
uniform float alpha;
uniform int u_RightBlur2;
float uvProtect(vec2 samplerTexCoord)
{
    return step(0.,samplerTexCoord.x)*step(0.,samplerTexCoord.y)*step(samplerTexCoord.x,1.0)*step(samplerTexCoord.y,1.0);
}
float blendScreen(float base, float blend) {
    return 1.0-((1.0-base)*(1.0-blend));
}

vec3 blendScreen(vec3 base, vec3 blend) {
    return vec3(blendScreen(base.r,blend.r),blendScreen(base.g,blend.g),blendScreen(base.b,blend.b));
}
void main()
{
    vec4 inputColor = texture2D(inputImageTexture, uv);
    vec4 result = inputColor;
    float sum = 1.0;
    float dx = 2.0 / baseTexWidth ;
    for(float j=1.0 ; j < 11. ; j+= 1.0)
    {
        // left
        vec2 samplerTexCoord = vec2(uv.x + j*dx*y_indez, uv.y);
        float uvPro = uvProtect(samplerTexCoord);
        vec4 tc = texture2D(inputImageTexture, samplerTexCoord);
        result += tc*uvPro;
        sum += 1.0*uvPro;
        //}
        
        //right
        if (u_RightBlur2>0) {
            vec2 samplerTexCoord1 = vec2(uv.x - j*dx*y_indez, uv.y );
            uvPro = uvProtect(samplerTexCoord1);
            vec4 tc1 = texture2D(inputImageTexture,samplerTexCoord1);
            result += tc1*uvPro;
            sum += 1.0*uvPro;
        }
        if(j>GlowRange)
        break;
    }
    result/=(sum);
    // vec4 combColor = texture2D(combImageTexture, uv) ;
    vec4 oriCol=texture2D(oriImageTexture, uv);
    gl_FragColor =mix(oriCol,vec4(blendScreen(oriCol.rgb,result.rgb),oriCol.a),alpha*0.8);
    gl_FragColor = vec4(gl_FragColor.rgb, oriCol.a);

}
 