#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float rx;
    int imageWidth;
    float ry;
    int imageHeight;
    float gx;
    float gy;
    float bx;
    float by;
    float flagFloat;
    float sucaiAlpha;
};

constant float _357 = {};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 textureCoordinate [[user(textureCoordinate)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], texture2d<float> sucaiTexture [[texture(1)]], texture2d<float> alphaTexture [[texture(2)]], sampler inputImageTextureSmplr [[sampler(0)]], sampler sucaiTextureSmplr [[sampler(1)]], sampler alphaTextureSmplr [[sampler(2)]])
{
    main0_out out = {};
    float4 _100 = inputImageTexture.sample(inputImageTextureSmplr, in.textureCoordinate);
    float _112 = float(buffer.imageWidth);
    float _118 = float(buffer.imageHeight);
    float4 _122 = inputImageTexture.sample(inputImageTextureSmplr, (in.textureCoordinate + float2(buffer.rx / _112, buffer.ry / _118)));
    float4 _139 = inputImageTexture.sample(inputImageTextureSmplr, (in.textureCoordinate + float2(buffer.gx / _112, buffer.gy / _118)));
    float4 _156 = inputImageTexture.sample(inputImageTextureSmplr, (in.textureCoordinate + float2(buffer.bx / _112, buffer.by / _118)));
    float3 _344;
    if (buffer.flagFloat < 0.001000000047497451305389404296875)
    {
        _344 = _100.xyz;
    }
    else
    {
        _344 = float4(_122.x, _139.y, _156.z, _357).xyz;
    }
    float4 _179 = sucaiTexture.sample(sucaiTextureSmplr, in.textureCoordinate);
    float _217 = _179.x;
    float _345;
    if (_217 < 0.5)
    {
        _345 = fma(2.0 * _344.x, _217, (_344.x * _344.x) * fma(-2.0, _217, 1.0));
    }
    else
    {
        _345 = fma(sqrt(_344.x), fma(2.0, _217, -1.0), (2.0 * _344.x) * (1.0 - _217));
    }
    float _222 = _179.y;
    float _346;
    if (_222 < 0.5)
    {
        _346 = fma(2.0 * _344.y, _222, (_344.y * _344.y) * fma(-2.0, _222, 1.0));
    }
    else
    {
        _346 = fma(sqrt(_344.y), fma(2.0, _222, -1.0), (2.0 * _344.y) * (1.0 - _222));
    }
    float _227 = _179.z;
    float _347;
    if (_227 < 0.5)
    {
        _347 = fma(2.0 * _344.z, _227, (_344.z * _344.z) * fma(-2.0, _227, 1.0));
    }
    else
    {
        _347 = fma(sqrt(_344.z), fma(2.0, _227, -1.0), (2.0 * _344.z) * (1.0 - _227));
    }
    out.gl_FragColor = float4(mix(_344, float3(_345, _346, _347), float3(buffer.sucaiAlpha)), alphaTexture.sample(alphaTextureSmplr, in.textureCoordinate).w);
    return out;
}

