precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform sampler2D alphaTexture;
uniform float rx;
uniform float ry;
uniform float gx;
uniform float gy;
uniform float bx;
uniform float by;
uniform float flagFloat;
uniform int imageWidth;
uniform int imageHeight;
uniform float m_resolution_scale;

uniform sampler2D sucaiTexture;
uniform float uTime;
uniform float slider_value;
uniform float sucaiAlpha;
float blendSoftLight(float base, float blend) {
    return (blend<0.5)?(2.0*base*blend+base*base*(1.0-2.0*blend)):(sqrt(base)*(2.0*blend-1.0)+2.0*base*(1.0-blend));
}

vec3 blendSoftLight(vec3 base, vec3 blend) {
    return vec3(blendSoftLight(base.r,blend.r),blendSoftLight(base.g,blend.g),blendSoftLight(base.b,blend.b));
}
float random (vec2 st) {
    return fract(sin(dot(st.xy,vec2(12.9898,78.233)))* 43758.5453123);
}

float noise (vec2 st) {
    vec2 i = floor(st);
    vec2 f = fract(st);

    // Four corners in 2D of a tile
    float a = random(i);
    float b = random(i + vec2(1.0, 0.0));
    float c = random(i + vec2(0.0, 1.0));
    float d = random(i + vec2(1.0, 1.0));

    // Smooth Interpolation

    // Cubic Hermine Curve.  Same as SmoothStep()
    vec2 u = f*f*(3.0-2.0*f);
    // u = smoothstep(0.,1.,f);

    // Mix 4 coorners percentages
    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}
vec4 setNoise(vec4 color1,vec2 uv)
{
    float strengthPower = 1.0 * slider_value;
    float strength = 16.0 * strengthPower;
    //float x = (uv.x + 4.0) * (uv.y + 4.0) * (uTime* 10.0);
    float x = (uv.x + random(uv)) * (uv.y + random(uv)) * ((mod(uTime,100.0)+3.0) * 10.0 * slider_value);
    vec4 grain =vec4(mod((mod(x, 13.0) + 1.0) * (mod(x, 123.0) + 1.0), 0.01) - (0.005 * (1.0 - step(slider_value, 0.0)))) *strength;
//    vec4 grain =vec4(mod((mod(x, 13.0) + 1.0) * (mod(x, 123.0) + 1.0), 0.01) - 0.005) *strength;
    return color1 + grain;
}
void main() {
   
    // color shift
    vec2 uv = textureCoordinate;
    vec4 baseColor = texture2D(inputImageTexture, uv);
    vec4 blendColor = vec4(1);
    blendColor.r = texture2D(inputImageTexture, uv + vec2(rx / float(imageWidth), ry/float(imageHeight))).r;
    blendColor.g = texture2D(inputImageTexture, uv + vec2(gx / float(imageWidth), gy/float(imageHeight))).g;
    blendColor.b = texture2D(inputImageTexture, uv + vec2(bx / float(imageWidth), by/float(imageHeight))).b;
    blendColor.a = baseColor.a;
    vec3 resultCol;
    if (flagFloat < 0.001) {
        resultCol = baseColor.rgb;
    }
    else {
        resultCol = blendColor.rgb;
        
    }
    vec4 sucaiCol=texture2D(sucaiTexture,uv);
    resultCol=mix(resultCol,blendSoftLight(resultCol,sucaiCol.rgb),sucaiAlpha);
    //resultCol=setNoise(vec4(resultCol,1.0),uv).rgb;
    gl_FragColor = vec4(resultCol,texture2D(alphaTexture, uv).a);
}
