#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float baseTexWidth;
    float y_indez;
    int u_RightBlur;
    float GlowRange;
};

struct main0_out
{
    float4 gl_FragColor [[color(0)]];
};

struct main0_in
{
    float2 uv [[user(uv)]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> inputImageTexture [[texture(0)]], sampler inputImageTextureSmplr [[sampler(0)]])
{
    main0_out out = {};
    float _54 = 2.0 / buffer.baseTexWidth;
    float4 _193;
    _193 = inputImageTexture.sample(inputImageTextureSmplr, in.uv);
    float _196;
    float _197;
    float4 _198;
    float4 _199;
    float _192 = 1.0;
    float _194 = 1.0;
    for (;;)
    {
        if (_192 < 11.0)
        {
            float _71 = _192 * _54;
            float _75 = fma(_71, buffer.y_indez, in.uv.x);
            float _157 = step(0.0, in.uv.y);
            float _162 = (step(0.0, _75) * _157) * step(_75, 1.0);
            float _165 = step(in.uv.y, 1.0);
            float4 _86 = inputImageTexture.sample(inputImageTextureSmplr, float2(_75, in.uv.y));
            float4 _91 = _193 + (_86 * (_162 * _165));
            float _95 = fma(_162, _165, _194);
            if (buffer.u_RightBlur > 0)
            {
                float _112 = fma(-_71, buffer.y_indez, in.uv.x);
                float _179 = (step(0.0, _112) * _157) * step(_112, 1.0);
                _199 = _91 + (inputImageTexture.sample(inputImageTextureSmplr, float2(_112, in.uv.y)) * (_179 * _165));
                _197 = fma(_179, _165, _95);
            }
            else
            {
                _199 = _91;
                _197 = _95;
            }
            if (_192 > buffer.GlowRange)
            {
                _198 = _199;
                _196 = _197;
                break;
            }
            _194 = _197;
            _193 = _199;
            _192 += 1.0;
            continue;
        }
        else
        {
            _198 = _193;
            _196 = _194;
            break;
        }
    }
    out.gl_FragColor = _198 / float4(_196);
    return out;
}

