#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct buffer_t
{
    float u_KiraSizeRandomMin;
    float u_KiraSizeRandomMax;
    float u_KiraSizeEnableRandom;
    float2 screenSize;
    float scaleSize;
    float kira2_scale;
    float numberIntensity;
};

struct main0_out
{
    float4 v_Color [[user(v_Color)]];
    float2 textureCoordinate [[user(textureCoordinate)]];
    float4 v_NoiseData [[user(v_NoiseData)]];
    float weight_kira [[user(weight_kira)]];
    float4 gl_Position [[position]];
};

struct main0_in
{
    float3 position [[attribute(0)]];
    float2 texcoord0 [[attribute(1)]];
};

vertex main0_out main0(main0_in in [[stage_in]], constant buffer_t& buffer, texture2d<float> u_KiraTexture [[texture(0)]], texture2d<float> u_NoiseTexture [[texture(1)]], texture2d<float> u_albedo1 [[texture(2)]], texture2d<float> u_mask [[texture(3)]], sampler u_KiraTextureSmplr [[sampler(0)]], sampler u_NoiseTextureSmplr [[sampler(1)]], sampler u_albedo1Smplr [[sampler(2)]], sampler u_maskSmplr [[sampler(3)]])
{
    main0_out out = {};
    out.textureCoordinate = in.texcoord0;
    float4 _60 = u_KiraTexture.sample(u_KiraTextureSmplr, (in.position.xy - float2(0.00390625, 0.0)), level(0.0));
    float4 _64 = u_KiraTexture.sample(u_KiraTextureSmplr, (in.position.xy + float2(0.00390625, 0.0)), level(0.0));
    float2 _84 = float2(fma(_60.y, 0.0039215688593685626983642578125, _60.x), fma(_60.w, 0.0039215688593685626983642578125, _60.z));
    out.weight_kira = fma(_64.y, 0.0039215688593685626983642578125, _64.x);
    float _97 = _64.z;
    float4 _102 = u_NoiseTexture.sample(u_NoiseTextureSmplr, _84, level(0.0));
    out.v_NoiseData = _102;
    float _112 = floor(_102.x * 10.0) * 0.100000001490116119384765625;
    float _328;
    if ((_112 < 0.300000011920928955078125) && (_112 > 0.100000001490116119384765625))
    {
        _328 = 0.070000000298023223876953125;
    }
    else
    {
        float _329;
        if ((_112 < 0.5) && (_112 > 0.300000011920928955078125))
        {
            _329 = 0.100000001490116119384765625;
        }
        else
        {
            float _330;
            if ((_112 < 0.85000002384185791015625) && (_112 > 0.5))
            {
                _330 = 0.60000002384185791015625;
            }
            else
            {
                _330 = ((_112 < 1.10000002384185791015625) && (_112 > 0.85000002384185791015625)) ? 2.0 : _112;
            }
            _329 = _330;
        }
        _328 = _329;
    }
    float _173 = mix(1.0, fma(_328, buffer.u_KiraSizeRandomMax - buffer.u_KiraSizeRandomMin, buffer.u_KiraSizeRandomMin), buffer.u_KiraSizeEnableRandom);
    float2 _178 = (_84 - float2(0.5)) * 2.0;
    out.gl_Position = float4(_178, 0.0, 1.0);
    out.v_Color = u_albedo1.sample(u_albedo1Smplr, _84, level(0.0));
    float4 _191 = u_mask.sample(u_maskSmplr, _84, level(0.0));
    float _211 = _191.x;
    bool _212 = _211 < 0.100000001490116119384765625;
    bool _219;
    if (_212)
    {
        _219 = _191.w > 0.999000012874603271484375;
    }
    else
    {
        _219 = _212;
    }
    float _335;
    if (_219)
    {
        _335 = (((in.position.z * _97) * _173) * 0.5) * step(0.300000011920928955078125, _328);
    }
    else
    {
        _335 = ((in.position.z * _97) * _173) * 1.10000002384185791015625;
    }
    bool _243 = _211 > 0.100000001490116119384765625;
    bool _249;
    if (_243)
    {
        _249 = _191.y < 0.100000001490116119384765625;
    }
    else
    {
        _249 = _243;
    }
    out.gl_Position = float4(_178 + (float2(in.texcoord0.x, (in.texcoord0.y * buffer.screenSize.x) / buffer.screenSize.y) * (0.004999999888241291046142578125 * (((((_249 ? 0.0 : _335) * (buffer.screenSize.y / buffer.screenSize.x)) * buffer.scaleSize) * buffer.kira2_scale) * step(buffer.numberIntensity, fma(sin(pow(1.0 / (out.gl_Position.x + 0.00999999977648258209228515625), 4.0)), 0.5, 0.5))))), 0.0, 1.0);
    out.gl_Position.z = (out.gl_Position.z + out.gl_Position.w) * 0.5;       // Adjust clip-space for Metal
    return out;
}

