precision highp float;

attribute vec3 position;
attribute vec2 texcoord0;
uniform sampler2D u_albedo1;
uniform sampler2D u_mask;
uniform sampler2D u_KiraTexture;
uniform sampler2D noiseTexture;
uniform sampler2D u_NoiseTexture;

uniform float u_KiraSizeEnableRandom;
uniform float u_KiraSizeRandomMin;
uniform float u_KiraSizeRandomMax;
uniform vec4 speed;
varying vec4 v_Color;
uniform float timer;
varying highp vec2 textureCoordinate;
varying vec4 v_NoiseData;
uniform float imageWidth;
uniform float original_size;
varying float weight_kira;
uniform float numberIntensity;
uniform vec2 screenSize;
uniform float scaleSize;
uniform float kira2_scale;
uniform float sizeScale;

float remapValue(float inputValue, float inputMin, float inputMax, float outputMin, float outputMax)
{
    return inputValue / (inputMax - inputMin) * (outputMax - outputMin) + outputMin;
}

void main()
{
    textureCoordinate = texcoord0;
    vec2 pos0 = position.xy - vec2(1.0 / 256.0, 0.0);
    vec2 pos1 = pos0 + vec2(1.0 / 128.0, 0.0);
    vec4 color0 = texture2D(u_KiraTexture, pos0);
    vec4 color1 = texture2D(u_KiraTexture, pos1); 
    vec2 pos = vec2(color0.r + color0.g / 255.0, color0.b + color0.a / 255.0);
    float weight = color1.r + color1.g / 255.0;
    weight_kira = weight;
    float flag = color1.b;
    vec4 noiseData = texture2D(u_NoiseTexture, pos.xy);
    v_NoiseData = noiseData;

    float r = floor(noiseData.r*10.0)/10.0;
    float n = noiseData.r;
    if (r < 0.3 && r > 0.1)
    {
        r = 0.07;
    }
    else if (r < 0.5 && r > 0.3)
    {
        r = 0.1;
    }
    else if (r < 0.85 && r > 0.5)
    {
        r = 0.6;
    }else if(r < 1.1&& r > 0.85)
    {
        r = 2.0;
    }
    float spriteSizeRandom = remapValue(r, 0.0, 1.0, u_KiraSizeRandomMin, u_KiraSizeRandomMax);
    spriteSizeRandom = mix(1.0, spriteSizeRandom, u_KiraSizeEnableRandom);

    // gl_PointSize = position.z * flag*spriteSizeRandom * 10.;
    gl_Position = vec4((pos - 0.5) * 2.0, 0.0, 1.0);
    v_Color = texture2D(u_albedo1, pos);
    vec4 maskColor = texture2D(u_mask, pos);
    // float resol = imageWidth / original_size;
    float ratio = screenSize.y/screenSize.x;
    float finalScale = 1.0;
    float pt = sin(pow(1.0/(gl_Position.x+0.01),4.0));

    if (maskColor.r < 0.1 && maskColor.a > 0.999 ) {
        finalScale = position.z * flag*spriteSizeRandom * 0.5*step(0.3,r);
    }
    else {
        finalScale = position.z * flag*spriteSizeRandom * 1.1;
    }

    if(maskColor.r > 0.1 && maskColor.g < 0.1) {
         finalScale =  0.;
    }


    finalScale = finalScale*ratio*scaleSize*kira2_scale;
    // if (abs(sin(pos.y * 67.)) > numberIntensity) gl_PointSize = 0.;

    float percent = step(numberIntensity,pt*0.5+0.5 );
    finalScale = finalScale*percent;

    vec2 finalPos =  0.005*finalScale*vec2(texcoord0.x,texcoord0.y*screenSize.x/screenSize.y);
    gl_Position = vec4((pos - 0.5) * 2.0 + finalPos, 0.0, 1.0);


    // noiseColor = texture2D(u_albedo1, vec2(pos.x + timer, pos.y + timer));
}
